/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.utils;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceTimeoutException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.net.SocketTimeoutException;

public class ServiceExceptionFactory {
    public static ServiceException process(String serviceName, ServiceException exception) {
        Throwable cause;
        for (Throwable scan = cause = exception.getCause(); scan != null; scan = scan.getCause()) {
            Class<?> scanClass = scan.getClass();
            if (ServiceException.class.isAssignableFrom(scanClass)) {
                return ServiceExceptionFactory.populate(exception, serviceName, (ServiceException)scan);
            }
            if (UniformInterfaceException.class.isAssignableFrom(scanClass)) {
                return ServiceExceptionFactory.populate(exception, serviceName, (UniformInterfaceException)scan);
            }
            if (!SocketTimeoutException.class.isAssignableFrom(scanClass)) continue;
            return ServiceExceptionFactory.populate(exception, serviceName, (SocketTimeoutException)scan);
        }
        exception.setServiceName(serviceName);
        return exception;
    }

    static ServiceException populate(ServiceException exception, String serviceName, UniformInterfaceException cause) {
        ClientResponse response;
        exception.setServiceName(serviceName);
        if (cause != null && (response = cause.getResponse()) != null) {
            ClientResponse.Status status = response.getClientResponseStatus();
            if (status == null) {
                status = ClientResponse.Status.fromStatusCode((int)response.getStatus());
            }
            if (status == null) {
                exception.setHttpStatusCode(response.getStatus());
            } else {
                exception.setHttpStatusCode(status.getStatusCode());
                exception.setHttpReasonPhrase(status.getReasonPhrase());
            }
            if (response.hasEntity()) {
                try {
                    String body = (String)response.getEntity(String.class);
                    exception.setRawResponseBody(body);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return exception;
    }

    static ServiceException populate(ServiceException exception, String serviceName, ServiceException cause) {
        exception.setServiceName(cause.getServiceName());
        exception.setHttpStatusCode(cause.getHttpStatusCode());
        exception.setHttpReasonPhrase(cause.getHttpReasonPhrase());
        exception.setErrorCode(cause.getErrorCode());
        exception.setErrorMessage(cause.getErrorMessage());
        exception.setRawResponseBody(cause.getRawResponseBody());
        exception.setErrorValues(cause.getErrorValues());
        return exception;
    }

    static ServiceException populate(ServiceException exception, String serviceName, SocketTimeoutException cause) {
        ServiceTimeoutException newException = new ServiceTimeoutException(cause.getMessage(), cause);
        newException.setServiceName(serviceName);
        return newException;
    }
}

