/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.utils;

import com.microsoft.windowsazure.services.core.utils.ConnectionStringSyntaxException;
import com.microsoft.windowsazure.services.core.utils.pipeline.ConnectionStringField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ParsedConnectionString {
    private String connectionString;
    private int currentIndex;
    private String currentKey;
    private String currentValue;

    public ParsedConnectionString(String connectionString) throws ConnectionStringSyntaxException {
        this.connectionString = connectionString + ';';
        this.currentIndex = 0;
        this.matchConnectionString();
    }

    private char currentChar() {
        return this.connectionString.charAt(this.currentIndex);
    }

    private void consumeChar() {
        ++this.currentIndex;
    }

    private boolean charsLeft() {
        return this.currentIndex < this.connectionString.length();
    }

    private boolean matchConnectionString() throws ConnectionStringSyntaxException {
        if (!this.matchAttribute()) {
            throw new ConnectionStringSyntaxException(String.format("Could not parse connection string '%1$s'", this.connectionString));
        }
        boolean moreAttributes = true;
        while (moreAttributes) {
            int bookmark = this.currentIndex;
            boolean separators = false;
            while (this.matchSeparator()) {
                separators = true;
            }
            moreAttributes = separators && this.matchAttribute();
            if (moreAttributes) continue;
            this.currentIndex = bookmark;
        }
        while (this.matchSeparator()) {
        }
        if (!this.matchEND()) {
            throw new ConnectionStringSyntaxException(String.format("Expected end of connection string '%1$s', did not get it", this.connectionString));
        }
        return true;
    }

    private boolean matchAttribute() throws ConnectionStringSyntaxException {
        this.matchSpacing();
        if (this.matchKeyValuePair()) {
            return true;
        }
        int bookmark = this.currentIndex;
        boolean matchedSeparator = this.matchSeparator();
        this.currentIndex = bookmark;
        return matchedSeparator;
    }

    private boolean matchKeyValuePair() throws ConnectionStringSyntaxException {
        if (!this.charsLeft()) {
            return false;
        }
        if (!this.matchKey()) {
            throw new ConnectionStringSyntaxException(String.format("Expected key in connection string '%1$s' at position %2$d but did not find one", this.connectionString, this.currentIndex));
        }
        if (!this.matchEquals()) {
            throw new ConnectionStringSyntaxException(String.format("Expected '=' character in connection string '%1$s' after key near position %2$d", this.connectionString, this.currentIndex));
        }
        if (!this.matchValue()) {
            throw new ConnectionStringSyntaxException(String.format("Expected value in connection string '%1$s' for key '%3$s' at position %2$d but did not find one", this.connectionString, this.currentIndex, this.currentKey));
        }
        this.saveValue(this.currentKey, this.currentValue);
        return true;
    }

    private boolean matchKey() throws ConnectionStringSyntaxException {
        return this.matchQuotedKey() || this.matchRawKey();
    }

    private boolean matchQuotedKey() throws ConnectionStringSyntaxException {
        if (!this.charsLeft()) {
            return false;
        }
        String value = "";
        char quote = this.currentChar();
        int bookmark = this.currentIndex;
        if (quote == '\"' || quote == '\'') {
            this.consumeChar();
            while (this.charsLeft() && this.currentChar() != quote) {
                value = value + this.currentChar();
                this.consumeChar();
            }
            if (!this.charsLeft()) {
                throw new ConnectionStringSyntaxException(String.format("Unterminated quoted value in string '%1$s', starting at character %2$d", this.connectionString, bookmark));
            }
            this.consumeChar();
            this.currentKey = value;
            return true;
        }
        return false;
    }

    private boolean matchRawKey() throws ConnectionStringSyntaxException {
        if (!this.charsLeft()) {
            return false;
        }
        String value = "";
        int bookmark = this.currentIndex;
        while (this.charsLeft() && !this.matchEquals()) {
            value = value + this.currentChar();
            this.consumeChar();
            bookmark = this.currentIndex;
        }
        if (!this.charsLeft()) {
            throw new ConnectionStringSyntaxException(String.format("Expected '=' in connection string '%1$s', key started at index %2$d", this.connectionString, bookmark));
        }
        this.currentIndex = bookmark;
        this.currentKey = value;
        return true;
    }

    private boolean matchEquals() {
        int bookmark = this.currentIndex;
        this.matchSpacing();
        if (this.charsLeft() && this.currentChar() == '=') {
            this.consumeChar();
            return true;
        }
        this.currentIndex = bookmark;
        return false;
    }

    private boolean matchValue() throws ConnectionStringSyntaxException {
        return this.matchQuotedValue() || this.matchRawValue();
    }

    private boolean matchQuotedValue() throws ConnectionStringSyntaxException {
        String value = "";
        char quote = this.currentChar();
        int bookmark = this.currentIndex;
        if (quote == '\"' || quote == '\'') {
            this.consumeChar();
            while (this.charsLeft() && this.currentChar() != quote) {
                value = value + this.currentChar();
                this.consumeChar();
            }
            if (!this.charsLeft()) {
                throw new ConnectionStringSyntaxException(String.format("Unterminated quoted value in string '%1$s', starting at character %2$d", this.connectionString, bookmark));
            }
            this.consumeChar();
            this.currentValue = value;
            return true;
        }
        return false;
    }

    private boolean matchRawValue() {
        String value = "";
        int bookmark = this.currentIndex;
        while (this.charsLeft() && !this.matchSeparator()) {
            value = value + this.currentChar();
            this.consumeChar();
            bookmark = this.currentIndex;
        }
        this.currentIndex = bookmark;
        this.currentValue = value;
        return true;
    }

    private boolean matchSeparator() {
        int bookmark = this.currentIndex;
        this.matchSpacing();
        if (this.charsLeft() && this.currentChar() == ';') {
            this.consumeChar();
            return true;
        }
        this.currentIndex = bookmark;
        return false;
    }

    private boolean matchSpacing() {
        while (this.matchWS()) {
        }
        return true;
    }

    private boolean matchWS() {
        if (this.charsLeft() && (this.currentChar() == ' ' || this.currentChar() == '\t')) {
            this.consumeChar();
            return true;
        }
        return false;
    }

    private boolean matchEND() {
        return this.currentIndex >= this.connectionString.length();
    }

    protected void saveValue(String key, String value) throws ConnectionStringSyntaxException {
        try {
            Method setter = this.findSetter(key);
            setter.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectionStringSyntaxException(String.format("The key '%1$s' is not valid for this connection string", key), e);
        }
        catch (InvocationTargetException e) {
            throw new ConnectionStringSyntaxException(String.format("Could not invoke setter for key '%1$s'", key), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectionStringSyntaxException(String.format("Setter for key '%1$s' is not accessible in class %2$s", key, this.getClass().getName()), e);
        }
    }

    private Method findSetter(String key) throws NoSuchMethodException {
        Class<?> thisClass = this.getClass();
        for (Method m : thisClass.getDeclaredMethods()) {
            if (!this.methodMatches(m, key)) continue;
            return m;
        }
        throw new NoSuchMethodException();
    }

    private boolean methodMatches(Method method, String key) {
        return this.matchesViaAnnotation(method, key) || this.matchesByName(method, key);
    }

    private boolean matchesViaAnnotation(Method method, String key) {
        ConnectionStringField annotation = method.getAnnotation(ConnectionStringField.class);
        return annotation != null && annotation.name().toLowerCase().equals(key.toLowerCase());
    }

    private boolean matchesByName(Method method, String key) {
        return method.getName().toLowerCase().equals("set" + key.toLowerCase());
    }
}

