/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.Canonicalizer;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;

class TableLiteCanonicalizer
extends Canonicalizer {
    private static final int ExpectedTableLiteCanonicalizedStringLength = 150;

    TableLiteCanonicalizer() {
    }

    @Override
    protected String canonicalize(HttpURLConnection conn, String accountName, Long contentLength, OperationContext opContext) throws StorageException {
        if (contentLength < -1L) {
            throw new InvalidParameterException("ContentLength must be set to -1 or positive Long value");
        }
        String dateString = Utility.getStandardHeaderValue(conn, "x-ms-date");
        if (Utility.isNullOrEmpty(dateString)) {
            throw new IllegalArgumentException("Canonicalization did not find a non empty x-ms-date header in the request. Please use a request with a valid x-ms-date header in RFC 123 format.");
        }
        StringBuilder canonicalizedString = new StringBuilder(150);
        canonicalizedString.append(dateString);
        TableLiteCanonicalizer.appendCanonicalizedElement(canonicalizedString, TableLiteCanonicalizer.getCanonicalizedResourceLite(conn.getURL(), accountName));
        return canonicalizedString.toString();
    }
}

