/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.AuthenticationScheme;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.RequestResult;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public abstract class StorageOperation<C, P, R> {
    private StorageException exceptionReference;
    private boolean nonExceptionedRetryableFailure;
    private RequestOptions requestOptions;
    private RequestResult result;
    private HttpURLConnection connection;

    protected StorageOperation() {
    }

    public StorageOperation(RequestOptions options) {
        this.setRequestOptions(options);
    }

    public abstract R execute(C var1, P var2, OperationContext var3) throws Exception;

    public final StorageException getException() {
        return this.exceptionReference;
    }

    public final RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public final RequestResult getResult() {
        return this.result;
    }

    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    protected final void initialize(OperationContext opContext) {
        RequestResult currResult = new RequestResult();
        this.setResult(currResult);
        opContext.appendRequestResult(currResult);
        this.setException(null);
        this.setNonExceptionedRetryableFailure(false);
    }

    public final boolean isNonExceptionedRetryableFailure() {
        return this.nonExceptionedRetryableFailure;
    }

    protected final StorageException materializeException(HttpURLConnection request, OperationContext opContext) {
        if (this.getException() != null) {
            return this.getException();
        }
        return StorageException.translateException(request, null, opContext);
    }

    public final void signRequest(ServiceClient client, HttpURLConnection request, long contentLength, OperationContext context) throws InvalidKeyException, StorageException {
        if (client.getAuthenticationScheme() == AuthenticationScheme.SHAREDKEYFULL) {
            client.getCredentials().signBlobAndQueueRequest(request, contentLength, context);
        } else {
            client.getCredentials().signBlobAndQueueRequestLite(request, contentLength, context);
        }
    }

    public final void signTableRequest(ServiceClient client, HttpURLConnection request, long contentLength, OperationContext context) throws InvalidKeyException, StorageException {
        if (client.getAuthenticationScheme() == AuthenticationScheme.SHAREDKEYFULL) {
            client.getCredentials().signTableRequest(request, contentLength, context);
        } else {
            client.getCredentials().signTableRequestLite(request, contentLength, context);
        }
    }

    protected final void setException(StorageException exceptionReference) {
        this.exceptionReference = exceptionReference;
    }

    public final void setNonExceptionedRetryableFailure(boolean nonExceptionedRetryableFailure) {
        this.nonExceptionedRetryableFailure = nonExceptionedRetryableFailure;
    }

    protected final void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    public final void setResult(RequestResult result) {
        this.result = result;
    }

    public final void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }
}

