/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.SegmentedStorageOperation;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LazySegmentedIterator<CLIENT_TYPE, PARENT_TYPE, ENTITY_TYPE>
implements Iterator<ENTITY_TYPE> {
    private ResultSegment<ENTITY_TYPE> currentSegment;
    private Iterator<ENTITY_TYPE> currentSegmentIterator;
    private final CLIENT_TYPE client;
    private final PARENT_TYPE parentObject;
    private final RetryPolicyFactory policyFactory;
    private final SegmentedStorageOperation<CLIENT_TYPE, PARENT_TYPE, ResultSegment<ENTITY_TYPE>> segmentGenerator;
    private final OperationContext opContext;

    public LazySegmentedIterator(SegmentedStorageOperation<CLIENT_TYPE, PARENT_TYPE, ResultSegment<ENTITY_TYPE>> segmentGenerator, CLIENT_TYPE client, PARENT_TYPE parent, RetryPolicyFactory policyFactory, OperationContext opContext) {
        this.segmentGenerator = segmentGenerator;
        this.parentObject = parent;
        this.opContext = opContext;
        this.policyFactory = policyFactory;
        this.client = client;
    }

    @Override
    @DoesServiceRequest
    public boolean hasNext() {
        while (this.currentSegment == null || !this.currentSegmentIterator.hasNext() && this.currentSegment != null && this.currentSegment.getHasMoreResults()) {
            try {
                this.currentSegment = ExecutionEngine.executeWithRetry(this.client, this.parentObject, this.segmentGenerator, this.policyFactory, this.opContext);
            }
            catch (StorageException e) {
                NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
                ex.initCause(e);
                throw ex;
            }
            this.currentSegmentIterator = this.currentSegment.getResults().iterator();
            if (this.currentSegmentIterator.hasNext() || this.currentSegment.getHasMoreResults()) continue;
            return false;
        }
        return this.currentSegmentIterator.hasNext();
    }

    @Override
    public ENTITY_TYPE next() {
        return this.currentSegmentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

