/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.Canonicalizer;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;

final class BlobQueueFullCanonicalizer
extends Canonicalizer {
    BlobQueueFullCanonicalizer() {
    }

    @Override
    protected String canonicalize(HttpURLConnection conn, String accountName, Long contentLength, OperationContext opContext) throws StorageException {
        if (contentLength < -1L) {
            throw new InvalidParameterException("ContentLength must be set to -1 or positive Long value");
        }
        return BlobQueueFullCanonicalizer.canonicalizeHttpRequest(conn.getURL(), accountName, conn.getRequestMethod(), Utility.getStandardHeaderValue(conn, "Content-Type"), contentLength, null, conn, opContext);
    }
}

