/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.blob.client.CopyState;
import com.microsoft.windowsazure.services.blob.client.CopyStatus;
import com.microsoft.windowsazure.services.core.storage.LeaseDuration;
import com.microsoft.windowsazure.services.core.storage.LeaseState;
import com.microsoft.windowsazure.services.core.storage.LeaseStatus;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ServiceProperties;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class BaseResponse {
    public static String getContentMD5(HttpURLConnection request) {
        return request.getHeaderField("Content-MD5");
    }

    public static String getDate(HttpURLConnection request) {
        String retString = request.getHeaderField("Date");
        return retString == null ? request.getHeaderField("x-ms-date") : retString;
    }

    public static String getEtag(HttpURLConnection request) {
        return request.getHeaderField("Etag");
    }

    public static HashMap<String, String> getMetadata(HttpURLConnection request) {
        return BaseResponse.getValuesByHeaderPrefix(request, "x-ms-meta-");
    }

    public static LeaseStatus getLeaseStatus(HttpURLConnection request) {
        String leaseStatus = request.getHeaderField("x-ms-lease-status");
        if (!Utility.isNullOrEmpty(leaseStatus)) {
            return LeaseStatus.parse(leaseStatus);
        }
        return LeaseStatus.UNSPECIFIED;
    }

    public static LeaseState getLeaseState(HttpURLConnection request) {
        String leaseState = request.getHeaderField("x-ms-lease-state");
        if (!Utility.isNullOrEmpty(leaseState)) {
            return LeaseState.parse(leaseState);
        }
        return LeaseState.UNSPECIFIED;
    }

    public static LeaseDuration getLeaseDuration(HttpURLConnection request) {
        String leaseDuration = request.getHeaderField("x-ms-lease-duration");
        if (!Utility.isNullOrEmpty(leaseDuration)) {
            return LeaseDuration.parse(leaseDuration);
        }
        return LeaseDuration.UNSPECIFIED;
    }

    public static CopyState getCopyState(HttpURLConnection request) throws URISyntaxException, ParseException {
        String copyStatusString = request.getHeaderField("x-ms-copy-status");
        if (!Utility.isNullOrEmpty(copyStatusString)) {
            String copyCompletionTimeString;
            String copySourceString;
            CopyState copyState = new CopyState();
            copyState.setStatus(CopyStatus.parse(copyStatusString));
            copyState.setCopyId(request.getHeaderField("x-ms-copy-id"));
            copyState.setStatusDescription(request.getHeaderField("x-ms-copy-status-description"));
            String copyProgressString = request.getHeaderField("x-ms-copy-progress");
            if (!Utility.isNullOrEmpty(copyProgressString)) {
                String[] progressSequence = copyProgressString.split("/");
                copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            }
            if (!Utility.isNullOrEmpty(copySourceString = request.getHeaderField("x-ms-copy-source"))) {
                copyState.setSource(new URI(copySourceString));
            }
            if (!Utility.isNullOrEmpty(copyCompletionTimeString = request.getHeaderField("x-ms-copy-completion-time"))) {
                copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(copyCompletionTimeString));
            }
            return copyState;
        }
        return null;
    }

    public static String getRequestId(HttpURLConnection request) {
        return request.getHeaderField("x-ms-request-id");
    }

    private static HashMap<String, String> getValuesByHeaderPrefix(HttpURLConnection request, String prefix) {
        HashMap<String, String> retVals = new HashMap<String, String>();
        Map<String, List<String>> headerMap = request.getHeaderFields();
        int prefixLength = prefix.length();
        for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
            List<String> currHeaderValues = entry.getValue();
            retVals.put(entry.getKey().substring(prefixLength), currHeaderValues.get(0));
        }
        return retVals;
    }

    public static ServiceProperties readServicePropertiesFromStream(InputStream inStream, OperationContext opContext) throws XMLStreamException, StorageException {
        return ServiceProperties.readServicePropertiesFromStream(inStream, opContext);
    }

    protected BaseResponse() {
    }
}

