/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.Credentials;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ServiceProperties;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageKey;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.Canonicalizer;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.CanonicalizerFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public final class BaseRequest {
    private static String userAgent;

    public static void addLeaseId(HttpURLConnection request, String leaseId) {
        if (leaseId != null) {
            BaseRequest.addOptionalHeader(request, "x-ms-lease-id", leaseId);
        }
    }

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                BaseRequest.addMetadata(request, entry.getKey(), entry.getValue(), opContext);
            }
        }
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        Utility.assertNotNullOrEmpty("value", value);
        request.setRequestProperty("x-ms-meta-" + name, value);
    }

    public static void addOptionalHeader(HttpURLConnection request, String name, String value) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(name, value);
        }
    }

    public static void addSnapshot(UriQueryBuilder builder, String snapshotVersion) throws StorageException {
        if (snapshotVersion != null) {
            builder.add("snapshot", snapshotVersion);
        }
    }

    public static HttpURLConnection create(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection createURLConnection(URI uri, int timeoutInMs, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        if (timeoutInMs != 0) {
            builder.add("timeout", String.valueOf(timeoutInMs / 1000));
        }
        URL resourceUrl = builder.addToURI(uri).toURL();
        HttpURLConnection retConnection = (HttpURLConnection)resourceUrl.openConnection();
        retConnection.setReadTimeout(timeoutInMs);
        retConnection.setRequestProperty("x-ms-version", "2012-02-12");
        retConnection.setRequestProperty("User-Agent", BaseRequest.getUserAgent());
        retConnection.setRequestProperty("x-ms-client-request-id", opContext.getClientRequestID());
        retConnection.setRequestProperty("Content-Type", "");
        return retConnection;
    }

    public static HttpURLConnection delete(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("DELETE");
        return retConnection;
    }

    public static HttpURLConnection getMetadata(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "metadata");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getServiceProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", "service");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("%s/%s", "WA-Storage", "Client v0.1.3.2");
        }
        return userAgent;
    }

    public static byte[] serializeServicePropertiesToByteArray(ServiceProperties properties, OperationContext opContext) throws XMLStreamException, StorageException {
        return properties.serializeToByteArray(opContext);
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "metadata");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection setServiceProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", "service");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static void signRequestForBlobAndQueue(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength, opContext);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForBlobAndQueueSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength, opContext);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForTableSharedKey(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength, opContext);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForTableSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength, opContext);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    private BaseRequest() {
    }
}

