/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestResult;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultContinuationType;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAnonymous;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageErrorCode;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.StreamMd5AndLength;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class Utility {
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    public static final Locale LOCALE_US = Locale.US;
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String ISO8061_PATTERN_NO_SECONDS = "yyyy-MM-dd'T'HH:mm'Z'";
    public static final String ISO8061_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO8061_LONG_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";

    public static StreamMd5AndLength analyzeStream(InputStream sourceStream, long writeLength, long abandonLength, boolean rewindSourceStream, boolean calculateMD5) throws IOException, StorageException {
        if (abandonLength < 0L) {
            abandonLength = Long.MAX_VALUE;
        }
        if (rewindSourceStream) {
            if (!sourceStream.markSupported()) {
                throw new IllegalArgumentException("Input stream must be markable!");
            }
            sourceStream.mark(0x4000000);
        }
        MessageDigest digest = null;
        if (calculateMD5) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        if (writeLength < 0L) {
            writeLength = Long.MAX_VALUE;
        }
        StreamMd5AndLength retVal = new StreamMd5AndLength();
        int count = -1;
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
        count = sourceStream.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            if (calculateMD5) {
                digest.update(retrievedBuff, 0, count);
            }
            retVal.setLength(retVal.getLength() + (long)count);
            if (retVal.getLength() > abandonLength) {
                retVal.setLength(-1L);
                retVal.setMd5(null);
                break;
            }
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
            count = sourceStream.read(retrievedBuff, 0, nextCopy);
        }
        if (retVal.getLength() != -1L && calculateMD5) {
            retVal.setMd5(Base64.encode(digest.digest()));
        }
        if (retVal.getLength() != -1L && writeLength > 0L) {
            retVal.setLength(Math.min(retVal.getLength(), writeLength));
        }
        if (rewindSourceStream) {
            sourceStream.reset();
            sourceStream.mark(0x4000000);
        }
        return retVal;
    }

    public static boolean areCredentialsEqual(StorageCredentials thisCred, StorageCredentials thatCred) {
        if (thisCred == thatCred) {
            return true;
        }
        if (thatCred == null || thisCred.getClass() != thatCred.getClass()) {
            return false;
        }
        if (thisCred instanceof StorageCredentialsAccountAndKey) {
            return ((StorageCredentialsAccountAndKey)thisCred).toString(true).equals(((StorageCredentialsAccountAndKey)thatCred).toString(true));
        }
        if (thisCred instanceof StorageCredentialsSharedAccessSignature) {
            return ((StorageCredentialsSharedAccessSignature)thisCred).getToken().equals(((StorageCredentialsSharedAccessSignature)thatCred).getToken());
        }
        if (thisCred instanceof StorageCredentialsAnonymous) {
            return true;
        }
        return thisCred.equals(thatCred);
    }

    public static void assertContinuationType(ResultContinuation continuationToken, ResultContinuationType continuationType) {
        if (continuationToken != null && continuationToken.getContinuationType() != ResultContinuationType.NONE && continuationToken.getContinuationType() != continuationType) {
            String errorMessage = String.format(LOCALE_US, "The continuation type passed in is unexpected. Please verify that the correct continuation type is passed in. Expected {%s}, found {%s}", new Object[]{continuationToken.getContinuationType(), continuationType});
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(param);
        }
    }

    public static void assertNotNullOrEmpty(String param, String value) {
        Utility.assertNotNull(param, value);
        if (Utility.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("The argument must not be an empty string or null:".concat(param));
        }
    }

    public static void assertInBounds(String param, int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("The value of the parameter %s should be between %s and %s.", param, min, max));
        }
    }

    public static XMLStreamReader createXMLStreamReaderFromStream(InputStream streamRef) throws XMLStreamException {
        XMLInputFactory xmlif = null;
        xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlif.createXMLStreamReader(streamRef);
    }

    public static XMLStreamReader createXMLStreamReaderFromReader(Reader reader) throws XMLStreamException {
        XMLInputFactory xmlif = null;
        xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlif.createXMLStreamReader(reader);
    }

    public static boolean determinePathStyleFromUri(URI baseURI, String knownAccountName) {
        String path = baseURI.getPath();
        if (knownAccountName == null) {
            return !Utility.isNullOrEmpty(path) && !path.equals("/");
        }
        if (!Utility.isNullOrEmpty(path) && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (Utility.isNullOrEmpty(path) || baseURI.getHost().startsWith(knownAccountName)) {
            return false;
        }
        return !Utility.isNullOrEmpty(path) && path.startsWith(knownAccountName);
    }

    public static StorageException generateNewUnexpectedStorageException(Exception cause) {
        StorageException exceptionRef = new StorageException(StorageErrorCode.NONE.toString(), "Unexpected internal storage client error.", 306, null, null);
        exceptionRef.initCause(cause);
        return exceptionRef;
    }

    public static byte[] getBytesFromLong(long value) {
        byte[] tempArray = new byte[8];
        for (int m = 0; m < 8; ++m) {
            tempArray[7 - m] = (byte)(value >> 8 * m & 0xFFL);
        }
        return tempArray;
    }

    protected static StorageExtendedErrorInformation getErrorDetailsFromRequest(HttpURLConnection request, OperationContext opContext) {
        if (request == null) {
            return null;
        }
        try {
            StorageErrorResponse response = new StorageErrorResponse(request.getErrorStream());
            return response.getExtendedErrorInformation();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static String getGMTTime() {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        rfc1123Format.setTimeZone(GMT_ZONE);
        return rfc1123Format.format(new Date());
    }

    public static String getTimeByZoneAndFormat(Date date, TimeZone zone, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, LOCALE_US);
        formatter.setTimeZone(zone);
        return formatter.format(date);
    }

    public static String getGMTTime(Date inDate) {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        rfc1123Format.setTimeZone(GMT_ZONE);
        return rfc1123Format.format(inDate);
    }

    public static String getStandardHeaderValue(HttpURLConnection conn, String headerName) {
        String headerValue = conn.getRequestProperty(headerName);
        return headerValue == null ? "" : headerValue;
    }

    protected static String getUTCTime() {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        rfc1123Format.setTimeZone(UTC_ZONE);
        return rfc1123Format.format(new Date());
    }

    protected static String getUTCTime(Date inDate) {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        rfc1123Format.setTimeZone(UTC_ZONE);
        return rfc1123Format.format(inDate);
    }

    public static String getUTCTimeOrEmpty(Date value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat iso8061Format = new SimpleDateFormat(ISO8061_PATTERN, LOCALE_US);
        iso8061Format.setTimeZone(UTC_ZONE);
        return iso8061Format.format(value);
    }

    public static IOException initIOException(Exception ex) {
        IOException retEx = new IOException();
        retEx.initCause(ex);
        return retEx;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static HashMap<String, String> parseAccountString(String parseString) {
        String[] valuePairs = parseString.split(";");
        HashMap<String, String> retVals = new HashMap<String, String>();
        for (int m = 0; m < valuePairs.length; ++m) {
            int equalDex = valuePairs[m].indexOf("=");
            if (equalDex < 1) {
                throw new IllegalArgumentException("Invalid Connection String");
            }
            String key = valuePairs[m].substring(0, equalDex);
            String value = valuePairs[m].substring(equalDex + 1);
            retVals.put(key, value);
        }
        return retVals;
    }

    public static Date parseDateFromString(String value, String pattern, TimeZone timeZone) throws ParseException {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(pattern, LOCALE_US);
        rfc1123Format.setTimeZone(timeZone);
        return rfc1123Format.parse(value);
    }

    public static Date parseISO8061LongDateFromString(String value) throws ParseException {
        return Utility.parseDateFromString(value, ISO8061_LONG_PATTERN, UTC_ZONE);
    }

    public static Date parseRFC1123DateFromStringInGMT(String value) throws ParseException {
        return Utility.parseDateFromString(value, RFC1123_PATTERN, GMT_ZONE);
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName) throws XMLStreamException {
        return Utility.readElementFromXMLReader(xmlr, elementName, true);
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName, boolean returnNullOnEmpty) throws XMLStreamException {
        xmlr.require(1, null, elementName);
        int eventType = xmlr.next();
        StringBuilder retVal = new StringBuilder();
        if (eventType == 4) {
            do {
                retVal.append(xmlr.getText());
            } while ((eventType = xmlr.next()) == 4);
        }
        xmlr.require(2, null, elementName);
        if (retVal.length() == 0) {
            return returnNullOnEmpty ? null : "";
        }
        return retVal.toString();
    }

    public static String safeDecode(String stringToDecode) throws StorageException {
        if (stringToDecode == null) {
            return null;
        }
        if (stringToDecode.length() == 0) {
            return "";
        }
        try {
            if (stringToDecode.contains("+")) {
                StringBuilder outBuilder = new StringBuilder();
                int startDex = 0;
                for (int m = 0; m < stringToDecode.length(); ++m) {
                    if (stringToDecode.charAt(m) != '+') continue;
                    if (m > startDex) {
                        outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, m), "UTF-8"));
                    }
                    outBuilder.append("+");
                    startDex = m + 1;
                }
                if (startDex != stringToDecode.length()) {
                    outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, stringToDecode.length()), "UTF-8"));
                }
                return outBuilder.toString();
            }
            return URLDecoder.decode(stringToDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static String safeEncode(String stringToEncode) throws StorageException {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        try {
            String tString = URLEncoder.encode(stringToEncode, "UTF-8");
            if (stringToEncode.contains(" ")) {
                StringBuilder outBuilder = new StringBuilder();
                int startDex = 0;
                for (int m = 0; m < stringToEncode.length(); ++m) {
                    if (stringToEncode.charAt(m) != ' ') continue;
                    if (m > startDex) {
                        outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, m), "UTF-8"));
                    }
                    outBuilder.append("%20");
                    startDex = m + 1;
                }
                if (startDex != stringToEncode.length()) {
                    outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, stringToEncode.length()), "UTF-8"));
                }
                return outBuilder.toString();
            }
            return tString;
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static String safeRelativize(URI baseURI, URI toUri) throws URISyntaxException {
        int m;
        if (!baseURI.getHost().equals(toUri.getHost()) || !baseURI.getScheme().equals(toUri.getScheme())) {
            return toUri.toString();
        }
        String basePath = baseURI.getPath();
        String toPath = toUri.getPath();
        int truncatePtr = 1;
        int ellipsesCount = 0;
        for (m = 0; m < basePath.length(); ++m) {
            if (m >= toPath.length()) {
                if (basePath.charAt(m) != '/') continue;
                ++ellipsesCount;
                continue;
            }
            if (basePath.charAt(m) != toPath.charAt(m)) break;
            if (basePath.charAt(m) != '/') continue;
            truncatePtr = m + 1;
        }
        if (m == toPath.length()) {
            return new URI(null, null, null, toUri.getQuery(), toUri.getFragment()).toString();
        }
        toPath = toPath.substring(truncatePtr);
        StringBuilder sb = new StringBuilder();
        while (ellipsesCount > 0) {
            sb.append("../");
            --ellipsesCount;
        }
        if (!Utility.isNullOrEmpty(toPath)) {
            sb.append(toPath);
        }
        if (!Utility.isNullOrEmpty(toUri.getQuery())) {
            sb.append("?");
            sb.append(toUri.getQuery());
        }
        if (!Utility.isNullOrEmpty(toUri.getFragment())) {
            sb.append("#");
            sb.append(toUri.getRawFragment());
        }
        return sb.toString();
    }

    protected static String trimEnd(String value, char trimChar) {
        int stopDex;
        for (stopDex = value.length() - 1; stopDex > 0 && value.charAt(stopDex) == trimChar; --stopDex) {
        }
        return stopDex == value.length() - 1 ? value : value.substring(stopDex);
    }

    public static String trimStart(String value) {
        int spaceDex;
        for (spaceDex = 0; spaceDex < value.length() && value.charAt(spaceDex) == ' '; ++spaceDex) {
        }
        return value.substring(spaceDex);
    }

    public static StreamMd5AndLength writeToOutputStream(InputStream sourceStream, OutputStream outStream, long writeLength, boolean rewindSourceStream, boolean calculateMD5, RequestResult currentResult, OperationContext opContext) throws IOException, StorageException {
        if (opContext != null) {
            opContext.setCurrentOperationByteCount(0L);
        } else {
            opContext = new OperationContext();
        }
        if (rewindSourceStream && sourceStream.markSupported()) {
            sourceStream.reset();
            sourceStream.mark(0x4000000);
        }
        if (calculateMD5 && opContext.getIntermediateMD5() == null) {
            try {
                opContext.setIntermediateMD5(MessageDigest.getInstance("MD5"));
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        StreamMd5AndLength retVal = new StreamMd5AndLength();
        if (writeLength < 0L) {
            writeLength = Long.MAX_VALUE;
        }
        int count = -1;
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
        count = sourceStream.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            if (outStream != null) {
                outStream.write(retrievedBuff, 0, count);
            }
            if (calculateMD5) {
                opContext.getIntermediateMD5().update(retrievedBuff, 0, count);
            }
            retVal.setLength(retVal.getLength() + (long)count);
            if (opContext != null) {
                opContext.setCurrentOperationByteCount(opContext.getCurrentOperationByteCount() + (long)count);
            }
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
            count = sourceStream.read(retrievedBuff, 0, nextCopy);
        }
        if (outStream != null) {
            outStream.flush();
        }
        if (calculateMD5) {
            retVal.setDigest(opContext.getIntermediateMD5());
        }
        return retVal;
    }

    private Utility() {
    }

    public static void checkNullaryCtor(Class<?> clazzType) {
        Constructor<?> ctor = null;
        try {
            ctor = clazzType.getDeclaredConstructor(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class type must have contain a nullary constructor.");
        }
        if (ctor == null) {
            throw new IllegalArgumentException("Class type must have contain a nullary constructor.");
        }
    }

    public static Date parseDate(String dateString) {
        try {
            if (dateString.length() == 28) {
                return Utility.parseDateFromString(dateString, ISO8061_LONG_PATTERN, UTC_ZONE);
            }
            if (dateString.length() == 20) {
                return Utility.parseDateFromString(dateString, ISO8061_PATTERN, UTC_ZONE);
            }
            if (dateString.length() == 17) {
                return Utility.parseDateFromString(dateString, ISO8061_PATTERN_NO_SECONDS, UTC_ZONE);
            }
            if (dateString.length() == 27) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", UTC_ZONE);
            }
            if (dateString.length() == 26) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSSSS'Z'", UTC_ZONE);
            }
            if (dateString.length() == 25) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSSS'Z'", UTC_ZONE);
            }
            if (dateString.length() == 24) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", UTC_ZONE);
            }
            if (dateString.length() == 23) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.SS'Z'", UTC_ZONE);
            }
            if (dateString.length() == 22) {
                return Utility.parseDateFromString(dateString, "yyyy-MM-dd'T'HH:mm:ss.S'Z'", UTC_ZONE);
            }
            throw new IllegalArgumentException(String.format("Invalid Date String: %s", dateString));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Invalid Date String: %s", dateString), e);
        }
    }
}

