/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageErrorCode;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageErrorResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import javax.xml.stream.XMLStreamException;

public class StorageException
extends Exception {
    private static final long serialVersionUID = 7972747254288274928L;
    protected String errorCode;
    protected StorageExtendedErrorInformation extendedErrorInformation;
    private final int httpStatusCode;

    protected static StorageExtendedErrorInformation getErrorDetailsFromRequest(HttpURLConnection request, OperationContext opContext) {
        if (request == null) {
            return null;
        }
        try {
            StorageErrorResponse response = new StorageErrorResponse(request.getErrorStream());
            return response.getExtendedErrorInformation();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static StorageException translateException(HttpURLConnection request, Exception cause, OperationContext opContext) {
        if (request == null) {
            return new StorageException("Client error", "A Client side exception occurred, please check the inner exception for details", 306, null, cause);
        }
        StorageExtendedErrorInformation extendedError = StorageException.getErrorDetailsFromRequest(request, opContext);
        StorageException translatedException = null;
        String responseMessage = "";
        int responseCode = 0;
        try {
            responseCode = request.getResponseCode();
            if (cause == null || cause instanceof SocketException) {
                responseMessage = request.getResponseMessage();
            } else if (cause != null) {
                responseMessage = cause.getMessage();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (responseMessage == null) {
            responseMessage = "";
        }
        if (extendedError != null && (translatedException = new StorageException(extendedError.getErrorCode(), responseMessage, responseCode, extendedError, cause)) != null) {
            return translatedException;
        }
        translatedException = StorageException.translateFromHttpStatus(responseCode, responseMessage, null, cause);
        if (translatedException != null) {
            return translatedException;
        }
        return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "The server encountered an unknown failure: ".concat(responseMessage), 500, null, cause);
    }

    protected static StorageException translateFromHttpStatus(int statusCode, String statusDescription, StorageExtendedErrorInformation details, Exception inner) {
        switch (statusCode) {
            case 403: {
                return new StorageException(StorageErrorCode.ACCESS_DENIED.toString(), statusDescription, statusCode, details, inner);
            }
            case 404: 
            case 410: {
                return new StorageException(StorageErrorCode.RESOURCE_NOT_FOUND.toString(), statusDescription, statusCode, details, inner);
            }
            case 400: {
                return new StorageException(StorageErrorCode.BAD_REQUEST.toString(), statusDescription, statusCode, details, inner);
            }
            case 304: 
            case 412: {
                return new StorageException(StorageErrorCode.CONDITION_FAILED.toString(), statusDescription, statusCode, details, inner);
            }
            case 409: {
                return new StorageException(StorageErrorCode.RESOURCE_ALREADY_EXISTS.toString(), statusDescription, statusCode, details, inner);
            }
            case 504: {
                return new StorageException(StorageErrorCode.SERVICE_TIMEOUT.toString(), statusDescription, statusCode, details, inner);
            }
            case 416: {
                return new StorageException(StorageErrorCode.BAD_REQUEST.toString(), statusDescription, statusCode, details, inner);
            }
            case 500: {
                return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), statusDescription, statusCode, details, inner);
            }
            case 501: {
                return new StorageException(StorageErrorCode.NOT_IMPLEMENTED.toString(), statusDescription, statusCode, details, inner);
            }
            case 502: {
                return new StorageException(StorageErrorCode.BAD_GATEWAY.toString(), statusDescription, statusCode, details, inner);
            }
            case 505: {
                return new StorageException(StorageErrorCode.HTTP_VERSION_NOT_SUPPORTED.toString(), statusDescription, statusCode, details, inner);
            }
        }
        return null;
    }

    public StorageException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(message, innerException);
        this.errorCode = errorCode;
        this.httpStatusCode = statusCode;
        this.extendedErrorInformation = extendedErrorInfo;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() {
        return this.extendedErrorInformation;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

