/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.HashMap;

public abstract class StorageCredentials {
    protected static StorageCredentials tryParseCredentials(HashMap<String, String> settings) throws InvalidKeyException {
        String sasSignature;
        String accountName = settings.get("AccountName") != null ? settings.get("AccountName") : null;
        String accountKey = settings.get("AccountKey") != null ? settings.get("AccountKey") : null;
        String string = sasSignature = settings.get("SharedAccessSignature") != null ? settings.get("SharedAccessSignature") : null;
        if (accountName != null && accountKey != null && sasSignature == null) {
            if (Base64.validateIsBase64String(accountKey)) {
                return new StorageCredentialsAccountAndKey(accountName, accountKey);
            }
            throw new InvalidKeyException("Storage Key is not a valid base64 encoded string.");
        }
        if (accountName == null && accountKey == null && sasSignature != null) {
            return new StorageCredentialsSharedAccessSignature(sasSignature);
        }
        return null;
    }

    public static StorageCredentials tryParseCredentials(String connectionString) throws InvalidKeyException, StorageException {
        return StorageCredentials.tryParseCredentials(Utility.parseAccountString(connectionString));
    }

    public abstract boolean canCredentialsComputeHmac();

    public abstract boolean canCredentialsSignRequest();

    public abstract boolean canCredentialsSignRequestLite();

    public abstract String computeHmac256(String var1) throws InvalidKeyException;

    public abstract String computeHmac256(String var1, OperationContext var2) throws InvalidKeyException;

    public abstract String computeHmac512(String var1) throws InvalidKeyException;

    public abstract String computeHmac512(String var1, OperationContext var2) throws InvalidKeyException;

    public abstract boolean doCredentialsNeedTransformUri();

    public abstract String getAccountName();

    @Deprecated
    public abstract void signRequest(HttpURLConnection var1, long var2) throws InvalidKeyException, StorageException;

    @Deprecated
    public abstract void signRequest(HttpURLConnection var1, long var2, OperationContext var4) throws InvalidKeyException, StorageException;

    @Deprecated
    public abstract void signRequestLite(HttpURLConnection var1, long var2) throws StorageException, InvalidKeyException;

    @Deprecated
    public abstract void signRequestLite(HttpURLConnection var1, long var2, OperationContext var4) throws StorageException, InvalidKeyException;

    public abstract void signBlobAndQueueRequest(HttpURLConnection var1, long var2) throws InvalidKeyException, StorageException;

    public abstract void signBlobAndQueueRequest(HttpURLConnection var1, long var2, OperationContext var4) throws InvalidKeyException, StorageException;

    public abstract void signBlobAndQueueRequestLite(HttpURLConnection var1, long var2) throws StorageException, InvalidKeyException;

    public abstract void signBlobAndQueueRequestLite(HttpURLConnection var1, long var2, OperationContext var4) throws StorageException, InvalidKeyException;

    public abstract void signTableRequest(HttpURLConnection var1, long var2) throws InvalidKeyException, StorageException;

    public abstract void signTableRequest(HttpURLConnection var1, long var2, OperationContext var4) throws InvalidKeyException, StorageException;

    public abstract void signTableRequestLite(HttpURLConnection var1, long var2) throws StorageException, InvalidKeyException;

    public abstract void signTableRequestLite(HttpURLConnection var1, long var2, OperationContext var4) throws StorageException, InvalidKeyException;

    public abstract String toString(boolean var1);

    public abstract URI transformUri(URI var1) throws URISyntaxException, StorageException;

    public abstract URI transformUri(URI var1, OperationContext var2) throws URISyntaxException, StorageException;
}

