/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.LoggingOperations;
import com.microsoft.windowsazure.services.core.storage.LoggingProperties;
import com.microsoft.windowsazure.services.core.storage.MetricsLevel;
import com.microsoft.windowsazure.services.core.storage.MetricsProperties;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class ServiceProperties {
    private LoggingProperties logging;
    private MetricsProperties metrics;
    private String defaultServiceVersion;

    private static void readLoggingProperties(ServiceProperties retProps, XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "Logging");
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Version")) {
                    retProps.getLogging().setVersion(Utility.readElementFromXMLReader(xmlr, "Version"));
                    continue;
                }
                if (name.equals("Delete")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Delete");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    retProps.getLogging().getLogOperationTypes().add(LoggingOperations.DELETE);
                    continue;
                }
                if (name.equals("Read")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Read");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    retProps.getLogging().getLogOperationTypes().add(LoggingOperations.READ);
                    continue;
                }
                if (name.equals("Write")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Write");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    retProps.getLogging().getLogOperationTypes().add(LoggingOperations.WRITE);
                    continue;
                }
                if (name.equals("RetentionPolicy")) {
                    retProps.getLogging().setRetentionIntervalInDays(ServiceProperties.readRetentionPolicy(xmlr));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "Logging");
            break;
        }
    }

    private static void readMetricsProperties(ServiceProperties retProps, XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "Metrics");
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        retProps.getMetrics().setMetricsLevel(null);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Version")) {
                    retProps.getMetrics().setVersion(Utility.readElementFromXMLReader(xmlr, "Version"));
                    continue;
                }
                if (name.equals("Enabled")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Enabled");
                    if (Boolean.parseBoolean(tempParseString)) {
                        retProps.getMetrics().setMetricsLevel(retProps.getMetrics().getMetricsLevel() != MetricsLevel.SERVICE_AND_API ? MetricsLevel.SERVICE : MetricsLevel.SERVICE_AND_API);
                        continue;
                    }
                    retProps.getMetrics().setMetricsLevel(MetricsLevel.DISABLED);
                    continue;
                }
                if (name.equals("IncludeAPIs")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "IncludeAPIs");
                    if (!Boolean.parseBoolean(tempParseString) || retProps.getMetrics().getMetricsLevel() == MetricsLevel.DISABLED) continue;
                    retProps.getMetrics().setMetricsLevel(MetricsLevel.SERVICE_AND_API);
                    continue;
                }
                if (name.equals("RetentionPolicy")) {
                    retProps.getMetrics().setRetentionIntervalInDays(ServiceProperties.readRetentionPolicy(xmlr));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "Metrics");
            break;
        }
    }

    private static Integer readRetentionPolicy(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "RetentionPolicy");
        Integer retVal = -1;
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Days")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Days");
                    if (retVal == null) continue;
                    retVal = Integer.parseInt(tempParseString);
                    continue;
                }
                if (name.equals("Enabled")) {
                    tempParseString = Utility.readElementFromXMLReader(xmlr, "Enabled");
                    if (Boolean.parseBoolean(tempParseString)) continue;
                    retVal = null;
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "RetentionPolicy");
            break;
        }
        return retVal;
    }

    public static ServiceProperties readServicePropertiesFromStream(InputStream inStream, OperationContext opContext) throws XMLStreamException, StorageException {
        ServiceProperties retProps = new ServiceProperties();
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "StorageServiceProperties");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Logging")) {
                    ServiceProperties.readLoggingProperties(retProps, xmlr);
                    xmlr.require(2, null, "Logging");
                    continue;
                }
                if (name.equals("Metrics")) {
                    ServiceProperties.readMetricsProperties(retProps, xmlr);
                    xmlr.require(2, null, "Metrics");
                    continue;
                }
                if (name.equals("DefaultServiceVersion")) {
                    retProps.setDefaultServiceVersion(Utility.readElementFromXMLReader(xmlr, "DefaultServiceVersion"));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("StorageServiceProperties")) continue;
            break;
        }
        return retProps;
    }

    private static void writeRetentionPolicy(XMLStreamWriter xmlw, Integer val) throws XMLStreamException {
        xmlw.writeStartElement("RetentionPolicy");
        xmlw.writeStartElement("Enabled");
        xmlw.writeCharacters(val != null ? "true" : "false");
        xmlw.writeEndElement();
        if (val != null) {
            xmlw.writeStartElement("Days");
            xmlw.writeCharacters(val.toString());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
    }

    public ServiceProperties() {
        this.setLogging(new LoggingProperties());
        this.setMetrics(new MetricsProperties());
    }

    public String getDefaultServiceVersion() {
        return this.defaultServiceVersion;
    }

    public LoggingProperties getLogging() {
        return this.logging;
    }

    public MetricsProperties getMetrics() {
        return this.metrics;
    }

    public byte[] serializeToByteArray(OperationContext opContext) throws XMLStreamException, StorageException {
        Utility.assertNotNull("Logging", this.getLogging());
        Utility.assertNotNull("Logging.LogOperationTypes", this.getLogging().getLogOperationTypes());
        Utility.assertNotNull("Merics", this.getMetrics());
        Utility.assertNotNull("Merics.Configuration", (Object)this.getMetrics().getMetricsLevel());
        StringWriter outWriter = new StringWriter();
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("StorageServiceProperties");
        xmlw.writeStartElement("Logging");
        xmlw.writeStartElement("Version");
        xmlw.writeCharacters(this.getLogging().getVersion());
        xmlw.writeEndElement();
        xmlw.writeStartElement("Delete");
        xmlw.writeCharacters(this.getLogging().getLogOperationTypes().contains((Object)LoggingOperations.DELETE) ? "true" : "false");
        xmlw.writeEndElement();
        xmlw.writeStartElement("Read");
        xmlw.writeCharacters(this.getLogging().getLogOperationTypes().contains((Object)LoggingOperations.READ) ? "true" : "false");
        xmlw.writeEndElement();
        xmlw.writeStartElement("Write");
        xmlw.writeCharacters(this.getLogging().getLogOperationTypes().contains((Object)LoggingOperations.WRITE) ? "true" : "false");
        xmlw.writeEndElement();
        ServiceProperties.writeRetentionPolicy(xmlw, this.getLogging().getRetentionIntervalInDays());
        xmlw.writeEndElement();
        xmlw.writeStartElement("Metrics");
        xmlw.writeStartElement("Version");
        xmlw.writeCharacters(this.getMetrics().getVersion());
        xmlw.writeEndElement();
        xmlw.writeStartElement("Enabled");
        xmlw.writeCharacters(this.getMetrics().getMetricsLevel() != MetricsLevel.DISABLED ? "true" : "false");
        xmlw.writeEndElement();
        if (this.getMetrics().getMetricsLevel() != MetricsLevel.DISABLED) {
            xmlw.writeStartElement("IncludeAPIs");
            xmlw.writeCharacters(this.getMetrics().getMetricsLevel() == MetricsLevel.SERVICE_AND_API ? "true" : "false");
            xmlw.writeEndElement();
        }
        ServiceProperties.writeRetentionPolicy(xmlw, this.getMetrics().getRetentionIntervalInDays());
        xmlw.writeEndElement();
        if (this.getDefaultServiceVersion() != null) {
            xmlw.writeStartElement("DefaultServiceVersion");
            xmlw.writeCharacters(this.getDefaultServiceVersion());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public void setDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
    }

    public void setLogging(LoggingProperties logging) {
        this.logging = logging;
    }

    public void setMetrics(MetricsProperties metrics) {
        this.metrics = metrics;
    }
}

