/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.queue.client.CloudQueueClient;
import com.microsoft.windowsazure.services.table.client.CloudTableClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CloudStorageAccount {
    protected static final String ACCOUNT_KEY_NAME = "AccountKey";
    protected static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String BLOB_BASE_DNS_NAME = "blob.core.windows.net";
    protected static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
    private static final String DEVELOPMENT_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
    private static final String DEVSTORE_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String DEVSTORE_ACCOUNT_NAME = "devstoreaccount1";
    private static final String DEVSTORE_CREDENTIALS_IN_STRING = "AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static CloudStorageAccount devStoreAccount;
    protected static final String QUEUE_BASE_DNS_NAME = "queue.core.windows.net";
    protected static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
    protected static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
    protected static final String TABLE_BASE_DNS_NAME = "table.core.windows.net";
    protected static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
    private static final String USE_DEVELOPMENT_STORAGE_NAME = "UseDevelopmentStorage";
    private final URI blobEndpoint;
    private StorageCredentials credentials;
    private final URI queueEndpoint;
    private final URI tableEndpoint;

    private static String getDefaultBlobEndpoint(HashMap<String, String> settings) {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME) != null ? settings.get(ACCOUNT_NAME_NAME) : null;
        return CloudStorageAccount.getDefaultBlobEndpoint(scheme, accountName);
    }

    private static String getDefaultBlobEndpoint(String scheme, String accountName) {
        return String.format("%s://%s.%s", scheme, accountName, BLOB_BASE_DNS_NAME);
    }

    private static String getDefaultQueueEndpoint(HashMap<String, String> settings) {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME) != null ? settings.get(ACCOUNT_NAME_NAME) : null;
        return CloudStorageAccount.getDefaultQueueEndpoint(scheme, accountName);
    }

    private static String getDefaultQueueEndpoint(String scheme, String accountName) {
        return String.format("%s://%s.%s", scheme, accountName, QUEUE_BASE_DNS_NAME);
    }

    private static String getDefaultTableEndpoint(HashMap<String, String> settings) {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME) != null ? settings.get(ACCOUNT_NAME_NAME) : null;
        return CloudStorageAccount.getDefaultTableEndpoint(scheme, accountName);
    }

    private static String getDefaultTableEndpoint(String scheme, String accountName) {
        return String.format("%s://%s.%s", scheme, accountName, TABLE_BASE_DNS_NAME);
    }

    public static CloudStorageAccount getDevelopmentStorageAccount() {
        if (devStoreAccount == null) {
            try {
                devStoreAccount = CloudStorageAccount.getDevelopmentStorageAccount(new URI("http://127.0.0.1"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return devStoreAccount;
    }

    public static CloudStorageAccount getDevelopmentStorageAccount(URI proxyUri) throws URISyntaxException {
        if (proxyUri == null) {
            return CloudStorageAccount.getDevelopmentStorageAccount();
        }
        String prefix = proxyUri.getScheme().concat("://");
        prefix = prefix.concat(proxyUri.getHost());
        return new CloudStorageAccount(new StorageCredentialsAccountAndKey(DEVSTORE_ACCOUNT_NAME, DEVSTORE_ACCOUNT_KEY), new URI(prefix.concat(":10000/devstoreaccount1")), new URI(prefix.concat(":10001/devstoreaccount1")), new URI(prefix.concat(":10002/devstoreaccount1")));
    }

    public static CloudStorageAccount parse(String connectionString) throws URISyntaxException, InvalidKeyException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Invalid Connection String");
        }
        HashMap<String, String> settings = Utility.parseAccountString(connectionString);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().equals("")) continue;
            throw new IllegalArgumentException("Invalid Connection String");
        }
        CloudStorageAccount retVal = CloudStorageAccount.tryConfigureDevStore(settings);
        if (retVal != null) {
            return retVal;
        }
        retVal = CloudStorageAccount.tryConfigureServiceAccount(settings);
        if (retVal != null) {
            return retVal;
        }
        throw new IllegalArgumentException("Invalid Connection String");
    }

    private static CloudStorageAccount tryConfigureDevStore(HashMap<String, String> settings) throws URISyntaxException {
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            String useDevStoreSetting = settings.get(USE_DEVELOPMENT_STORAGE_NAME);
            URI devStoreProxyUri = null;
            if (!Boolean.parseBoolean(useDevStoreSetting)) {
                return null;
            }
            if (settings.containsKey(DEVELOPMENT_STORAGE_PROXY_URI_NAME)) {
                devStoreProxyUri = new URI(settings.get(DEVELOPMENT_STORAGE_PROXY_URI_NAME));
            }
            return CloudStorageAccount.getDevelopmentStorageAccount(devStoreProxyUri);
        }
        return null;
    }

    private static CloudStorageAccount tryConfigureServiceAccount(HashMap<String, String> settings) throws URISyntaxException, InvalidKeyException {
        URI tableURI;
        String defaultEndpointSetting;
        String string = defaultEndpointSetting = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME).toLowerCase() : null;
        if (defaultEndpointSetting != null && !defaultEndpointSetting.equals("http") && !defaultEndpointSetting.equals("https")) {
            return null;
        }
        StorageCredentials credentials = StorageCredentials.tryParseCredentials(settings);
        URI blobURI = settings.containsKey(BLOB_ENDPOINT_NAME) ? new URI(settings.get(BLOB_ENDPOINT_NAME)) : null;
        URI queueURI = settings.containsKey(QUEUE_ENDPOINT_NAME) ? new URI(settings.get(QUEUE_ENDPOINT_NAME)) : null;
        URI uRI = tableURI = settings.containsKey(TABLE_ENDPOINT_NAME) ? new URI(settings.get(TABLE_ENDPOINT_NAME)) : null;
        if (credentials != null) {
            if (defaultEndpointSetting != null && settings.containsKey(ACCOUNT_NAME_NAME) && settings.containsKey(ACCOUNT_KEY_NAME)) {
                return new CloudStorageAccount(credentials, blobURI == null ? new URI(CloudStorageAccount.getDefaultBlobEndpoint(settings)) : blobURI, queueURI == null ? new URI(CloudStorageAccount.getDefaultQueueEndpoint(settings)) : queueURI, tableURI == null ? new URI(CloudStorageAccount.getDefaultTableEndpoint(settings)) : tableURI);
            }
            if (settings.containsKey(BLOB_ENDPOINT_NAME) || settings.containsKey(QUEUE_ENDPOINT_NAME) || settings.containsKey(TABLE_ENDPOINT_NAME)) {
                return new CloudStorageAccount(credentials, blobURI, queueURI, tableURI);
            }
        }
        return null;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials) throws URISyntaxException {
        this.credentials = storageCredentials;
        this.blobEndpoint = new URI(CloudStorageAccount.getDefaultBlobEndpoint("http", this.credentials.getAccountName()));
        this.queueEndpoint = new URI(CloudStorageAccount.getDefaultQueueEndpoint("http", this.credentials.getAccountName()));
        this.tableEndpoint = new URI(CloudStorageAccount.getDefaultTableEndpoint("http", this.credentials.getAccountName()));
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint) {
        this.credentials = storageCredentials;
        this.blobEndpoint = blobEndpoint;
        this.queueEndpoint = queueEndpoint;
        this.tableEndpoint = tableEndpoint;
    }

    public CloudStorageAccount(StorageCredentialsAccountAndKey storageCredentials, boolean useHttps) throws URISyntaxException {
        this(storageCredentials, new URI(CloudStorageAccount.getDefaultBlobEndpoint(useHttps ? "https" : "http", storageCredentials.getAccountName())), new URI(CloudStorageAccount.getDefaultQueueEndpoint(useHttps ? "https" : "http", storageCredentials.getAccountName())), new URI(CloudStorageAccount.getDefaultTableEndpoint(useHttps ? "https" : "http", storageCredentials.getAccountName())));
    }

    public CloudBlobClient createCloudBlobClient() {
        if (this.getBlobEndpoint() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudBlobClient requires a credential that can sign request");
        }
        return new CloudBlobClient(this.getBlobEndpoint(), this.getCredentials());
    }

    public CloudQueueClient createCloudQueueClient() {
        if (this.getQueueEndpoint() == null) {
            throw new IllegalArgumentException("No queue endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudQueueClient requires a credential that can sign request");
        }
        return new CloudQueueClient(this.getQueueEndpoint(), this.getCredentials());
    }

    public CloudTableClient createCloudTableClient() {
        if (this.getTableEndpoint() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudTableClient requires a credential that can sign request");
        }
        return new CloudTableClient(this.getTableEndpoint(), this.getCredentials());
    }

    public URI getBlobEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.blobEndpoint;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public URI getQueueEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.queueEndpoint;
    }

    public URI getTableEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.tableEndpoint;
    }

    protected void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean exportSecrets) {
        if (this.credentials != null && Utility.isNullOrEmpty(this.credentials.getAccountName())) {
            return this.credentials.toString(exportSecrets);
        }
        ArrayList<String> retVals = new ArrayList<String>();
        if (this == devStoreAccount) {
            retVals.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
        } else if (this.credentials != null && DEVSTORE_ACCOUNT_NAME.equals(this.credentials.getAccountName()) && this.credentials.toString(true).equals(DEVSTORE_CREDENTIALS_IN_STRING) && this.blobEndpoint != null && this.getBlobEndpoint().getHost().equals(this.getQueueEndpoint().getHost()) && this.getQueueEndpoint().getHost().equals(this.getTableEndpoint().getHost()) && this.getBlobEndpoint().getScheme().equals(this.getQueueEndpoint().getScheme()) && this.getQueueEndpoint().getScheme().equals(this.getTableEndpoint().getScheme())) {
            retVals.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
            retVals.add(String.format("%s=%s://%s", DEVELOPMENT_STORAGE_PROXY_URI_NAME, this.getBlobEndpoint().getScheme(), this.getBlobEndpoint().getHost()));
        } else if (this.getBlobEndpoint().getHost().endsWith(BLOB_BASE_DNS_NAME) && this.getQueueEndpoint().getHost().endsWith(QUEUE_BASE_DNS_NAME) && this.getTableEndpoint().getHost().endsWith(TABLE_BASE_DNS_NAME) && this.getBlobEndpoint().getScheme().equals(this.getQueueEndpoint().getScheme()) && this.getQueueEndpoint().getScheme().equals(this.getTableEndpoint().getScheme())) {
            retVals.add(String.format("%s=%s", DEFAULT_ENDPOINTS_PROTOCOL_NAME, this.getBlobEndpoint().getScheme()));
            if (this.getCredentials() != null) {
                retVals.add(this.getCredentials().toString(exportSecrets));
            }
        } else {
            if (this.getBlobEndpoint() != null) {
                retVals.add(String.format("%s=%s", BLOB_ENDPOINT_NAME, this.getBlobEndpoint()));
            }
            if (this.getQueueEndpoint() != null) {
                retVals.add(String.format("%s=%s", QUEUE_ENDPOINT_NAME, this.getQueueEndpoint()));
            }
            if (this.getTableEndpoint() != null) {
                retVals.add(String.format("%s=%s", TABLE_ENDPOINT_NAME, this.getTableEndpoint()));
            }
            if (this.getCredentials() != null) {
                retVals.add(this.getCredentials().toString(exportSecrets));
            }
        }
        StringBuilder returnString = new StringBuilder();
        for (String val : retVals) {
            returnString.append(val);
            returnString.append(';');
        }
        if (retVals.size() > 0) {
            returnString.deleteCharAt(returnString.length() - 1);
        }
        return returnString.toString();
    }
}

