/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core;

import java.util.HashMap;
import java.util.Map;

public class ServiceException
extends Exception {
    private static final long serialVersionUID = -4942076377009150131L;
    int httpStatusCode;
    String httpReasonPhrase;
    String serviceName;
    String errorCode;
    String errorMessage;
    Map<String, String> errorValues;
    String rawResponseBody;

    public ServiceException() {
        this.init();
    }

    public ServiceException(String message) {
        super(message);
        this.init();
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.init();
    }

    public ServiceException(Throwable cause) {
        super(cause);
        this.init();
    }

    private void init() {
        this.errorValues = new HashMap<String, String>();
    }

    @Override
    public String getMessage() {
        if (this.rawResponseBody == null) {
            return super.getMessage();
        }
        return super.getMessage() + "\nResponse Body: " + this.rawResponseBody;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getHttpReasonPhrase() {
        return this.httpReasonPhrase;
    }

    public void setHttpReasonPhrase(String httpReasonPhrase) {
        this.httpReasonPhrase = httpReasonPhrase;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map<String, String> getErrorValues() {
        return this.errorValues;
    }

    public void setErrorValues(Map<String, String> errorValues) {
        this.errorValues = errorValues;
    }

    public String getErrorValue(String name) {
        return this.errorValues.get(name);
    }

    public void setErrorValue(String name, String value) {
        this.errorValues.put(name, value);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRawResponseBody(String body) {
        this.rawResponseBody = body;
    }

    public String getRawResponseBody() {
        return this.rawResponseBody;
    }
}

