/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core;

import com.microsoft.windowsazure.services.core.RetryPolicy;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryPolicyFilter
implements ServiceFilter {
    private static final Log log = LogFactory.getLog(RetryPolicyFilter.class);
    private final RetryPolicy retryPolicy;

    public RetryPolicyFilter(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public ServiceFilter.Response handle(ServiceFilter.Request request, ServiceFilter.Next next) throws Exception {
        if (request.getProperties().containsKey("RetryPolicy")) {
            return next.handle(request);
        }
        request.getProperties().put("RetryPolicy", this);
        int retryCount = 0;
        while (true) {
            if (this.getEntityStream(request) != null) {
                this.getEntityStream(request).mark(Integer.MAX_VALUE);
            }
            ServiceFilter.Response response = null;
            Exception error = null;
            try {
                response = next.handle(request);
            }
            catch (Exception e) {
                error = e;
            }
            boolean shouldRetry = this.retryPolicy.shouldRetry(retryCount, response, error);
            if (!shouldRetry) {
                if (error != null) {
                    throw error;
                }
                return response;
            }
            if (this.getEntityStream(request) != null) {
                this.getEntityStream(request).reset();
            }
            int backoffTime = this.retryPolicy.calculateBackoff(retryCount, response, error);
            log.info((Object)String.format("Request failed. Backing off for %1s milliseconds before retrying (retryCount=%2d)", backoffTime, retryCount));
            this.backoff(backoffTime);
            ++retryCount;
        }
    }

    private InputStream getEntityStream(ServiceFilter.Request request) {
        if (request.getEntity() == null) {
            return null;
        }
        if (!(request.getEntity() instanceof InputStream)) {
            return null;
        }
        InputStream entityStream = (InputStream)request.getEntity();
        if (!entityStream.markSupported()) {
            throw new IllegalArgumentException("The input stream for the request entity must support 'mark' and 'reset' to be compatible with a retry policy filter.");
        }
        return entityStream;
    }

    private void backoff(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

