/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.services.blob.implementation.HmacSHA256Sign;
import com.microsoft.windowsazure.services.blob.implementation.SharedKeyUtils;
import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.utils.pipeline.EntityStreamingListener;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedKeyFilter
extends ClientFilter
implements EntityStreamingListener {
    private static Log log = LogFactory.getLog(SharedKeyFilter.class);
    private final String accountName;
    private final HmacSHA256Sign signer;

    public SharedKeyFilter(@Named(value="blob.accountName") String accountName, @Named(value="blob.accountKey") String accountKey) {
        this.accountName = accountName;
        this.signer = new HmacSHA256Sign(accountKey);
    }

    protected String getHeader(ClientRequest cr, String headerKey) {
        return SharedKeyUtils.getHeader(cr, headerKey);
    }

    protected HmacSHA256Sign getSigner() {
        return this.signer;
    }

    protected String getAccountName() {
        return this.accountName;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (cr.getProperties().get(SharedKeyUtils.AUTHORIZATION_FILTER_MARKER) == null) {
            cr.getProperties().put(SharedKeyUtils.AUTHORIZATION_FILTER_MARKER, null);
            if (cr.getProperties().get(EntityStreamingListener.class.getName()) == null) {
                cr.getProperties().put(EntityStreamingListener.class.getName(), this);
            }
        }
        return this.getNext().handle(cr);
    }

    @Override
    public void onBeforeStreamingEntity(ClientRequest clientRequest) {
        this.sign(clientRequest);
    }

    public void sign(ClientRequest cr) {
        this.addOptionalDateHeader(cr);
        String stringToSign = cr.getMethod() + "\n" + this.getHeader(cr, "Content-Encoding") + "\n" + this.getHeader(cr, "Content-Language") + "\n" + this.getHeader(cr, "Content-Length") + "\n" + this.getHeader(cr, "Content-MD5") + "\n" + this.getHeader(cr, "Content-Type") + "\n" + this.getHeader(cr, "Date") + "\n" + this.getHeader(cr, "If-Modified-Since") + "\n" + this.getHeader(cr, "If-Match") + "\n" + this.getHeader(cr, "If-None-Match") + "\n" + this.getHeader(cr, "If-Unmodified-Since") + "\n" + this.getHeader(cr, "Range") + "\n";
        stringToSign = stringToSign + this.getCanonicalizedHeaders(cr);
        stringToSign = stringToSign + this.getCanonicalizedResource(cr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("String to sign: \"%s\"", stringToSign));
        }
        String signature = this.signer.sign(stringToSign);
        cr.getHeaders().putSingle((Object)"Authorization", (Object)("SharedKey " + this.accountName + ":" + signature));
    }

    protected void addOptionalDateHeader(ClientRequest cr) {
        String date = this.getHeader(cr, "Date");
        if (date == "") {
            date = new RFC1123DateConverter().format(new Date());
            cr.getHeaders().putSingle((Object)"Date", (Object)date);
        }
    }

    private String getCanonicalizedHeaders(ClientRequest cr) {
        return SharedKeyUtils.getCanonicalizedHeaders(cr);
    }

    private String getCanonicalizedResource(ClientRequest cr) {
        String result = "/" + this.accountName;
        result = result + cr.getURI().getPath();
        List<SharedKeyUtils.QueryParam> queryParams = SharedKeyUtils.getQueryParams(cr.getURI().getQuery());
        for (SharedKeyUtils.QueryParam param : queryParams) {
            param.setName(param.getName().toLowerCase(Locale.US));
        }
        Collections.sort(queryParams);
        for (int i = 0; i < queryParams.size(); ++i) {
            SharedKeyUtils.QueryParam param;
            param = queryParams.get(i);
            List<String> values = param.getValues();
            result = result + "\n";
            result = result + param.getName();
            result = result + ":";
            for (int j = 0; j < values.size(); ++j) {
                if (j > 0) {
                    result = result + ",";
                }
                result = result + values.get(j);
            }
        }
        return result;
    }
}

