/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.implementation.BlobOperationRestProxy;
import com.microsoft.windowsazure.services.blob.implementation.SharedKeyFilter;
import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.pipeline.HttpURLConnectionClient;
import com.sun.jersey.api.client.Client;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;

public class BlobRestProxy
extends BlobOperationRestProxy
implements BlobContract {
    private final SharedKeyFilter sharedKeyFilter;

    @Inject
    public BlobRestProxy(HttpURLConnectionClient channel, @Named(value="blob.accountName") String accountName, @Named(value="blob.uri") String url, SharedKeyFilter sharedKeyFilter, UserAgentFilter userAgentFilter) {
        super(channel, accountName, url);
        this.sharedKeyFilter = sharedKeyFilter;
        channel.addFilter(sharedKeyFilter);
        channel.addFilter(userAgentFilter);
    }

    public BlobRestProxy(Client client, ServiceFilter[] filters, String accountName, String url, SharedKeyFilter sharedKeyFilter, RFC1123DateConverter dateMapper) {
        super(client, filters, accountName, url, dateMapper);
        this.sharedKeyFilter = sharedKeyFilter;
    }

    @Override
    public BlobContract withFilter(ServiceFilter filter) {
        ServiceFilter[] currentFilters = this.getFilters();
        ServiceFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = filter;
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }
}

