/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.core.storage;

import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.queue.client.SharedAccessQueuePolicy;
import com.microsoft.windowsazure.services.table.client.SharedAccessTablePolicy;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SharedAccessSignatureHelper {
    public static UriQueryBuilder generateSharedAccessSignature(SharedAccessBlobPolicy policy, String groupPolicyIdentifier, String resourceType, String signature) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        Utility.assertNotNull("signature", signature);
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2012-02-12");
        if (policy != null) {
            String stopString;
            String startString;
            String permissions = SharedAccessBlobPolicy.permissionsToString(policy.getPermissions());
            if (Utility.isNullOrEmpty(permissions)) {
                permissions = null;
            }
            if (!Utility.isNullOrEmpty(startString = Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()))) {
                builder.add("st", startString);
            }
            if (!Utility.isNullOrEmpty(stopString = Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()))) {
                builder.add("se", stopString);
            }
            if (!Utility.isNullOrEmpty(permissions)) {
                builder.add("sp", permissions);
            }
        }
        builder.add("sr", resourceType);
        if (!Utility.isNullOrEmpty(groupPolicyIdentifier)) {
            builder.add("si", groupPolicyIdentifier);
        }
        if (!Utility.isNullOrEmpty(signature)) {
            builder.add("sig", signature);
        }
        return builder;
    }

    public static UriQueryBuilder generateSharedAccessSignature(SharedAccessQueuePolicy policy, String groupPolicyIdentifier, String signature) throws StorageException {
        Utility.assertNotNull("signature", signature);
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2012-02-12");
        if (policy != null) {
            String stopString;
            String startString;
            String permissions = SharedAccessQueuePolicy.permissionsToString(policy.getPermissions());
            if (Utility.isNullOrEmpty(permissions)) {
                permissions = null;
            }
            if (!Utility.isNullOrEmpty(startString = Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()))) {
                builder.add("st", startString);
            }
            if (!Utility.isNullOrEmpty(stopString = Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()))) {
                builder.add("se", stopString);
            }
            if (!Utility.isNullOrEmpty(permissions)) {
                builder.add("sp", permissions);
            }
        }
        if (!Utility.isNullOrEmpty(groupPolicyIdentifier)) {
            builder.add("si", groupPolicyIdentifier);
        }
        if (!Utility.isNullOrEmpty(signature)) {
            builder.add("sig", signature);
        }
        return builder;
    }

    public static UriQueryBuilder generateSharedAccessSignature(String permissions, Date startTime, Date expiryTime, String startPatitionKey, String startRowKey, String endPatitionKey, String endRowKey, String accessPolicyIdentifier, String resourceType, String tableName, String signature, String accountKeyName) throws StorageException {
        String stopString;
        String startString;
        Utility.assertNotNull("signature", signature);
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2012-02-12");
        if (!Utility.isNullOrEmpty(permissions)) {
            builder.add("sp", permissions);
        }
        if (!Utility.isNullOrEmpty(startString = Utility.getUTCTimeOrEmpty(startTime))) {
            builder.add("st", startString);
        }
        if (!Utility.isNullOrEmpty(stopString = Utility.getUTCTimeOrEmpty(expiryTime))) {
            builder.add("se", stopString);
        }
        if (!Utility.isNullOrEmpty(startPatitionKey)) {
            builder.add("spk", startPatitionKey);
        }
        if (!Utility.isNullOrEmpty(startRowKey)) {
            builder.add("srk", startRowKey);
        }
        if (!Utility.isNullOrEmpty(endPatitionKey)) {
            builder.add("epk", endPatitionKey);
        }
        if (!Utility.isNullOrEmpty(endRowKey)) {
            builder.add("erk", endRowKey);
        }
        if (!Utility.isNullOrEmpty(accessPolicyIdentifier)) {
            builder.add("si", accessPolicyIdentifier);
        }
        if (!Utility.isNullOrEmpty(resourceType)) {
            builder.add("sr", resourceType);
        }
        if (!Utility.isNullOrEmpty(tableName)) {
            builder.add("tn", tableName);
        }
        if (!Utility.isNullOrEmpty(signature)) {
            builder.add("sig", signature);
        }
        if (!Utility.isNullOrEmpty(accountKeyName)) {
            builder.add("sk", accountKeyName);
        }
        return builder;
    }

    public static UriQueryBuilder generateSharedAccessSignature(SharedAccessTablePolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String tableName, String signature, String accountKeyName) throws StorageException {
        String permissionString = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissionString = SharedAccessTablePolicy.permissionsToString(policy.getPermissions());
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        return SharedAccessSignatureHelper.generateSharedAccessSignature(permissionString, startTime, expiryTime, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, null, tableName, signature, accountKeyName);
    }

    public static String generateSharedAccessSignatureHash(SharedAccessBlobPolicy policy, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        String permissionString = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissionString = SharedAccessBlobPolicy.permissionsToString(policy.getPermissions());
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHash(permissionString, startTime, expiryTime, resourceName, accessPolicyIdentifier, false, null, null, null, null, client, opContext);
    }

    public static String generateSharedAccessSignatureHash(SharedAccessQueuePolicy policy, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        String permissionString = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissionString = SharedAccessQueuePolicy.permissionsToString(policy.getPermissions());
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHash(permissionString, startTime, expiryTime, resourceName, accessPolicyIdentifier, false, null, null, null, null, client, opContext);
    }

    public static String generateSharedAccessSignatureHash(String permissions, Date startTime, Date expiryTime, String resourceName, String accessPolicyIdentifier, boolean useTableSas, String startPatitionKey, String startRowKey, String endPatitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2012-02-12");
        if (useTableSas) {
            stringToSign = String.format("%s\n%s\n%s\n%s\n%s", stringToSign, startPatitionKey == null ? "" : startPatitionKey, startRowKey == null ? "" : startRowKey, endPatitionKey == null ? "" : endPatitionKey, endRowKey == null ? "" : endRowKey);
        }
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = client.getCredentials().computeHmac256(stringToSign, opContext);
        return signature;
    }

    public static String generateSharedAccessSignatureHash(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String resourceName, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        String permissionString = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissionString = SharedAccessTablePolicy.permissionsToString(policy.getPermissions());
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHash(permissionString, startTime, expiryTime, resourceName, accessPolicyIdentifier, true, startPartitionKey, startRowKey, endPartitionKey, endRowKey, client, opContext);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(HashMap<String, String[]> queryParams) throws StorageException {
        String signature = null;
        String signedStart = null;
        String signedExpiry = null;
        String signedResource = null;
        String sigendPermissions = null;
        String signedIdentifier = null;
        String signedVersion = null;
        boolean sasParameterFound = false;
        StorageCredentialsSharedAccessSignature credentials = null;
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase(Utility.LOCALE_US);
            if (lowerKey.equals("st")) {
                signedStart = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("se")) {
                signedExpiry = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sp")) {
                sigendPermissions = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sr")) {
                signedResource = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("si")) {
                signedIdentifier = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sig")) {
                signature = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (!lowerKey.equals("sv")) continue;
            signedVersion = entry.getValue()[0];
            sasParameterFound = true;
        }
        if (sasParameterFound) {
            if (signature == null) {
                String errorMessage = "Missing mandatory parameters for valid Shared Access Signature";
                throw new IllegalArgumentException("Missing mandatory parameters for valid Shared Access Signature");
            }
            UriQueryBuilder builder = new UriQueryBuilder();
            if (!Utility.isNullOrEmpty(signedStart)) {
                builder.add("st", signedStart);
            }
            if (!Utility.isNullOrEmpty(signedExpiry)) {
                builder.add("se", signedExpiry);
            }
            if (!Utility.isNullOrEmpty(sigendPermissions)) {
                builder.add("sp", sigendPermissions);
            }
            if (!Utility.isNullOrEmpty(signedResource)) {
                builder.add("sr", signedResource);
            }
            if (!Utility.isNullOrEmpty(signedIdentifier)) {
                builder.add("si", signedIdentifier);
            }
            if (!Utility.isNullOrEmpty(signedVersion)) {
                builder.add("sv", signedVersion);
            }
            if (!Utility.isNullOrEmpty(signature)) {
                builder.add("sig", signature);
            }
            String token = builder.toString();
            credentials = new StorageCredentialsSharedAccessSignature(token);
        }
        return credentials;
    }

    private SharedAccessSignatureHelper() {
    }
}

