/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobContainerAttributes;
import com.microsoft.windowsazure.services.blob.client.BlobContainerProperties;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;

final class ContainerResponse
extends BaseResponse {
    ContainerResponse() {
    }

    public static String getAcl(HttpURLConnection request) {
        return request.getHeaderField("x-ms-blob-public-access");
    }

    public static BlobContainerAttributes getAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        URI tempURI;
        BlobContainerAttributes containerAttributes = new BlobContainerAttributes();
        try {
            tempURI = PathUtility.stripURIQueryAndFragment(request.getURL().toURI());
        }
        catch (URISyntaxException e) {
            StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
            throw wrappedUnexpectedException;
        }
        containerAttributes.setUri(tempURI);
        containerAttributes.setName(PathUtility.getContainerNameFromUri(tempURI, usePathStyleUris));
        BlobContainerProperties containerProperties = containerAttributes.getProperties();
        containerProperties.setEtag(BaseResponse.getEtag(request));
        containerProperties.setLastModified(new Date(request.getLastModified()));
        containerAttributes.setMetadata(ContainerResponse.getMetadata(request));
        containerProperties.setLeaseStatus(BaseResponse.getLeaseStatus(request));
        containerProperties.setLeaseState(BaseResponse.getLeaseState(request));
        containerProperties.setLeaseDuration(BaseResponse.getLeaseDuration(request));
        return containerAttributes;
    }
}

