/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobListingDetails;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.ListBlobItem;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;

public final class CloudBlobDirectory
implements ListBlobItem {
    private CloudBlobContainer container;
    protected CloudBlobDirectory parent;
    protected CloudBlobClient blobServiceClient;
    private final URI uri;
    private String prefix;

    protected CloudBlobDirectory(String relativeAddress, CloudBlobClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("relativeAddress", relativeAddress);
        Utility.assertNotNull("client", client);
        this.blobServiceClient = client;
        if (this.blobServiceClient.getDirectoryDelimiter() != null && !relativeAddress.endsWith(this.blobServiceClient.getDirectoryDelimiter())) {
            relativeAddress = relativeAddress.concat(this.blobServiceClient.getDirectoryDelimiter());
        }
        this.uri = PathUtility.appendPathToUri(this.blobServiceClient.getEndpoint(), relativeAddress);
    }

    protected CloudBlobDirectory(URI uri, CloudBlobDirectory parent, CloudBlobClient client) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("client", client);
        this.blobServiceClient = client;
        this.uri = uri;
        this.parent = parent;
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        return this.getBlockBlobReference(blobAddressUri, null);
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri, this.blobServiceClient.getDirectoryDelimiter());
        CloudBlockBlob retBlob = new CloudBlockBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this.container);
        return retBlob;
    }

    @Override
    public CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        if (this.container == null) {
            URI containerURI = PathUtility.getContainerURI(this.uri, this.blobServiceClient.isUsePathStyleUris());
            this.container = new CloudBlobContainer(containerURI, this.blobServiceClient);
        }
        return this.container;
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        return this.getPageBlobReference(blobAddressUri, null);
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri, this.blobServiceClient.getDirectoryDelimiter());
        CloudPageBlob retBlob = new CloudPageBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this.container);
        return retBlob;
    }

    @Override
    public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        if (this.parent == null) {
            URI parentURI = PathUtility.getParentAddress(this.uri, this.blobServiceClient.getDirectoryDelimiter(), this.blobServiceClient.isUsePathStyleUris());
            this.parent = new CloudBlobDirectory(parentURI, null, this.blobServiceClient);
        }
        return this.parent;
    }

    protected String getPrefix() throws StorageException {
        if (this.prefix == null) {
            try {
                String containerUri = this.getContainer().getUri().toString().concat("/");
                this.prefix = Utility.safeRelativize(new URI(containerUri), this.uri);
            }
            catch (URISyntaxException e) {
                StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
                throw wrappedUnexpectedException;
            }
        }
        return this.prefix;
    }

    public CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public CloudBlobDirectory getSubDirectoryReference(String relativeAddress) throws StorageException, URISyntaxException {
        Utility.assertNotNullOrEmpty("relativeAddress", relativeAddress);
        URI address = PathUtility.appendPathToUri(this.uri, relativeAddress, this.blobServiceClient.getDirectoryDelimiter());
        return new CloudBlobDirectory(address, this, this.blobServiceClient);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobs(this.getPrefix());
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobsSegmented(this.getPrefix());
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, maxResults, continuationToken, options, opContext);
    }
}

