/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobAccessPolicyResponse;
import com.microsoft.windowsazure.services.blob.client.BlobContainerAttributes;
import com.microsoft.windowsazure.services.blob.client.BlobContainerPermissions;
import com.microsoft.windowsazure.services.blob.client.BlobContainerProperties;
import com.microsoft.windowsazure.services.blob.client.BlobContainerPublicAccessType;
import com.microsoft.windowsazure.services.blob.client.BlobListingContext;
import com.microsoft.windowsazure.services.blob.client.BlobListingDetails;
import com.microsoft.windowsazure.services.blob.client.BlobRequest;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobResponse;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobDirectory;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.ContainerListingDetails;
import com.microsoft.windowsazure.services.blob.client.ContainerRequest;
import com.microsoft.windowsazure.services.blob.client.ContainerResponse;
import com.microsoft.windowsazure.services.blob.client.ListBlobItem;
import com.microsoft.windowsazure.services.blob.client.ListBlobsResponse;
import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.services.blob.core.storage.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultContinuationType;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LazySegmentedIterable;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LeaseAction;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.SegmentedStorageOperation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;

public final class CloudBlobContainer {
    protected HashMap<String, String> metadata = new HashMap();
    BlobContainerProperties properties = new BlobContainerProperties();
    String name;
    URI uri;
    private CloudBlobClient blobServiceClient;

    static BlobContainerPermissions getContainerAcl(String aclString) {
        BlobContainerPublicAccessType accessType = BlobContainerPublicAccessType.OFF;
        if (!Utility.isNullOrEmpty(aclString)) {
            String lowerAclString = aclString.toLowerCase();
            if ("container".equals(lowerAclString)) {
                accessType = BlobContainerPublicAccessType.CONTAINER;
            } else if ("blob".equals(lowerAclString)) {
                accessType = BlobContainerPublicAccessType.BLOB;
            } else {
                throw new IllegalArgumentException(String.format("Invalid acl public access type returned '%s'. Expected blob or container.", aclString));
            }
        }
        BlobContainerPermissions retVal = new BlobContainerPermissions();
        retVal.setPublicAccess(accessType);
        return retVal;
    }

    private CloudBlobContainer(CloudBlobClient client) {
        this.blobServiceClient = client;
    }

    public CloudBlobContainer(String containerAddress, CloudBlobClient client) throws URISyntaxException, StorageException {
        this(client);
        URI resURI;
        this.uri = resURI = PathUtility.appendPathToUri(client.getEndpoint(), containerAddress);
        this.name = PathUtility.getContainerNameFromUri(resURI, client.isUsePathStyleUris());
        this.parseQueryAndVerify(this.uri, client, client.isUsePathStyleUris());
    }

    public CloudBlobContainer(URI uri, CloudBlobClient client) throws URISyntaxException, StorageException {
        this(client);
        this.uri = uri;
        this.name = PathUtility.getContainerNameFromUri(uri, client.isUsePathStyleUris());
        this.parseQueryAndVerify(this.uri, client, client.isUsePathStyleUris());
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.create(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                ContainerRequest.addMetadata(request, container.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                BlobContainerAttributes attributes = ContainerResponse.getAttributes(request, client.isUsePathStyleUris());
                container.properties = attributes.getProperties();
                container.name = attributes.getName();
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean createIfNotExist() throws StorageException {
        return this.createIfNotExist(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExist(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.create(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                ContainerRequest.addMetadata(request, container.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 201) {
                    BlobContainerAttributes attributes = ContainerResponse.getAttributes(request, client.isUsePathStyleUris());
                    container.properties = attributes.getProperties();
                    container.name = attributes.getName();
                    return true;
                }
                if (this.getResult().getStatusCode() == 409) {
                    StorageException potentialConflictException = StorageException.translateException(request, null, opContext);
                    StorageExtendedErrorInformation extendedInfo = potentialConflictException.getExtendedErrorInformation();
                    if (extendedInfo == null) {
                        throw potentialConflictException;
                    }
                    if (!extendedInfo.getErrorCode().equals("ContainerAlreadyExists")) {
                        this.setException(potentialConflictException);
                        this.setNonExceptionedRetryableFailure(true);
                        return false;
                    }
                    return false;
                }
                throw StorageException.translateException(request, null, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.delete(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.delete(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 202) {
                    container.updatePropertiesFromResponse(request);
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.getProperties(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                BlobContainerAttributes attributes = ContainerResponse.getAttributes(request, client.isUsePathStyleUris());
                container.metadata = attributes.getMetadata();
                container.properties = attributes.getProperties();
                container.name = attributes.getName();
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public BlobContainerPermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public BlobContainerPermissions downloadPermissions(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, BlobContainerPermissions> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, BlobContainerPermissions>((RequestOptions)options){

            @Override
            public BlobContainerPermissions execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.getAcl(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                container.updatePropertiesFromResponse(request);
                String aclString = ContainerResponse.getAcl(request);
                BlobContainerPermissions containerAcl = CloudBlobContainer.getContainerAcl(aclString);
                BlobAccessPolicyResponse response = new BlobAccessPolicyResponse(request.getInputStream());
                for (String key : response.getAccessIdentifiers().keySet()) {
                    containerAcl.getSharedAccessPolicies().put(key, (SharedAccessBlobPolicy)response.getAccessIdentifiers().get(key));
                }
                return containerAcl;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.getProperties(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 200) {
                    container.updatePropertiesFromResponse(request);
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public String generateSharedAccessSignature(SharedAccessBlobPolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        if (!this.blobServiceClient.getCredentials().canCredentialsSignRequest()) {
            String errorMessage = "Cannot create Shared Access Signature unless the Account Key credentials are used by the BlobServiceClient.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the BlobServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHash(policy, groupPolicyIdentifier, resourceName, (ServiceClient)this.blobServiceClient, null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignature(policy, groupPolicyIdentifier, "c", signature);
        return builder.toString();
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri);
        return new CloudBlockBlob(address, this.blobServiceClient, this);
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri);
        CloudBlockBlob retBlob = new CloudBlockBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this);
        return retBlob;
    }

    public CloudBlobDirectory getDirectoryReference(String relativeAddress) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("relativeAddress", relativeAddress);
        URI address = PathUtility.appendPathToUri(this.uri, relativeAddress);
        return new CloudBlobDirectory(address, null, this.blobServiceClient);
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri);
        return new CloudPageBlob(address, this.blobServiceClient, this);
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI address = PathUtility.appendPathToUri(this.uri, blobAddressUri);
        CloudPageBlob retBlob = new CloudPageBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this);
        return retBlob;
    }

    public BlobContainerProperties getProperties() {
        return this.properties;
    }

    public CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    private String getSharedAccessCanonicalName() {
        if (this.blobServiceClient.isUsePathStyleUris()) {
            return this.getUri().getPath();
        }
        return PathUtility.getCanonicalPathFromCredentials(this.blobServiceClient.getCredentials(), this.getUri().getPath());
    }

    protected URI getTransformedAddress() throws URISyntaxException, StorageException {
        if (this.blobServiceClient.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.uri.isAbsolute()) {
                return this.blobServiceClient.getCredentials().transformUri(this.uri);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Blob Object relative URIs not supported.");
            throw ex;
        }
        return this.uri;
    }

    public URI getUri() {
        return this.uri;
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs() {
        return this.listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), null, null);
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix) {
        return this.listBlobs(prefix, false, EnumSet.noneOf(BlobListingDetails.class), null, null);
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(final String prefix, final boolean useFlatBlobListing, final EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        if (!useFlatBlobListing && listingDetails != null && listingDetails.contains((Object)BlobListingDetails.SNAPSHOTS)) {
            throw new IllegalArgumentException("Listing snapshots is only supported in flat mode (no delimiter). Consider setting useFlatBlobListing to true.");
        }
        SegmentedStorageOperation<CloudBlobClient, CloudBlobContainer, ResultSegment<ListBlobItem>> impl = new SegmentedStorageOperation<CloudBlobClient, CloudBlobContainer, ResultSegment<ListBlobItem>>((RequestOptions)options, null){

            @Override
            public ResultSegment<ListBlobItem> execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                ResultSegment<ListBlobItem> result = CloudBlobContainer.this.listBlobsCore(prefix, useFlatBlobListing, listingDetails, -1, this.getToken(), (BlobRequestOptions)this.getRequestOptions(), this, opContext);
                if (result != null) {
                    this.setToken(result.getContinuationToken());
                }
                return result;
            }
        };
        return new LazySegmentedIterable<CloudBlobClient, CloudBlobContainer, ListBlobItem>(impl, this.blobServiceClient, this, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    ResultSegment<ListBlobItem> listBlobsCore(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, StorageOperation<CloudBlobClient, CloudBlobContainer, ResultSegment<ListBlobItem>> taskReference, OperationContext opContext) throws URISyntaxException, IOException, StorageException, InvalidKeyException, XMLStreamException {
        Utility.assertContinuationType(continuationToken, ResultContinuationType.BLOB);
        Utility.assertNotNull("options", options);
        if (listingDetails == null) {
            listingDetails = EnumSet.noneOf(BlobListingDetails.class);
        }
        if (!useFlatBlobListing && listingDetails.contains((Object)BlobListingDetails.SNAPSHOTS)) {
            throw new IllegalArgumentException("Listing snapshots is only supported in flat mode (no delimiter). Consider setting useFlatBlobListing to true.");
        }
        String delimiter = useFlatBlobListing ? null : this.blobServiceClient.getDirectoryDelimiter();
        BlobListingContext listingContext = new BlobListingContext(prefix, maxResults, delimiter, listingDetails);
        listingContext.setMarker(continuationToken != null ? continuationToken.getNextMarker() : null);
        HttpURLConnection listBlobsRequest = BlobRequest.list(this.getTransformedAddress(), options.getTimeoutIntervalInMs(), listingContext, options, opContext);
        taskReference.setConnection(listBlobsRequest);
        taskReference.signRequest(this.blobServiceClient, listBlobsRequest, -1L, null);
        ExecutionEngine.processRequest(listBlobsRequest, opContext, taskReference.getResult());
        if (taskReference.getResult().getStatusCode() != 200) {
            taskReference.setNonExceptionedRetryableFailure(true);
            return null;
        }
        ListBlobsResponse response = new ListBlobsResponse(listBlobsRequest.getInputStream());
        response.parseResponse(this.blobServiceClient, this);
        ResultContinuation newToken = null;
        if (response.getNextMarker() != null) {
            newToken = new ResultContinuation();
            newToken.setNextMarker(response.getNextMarker());
            newToken.setContinuationType(ResultContinuationType.BLOB);
        }
        ResultSegment<ListBlobItem> resSegment = new ResultSegment<ListBlobItem>(response.getBlobs(this.blobServiceClient, this), maxResults, newToken);
        return resSegment;
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented() throws StorageException {
        return this.listBlobsSegmented(null, false, EnumSet.noneOf(BlobListingDetails.class), -1, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix) throws StorageException {
        return this.listBlobsSegmented(prefix, false, EnumSet.noneOf(BlobListingDetails.class), -1, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(final String prefix, final boolean useFlatBlobListing, final EnumSet<BlobListingDetails> listingDetails, final int maxResults, final ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.BLOB);
        if (!useFlatBlobListing && listingDetails != null && listingDetails.contains((Object)BlobListingDetails.SNAPSHOTS)) {
            throw new IllegalArgumentException("Listing snapshots is only supported in flat mode (no delimiter). Consider setting useFlatBlobListing to true.");
        }
        StorageOperation<CloudBlobClient, CloudBlobContainer, ResultSegment<ListBlobItem>> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, ResultSegment<ListBlobItem>>((RequestOptions)options){

            @Override
            public ResultSegment<ListBlobItem> execute(CloudBlobClient client, CloudBlobContainer parent, OperationContext opContext) throws Exception {
                return CloudBlobContainer.this.listBlobsCore(prefix, useFlatBlobListing, listingDetails, maxResults, continuationToken, (BlobRequestOptions)this.getRequestOptions(), this, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers() {
        return this.blobServiceClient.listContainers();
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix) {
        return this.blobServiceClient.listContainers(prefix);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) {
        return this.blobServiceClient.listContainers(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented() throws StorageException {
        return this.blobServiceClient.listContainersSegmented();
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix) throws StorageException {
        return this.blobServiceClient.listContainersSegmented(prefix);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix, ContainerListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.blobServiceClient.listContainersSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    private void parseQueryAndVerify(URI completeUri, CloudBlobClient existingClient, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address '%s' is not an absolute address. Relative addresses are not permitted in here.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.uri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        if (sasCreds == null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            this.blobServiceClient = new CloudBlobClient(new URI(PathUtility.getServiceClientBaseAddress(this.getUri(), usePathStyleUris)), sasCreds);
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.blobServiceClient.setPageBlobStreamWriteSizeInBytes(existingClient.getPageBlobStreamWriteSizeInBytes());
            this.blobServiceClient.setSingleBlobPutThresholdInBytes(existingClient.getSingleBlobPutThresholdInBytes());
            this.blobServiceClient.setStreamMinimumReadSizeInBytes(existingClient.getStreamMinimumReadSizeInBytes());
            this.blobServiceClient.setWriteBlockSizeInBytes(existingClient.getWriteBlockSizeInBytes());
            this.blobServiceClient.setConcurrentRequestCount(existingClient.getConcurrentRequestCount());
            this.blobServiceClient.setDirectoryDelimiter(existingClient.getDirectoryDelimiter());
            this.blobServiceClient.setRetryPolicyFactory(existingClient.getRetryPolicyFactory());
            this.blobServiceClient.setTimeoutInMs(existingClient.getTimeoutInMs());
        }
    }

    void updatePropertiesFromResponse(HttpURLConnection request) {
        String tempStr = request.getHeaderField("ETag");
        if (!Utility.isNullOrEmpty(tempStr)) {
            this.getProperties().setEtag(tempStr);
        }
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setProperties(BlobContainerProperties properties) {
        this.properties = properties;
    }

    protected void setUri(URI uri) {
        this.uri = uri;
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.setMetadata(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), opContext);
                this.setConnection(request);
                ContainerRequest.addMetadata(request, container.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                container.updatePropertiesFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadPermissions(BlobContainerPermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(final BlobContainerPermissions permissions, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                HttpURLConnection request = ContainerRequest.setAcl(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), permissions.getPublicAccess(), opContext);
                this.setConnection(request);
                StringWriter outBuffer = new StringWriter();
                ContainerRequest.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
                byte[] aclBytes = outBuffer.toString().getBytes("UTF8");
                this.signRequest(client, request, aclBytes.length, null);
                OutputStream outStreamRef = request.getOutputStream();
                outStreamRef.write(aclBytes);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                container.updatePropertiesFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId) throws StorageException {
        return this.acquireLease(leaseTimeInSeconds, proposedLeaseId, null, null, null);
    }

    @DoesServiceRequest
    public final String acquireLease(final Integer leaseTimeInSeconds, final String proposedLeaseId, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, String> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, String>((RequestOptions)options){

            @Override
            public String execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = ContainerRequest.lease(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.ACQUIRE, leaseTimeInSeconds, proposedLeaseId, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                container.updatePropertiesFromResponse(request);
                return BlobResponse.getLeaseID(request, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition) throws StorageException {
        this.renewLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void renewLease(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = ContainerRequest.lease(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.RENEW, null, null, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                container.updatePropertiesFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition) throws StorageException {
        this.releaseLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void releaseLease(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = ContainerRequest.lease(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.RELEASE, null, null, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                container.updatePropertiesFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds) throws StorageException {
        return this.breakLease(breakPeriodInSeconds, null, null, null);
    }

    @DoesServiceRequest
    public final long breakLease(final Integer breakPeriodInSeconds, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Long> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Long>((RequestOptions)options){

            @Override
            public Long execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = ContainerRequest.lease(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.BREAK, null, null, breakPeriodInSeconds, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return -1L;
                }
                container.updatePropertiesFromResponse(request);
                String leaseTime = BlobResponse.getLeaseTime(request, opContext);
                return Utility.isNullOrEmpty(leaseTime) ? -1L : Long.parseLong(leaseTime);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void changeLease(String proposedLeaseId, AccessCondition accessCondition) throws StorageException {
        this.changeLease(proposedLeaseId, accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void changeLease(final String proposedLeaseId, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlobContainer, Void> impl = new StorageOperation<CloudBlobClient, CloudBlobContainer, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlobContainer container, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = ContainerRequest.lease(container.uri, this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.CHANGE, null, proposedLeaseId, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                container.updatePropertiesFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }
}

