/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.CloudBlobDirectory;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.ContainerListingDetails;
import com.microsoft.windowsazure.services.blob.client.ContainerRequest;
import com.microsoft.windowsazure.services.blob.client.ListContainersResponse;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.ResultContinuationType;
import com.microsoft.windowsazure.services.core.storage.ResultSegment;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAnonymous;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LazySegmentedIterable;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ListingContext;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.SegmentedStorageOperation;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import javax.xml.stream.XMLStreamException;

public final class CloudBlobClient
extends ServiceClient {
    private int singleBlobPutThresholdInBytes = 0x2000000;
    private int writeBlockSizeInBytes = 0x400000;
    private int pageBlobStreamWriteSizeInBytes = 0x400000;
    private int streamMinimumReadSizeInBytes = 0x400000;
    private int concurrentRequestCount = 1;
    private String directoryDelimiter = "/";

    public CloudBlobClient(URI baseUri) {
        this(baseUri, StorageCredentialsAnonymous.ANONYMOUS);
    }

    public CloudBlobClient(URI baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        return this.getBlockBlobReference(blobAddressUri, null);
    }

    public CloudBlockBlob getBlockBlobReference(String blobAddressUri, String snapshotID) throws StorageException, URISyntaxException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI completeUri = PathUtility.appendPathToUri(this.endpoint, blobAddressUri);
        return new CloudBlockBlob(completeUri, snapshotID, this);
    }

    public int getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    public CloudBlobContainer getContainerReference(String containerAddress) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("containerAddress", containerAddress);
        return new CloudBlobContainer(containerAddress, this);
    }

    public String getDirectoryDelimiter() {
        return this.directoryDelimiter;
    }

    public CloudBlobDirectory getDirectoryReference(String relativeAddress) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("relativeAddress", relativeAddress);
        return new CloudBlobDirectory(relativeAddress, this);
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
        return this.getPageBlobReference(blobAddressUri, null);
    }

    public CloudPageBlob getPageBlobReference(String blobAddressUri, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobAddressUri", blobAddressUri);
        URI completeUri = PathUtility.appendPathToUri(this.endpoint, blobAddressUri);
        return new CloudPageBlob(completeUri, snapshotID, this);
    }

    public int getPageBlobStreamWriteSizeInBytes() {
        return this.pageBlobStreamWriteSizeInBytes;
    }

    public int getSingleBlobPutThresholdInBytes() {
        return this.singleBlobPutThresholdInBytes;
    }

    public int getStreamMinimumReadSizeInBytes() {
        return this.streamMinimumReadSizeInBytes;
    }

    public int getWriteBlockSizeInBytes() {
        return this.writeBlockSizeInBytes;
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers() {
        return this.listContainersWithPrefix(null, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix) {
        return this.listContainersWithPrefix(prefix, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) {
        return this.listContainersWithPrefix(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    ResultSegment<CloudBlobContainer> listContainersCore(String prefix, ContainerListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, RequestOptions options, StorageOperation<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> taskReference, OperationContext opContext) throws IOException, URISyntaxException, XMLStreamException, InvalidKeyException, StorageException {
        Utility.assertContinuationType(continuationToken, ResultContinuationType.CONTAINER);
        ListingContext listingContext = new ListingContext(prefix, maxResults);
        listingContext.setMarker(continuationToken != null ? continuationToken.getNextMarker() : null);
        HttpURLConnection listContainerRequest = ContainerRequest.list(this.getEndpoint(), options.getTimeoutIntervalInMs(), listingContext, detailsIncluded, opContext);
        taskReference.setConnection(listContainerRequest);
        taskReference.signRequest(this, listContainerRequest, -1L, null);
        ExecutionEngine.processRequest(listContainerRequest, opContext, taskReference.getResult());
        if (taskReference.getResult().getStatusCode() != 200) {
            taskReference.setNonExceptionedRetryableFailure(true);
            return null;
        }
        ListContainersResponse response = new ListContainersResponse(listContainerRequest.getInputStream());
        response.parseResponse(this);
        ResultContinuation newToken = null;
        if (response.getNextMarker() != null) {
            newToken = new ResultContinuation();
            newToken.setNextMarker(response.getNextMarker());
            newToken.setContinuationType(ResultContinuationType.CONTAINER);
        }
        ResultSegment<CloudBlobContainer> resSegment = new ResultSegment<CloudBlobContainer>(response.getContainers(this), maxResults, newToken);
        return resSegment;
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented() throws StorageException {
        return this.listContainersSegmented(null, ContainerListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, null, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix, ContainerListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    protected Iterable<CloudBlobContainer> listContainersWithPrefix(final String prefix, final ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        SegmentedStorageOperation<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> impl = new SegmentedStorageOperation<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>>((RequestOptions)options, null){

            @Override
            public ResultSegment<CloudBlobContainer> execute(CloudBlobClient client, Void dontCare, OperationContext opContext) throws Exception {
                ResultSegment<CloudBlobContainer> result = CloudBlobClient.this.listContainersCore(prefix, detailsIncluded, -1, this.getToken(), this.getRequestOptions(), this, opContext);
                this.setToken(result.getContinuationToken());
                return result;
            }
        };
        return new LazySegmentedIterable<CloudBlobClient, Object, CloudBlobContainer>(impl, this, null, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    protected ResultSegment<CloudBlobContainer> listContainersWithPrefixSegmented(final String prefix, final ContainerListingDetails detailsIncluded, final int maxResults, final ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.CONTAINER);
        StorageOperation<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> impl = new StorageOperation<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>>((RequestOptions)options){

            @Override
            public ResultSegment<CloudBlobContainer> execute(CloudBlobClient client, Void dontCare, OperationContext opContext) throws Exception {
                return CloudBlobClient.this.listContainersCore(prefix, detailsIncluded, maxResults, continuationToken, this.getRequestOptions(), this, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this, null, impl, options.getRetryPolicyFactory(), opContext);
    }

    public void setConcurrentRequestCount(int concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setDirectoryDelimiter(String directoryDelimiter) {
        this.directoryDelimiter = directoryDelimiter;
    }

    public void setPageBlobStreamWriteSizeInBytes(int pageBlobStreamWriteSizeInBytes) {
        if (pageBlobStreamWriteSizeInBytes > 0x400000 || pageBlobStreamWriteSizeInBytes < 512 || pageBlobStreamWriteSizeInBytes % 512 != 0) {
            throw new IllegalArgumentException("PageBlobStreamWriteSizeInBytes");
        }
        this.pageBlobStreamWriteSizeInBytes = pageBlobStreamWriteSizeInBytes;
    }

    public void setSingleBlobPutThresholdInBytes(int singleBlobPutThresholdInBytes) {
        if (singleBlobPutThresholdInBytes > 0x4000000 || singleBlobPutThresholdInBytes < 0x100000) {
            throw new IllegalArgumentException("SingleBlobUploadThresholdInBytes");
        }
        this.singleBlobPutThresholdInBytes = singleBlobPutThresholdInBytes;
    }

    public void setStreamMinimumReadSizeInBytes(int minimumReadSize) {
        if (minimumReadSize > 0x4000000 || minimumReadSize < 512) {
            throw new IllegalArgumentException("MinimumReadSize");
        }
        this.streamMinimumReadSizeInBytes = minimumReadSize;
    }

    public void setWriteBlockSizeInBytes(int writeBlockSizeInBytes) {
        if (writeBlockSizeInBytes > 0x400000 || writeBlockSizeInBytes < 0x100000) {
            throw new IllegalArgumentException("WriteBlockSizeInBytes");
        }
        this.writeBlockSizeInBytes = writeBlockSizeInBytes;
    }
}

