/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobAttributes;
import com.microsoft.windowsazure.services.blob.client.BlobInputStream;
import com.microsoft.windowsazure.services.blob.client.BlobProperties;
import com.microsoft.windowsazure.services.blob.client.BlobRequest;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobResponse;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.CloudBlobDirectory;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.CopyState;
import com.microsoft.windowsazure.services.blob.client.DeleteSnapshotsOption;
import com.microsoft.windowsazure.services.blob.client.ListBlobItem;
import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.services.blob.core.storage.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.LeaseStatus;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.RetryNoRetry;
import com.microsoft.windowsazure.services.core.storage.RetryPolicy;
import com.microsoft.windowsazure.services.core.storage.ServiceClient;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.StreamMd5AndLength;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LeaseAction;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public abstract class CloudBlob
implements ListBlobItem {
    HashMap<String, String> metadata = new HashMap();
    BlobProperties properties;
    URI uri;
    String snapshotID;
    CopyState copyState;
    private CloudBlobContainer container;
    protected CloudBlobDirectory parent;
    private String name;
    protected CloudBlobClient blobServiceClient;

    protected CloudBlob(BlobType type) {
        this.properties = new BlobProperties(type);
    }

    protected CloudBlob(BlobType type, URI uri, CloudBlobClient client) throws StorageException {
        this(type);
        Utility.assertNotNull("blobAbsoluteUri", uri);
        this.blobServiceClient = client;
        this.uri = uri;
        this.parseURIQueryStringAndVerify(uri, client, client.isUsePathStyleUris());
    }

    protected CloudBlob(BlobType type, URI uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        this(type, uri, client);
        this.container = container;
    }

    protected CloudBlob(BlobType type, URI uri, String snapshotID, CloudBlobClient client) throws StorageException {
        this(type, uri, client);
        if (snapshotID != null) {
            if (this.snapshotID != null) {
                throw new IllegalArgumentException("Snapshot query parameter is already defined in the blobUri. Either pass in a snapshotTime parameter or use a full URL with a snapshot query parameter.");
            }
            this.snapshotID = snapshotID;
        }
    }

    protected CloudBlob(CloudBlob otherBlob) {
        this.properties = new BlobProperties(otherBlob.properties);
        if (otherBlob.metadata != null) {
            this.metadata = new HashMap();
            for (String key : otherBlob.metadata.keySet()) {
                this.metadata.put(key, otherBlob.metadata.get(key));
            }
        }
        this.snapshotID = otherBlob.snapshotID;
        this.uri = otherBlob.uri;
        this.container = otherBlob.container;
        this.parent = otherBlob.parent;
        this.blobServiceClient = otherBlob.blobServiceClient;
        this.name = otherBlob.name;
        this.copyState = otherBlob.copyState;
    }

    @DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId) throws StorageException {
        return this.acquireLease(leaseTimeInSeconds, proposedLeaseId, null, null, null);
    }

    @DoesServiceRequest
    public final String acquireLease(final Integer leaseTimeInSeconds, final String proposedLeaseId, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, String> impl = new StorageOperation<CloudBlobClient, CloudBlob, String>((RequestOptions)options){

            @Override
            public String execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.ACQUIRE, leaseTimeInSeconds, proposedLeaseId, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.properties.setLeaseStatus(LeaseStatus.LOCKED);
                return BlobResponse.getLeaseID(request, opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected final void assertCorrectBlobType() throws StorageException {
        if (this instanceof CloudBlockBlob && this.properties.getBlobType() != BlobType.BLOCK_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s", new Object[]{BlobType.BLOCK_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
        if (this instanceof CloudPageBlob && this.properties.getBlobType() != BlobType.PAGE_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s", new Object[]{BlobType.PAGE_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
    }

    @DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds) throws StorageException {
        return this.breakLease(breakPeriodInSeconds, null, null, null);
    }

    @DoesServiceRequest
    public final long breakLease(final Integer breakPeriodInSeconds, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Long> impl = new StorageOperation<CloudBlobClient, CloudBlob, Long>((RequestOptions)options){

            @Override
            public Long execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.BREAK, null, null, breakPeriodInSeconds, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return -1L;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                String leaseTime = BlobResponse.getLeaseTime(request, opContext);
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return Utility.isNullOrEmpty(leaseTime) ? -1L : Long.parseLong(leaseTime);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void copyFromBlob(CloudBlob sourceBlob) throws StorageException, URISyntaxException {
        this.copyFromBlob(sourceBlob, null, null, null, null);
    }

    @DoesServiceRequest
    public final void copyFromBlob(CloudBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        this.copyFromBlob(sourceBlob.uri, sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final void copyFromBlob(URI source) throws StorageException {
        this.copyFromBlob(source, null, null, null, null);
    }

    @DoesServiceRequest
    public final void copyFromBlob(final URI source, final AccessCondition sourceAccessCondition, final AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.copyFrom(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), source.toString(), blob.snapshotID, sourceAccessCondition, destinationAccessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                blob.copyState = BaseResponse.getCopyState(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void abortCopy(String copyId) throws StorageException {
        this.abortCopy(copyId, null, null, null);
    }

    @DoesServiceRequest
    public final void abortCopy(final String copyId, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.abortCopy(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), copyId, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final CloudBlob createSnapshot() throws StorageException {
        return this.createSnapshot(null, null, null);
    }

    @DoesServiceRequest
    public final CloudBlob createSnapshot(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, CloudBlob> impl = new StorageOperation<CloudBlobClient, CloudBlob, CloudBlob>((RequestOptions)options){

            @Override
            public CloudBlob execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.snapshot(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob snapshot = null;
                String snapshotTime = BlobResponse.getSnapshotTime(request, opContext);
                if (blob instanceof CloudBlockBlob) {
                    snapshot = new CloudBlockBlob(blob.getUri(), snapshotTime, client);
                } else if (blob instanceof CloudPageBlob) {
                    snapshot = new CloudPageBlob(blob.getUri(), snapshotTime, client);
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return snapshot;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void delete() throws StorageException {
        this.delete(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @DoesServiceRequest
    public final void delete(final DeleteSnapshotsOption deleteSnapshotsOption, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("deleteSnapshotsOption", (Object)deleteSnapshotsOption);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.delete(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.snapshotID, deleteSnapshotsOption, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists(final DeleteSnapshotsOption deleteSnapshotsOption, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("deleteSnapshotsOption", (Object)deleteSnapshotsOption);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Boolean> impl = new StorageOperation<CloudBlobClient, CloudBlob, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.delete(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.snapshotID, deleteSnapshotsOption, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 202) {
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void download(OutputStream outStream) throws StorageException, IOException {
        this.download(outStream, null, null, null);
    }

    @DoesServiceRequest
    public final void download(final OutputStream outStream, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.get(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blob.snapshotID, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                InputStream streamRef = ExecutionEngine.getInputStream(request, opContext, this.getResult());
                String contentMD5 = request.getHeaderField("Content-MD5");
                Boolean validateMD5 = !blobOptions.getDisableContentMD5Validation() && !Utility.isNullOrEmpty(contentMD5);
                String contentLength = request.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                BlobAttributes retrievedAttributes = BlobResponse.getAttributes(request, blob.getUri(), blob.snapshotID, opContext);
                blob.properties = retrievedAttributes.getProperties();
                blob.metadata = retrievedAttributes.getMetadata();
                blob.copyState = retrievedAttributes.getCopyState();
                ExecutionEngine.getResponseCode(this.getResult(), request, opContext);
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                StreamMd5AndLength descriptor = Utility.writeToOutputStream(streamRef, outStream, -1L, false, validateMD5, this.getResult(), opContext);
                if (descriptor.getLength() != expectedLength) {
                    throw new StorageException("OutOfRangeInput", "An incorrect number of bytes was read from the connection. The connection may have been closed", 306, null, null);
                }
                if (validateMD5.booleanValue() && !contentMD5.equals(descriptor.getMd5())) {
                    throw new StorageException("InvalidMd5", String.format("Blob data corrupted (integrity check failed), Expected value is %s, retrieved %s", contentMD5, descriptor.getMd5()), 306, null, null);
                }
                return null;
            }
        };
        try {
            ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, RetryNoRetry.getInstance(), opContext);
            opContext.setIntermediateMD5(null);
        }
        catch (StorageException ex) {
            RetryPolicy dummyPolicy = options.getRetryPolicyFactory().createInstance(opContext);
            if (ex.getHttpStatusCode() == 306 && !ex.getErrorCode().equals("OutOfRangeInput") || ex.getHttpStatusCode() == 412 || !dummyPolicy.shouldRetry(0, impl.getResult().getStatusCode(), (Exception)ex.getCause(), opContext).isShouldRetry()) {
                opContext.setIntermediateMD5(null);
                throw ex;
            }
            AccessCondition etagLockCondition = new AccessCondition();
            etagLockCondition.setIfMatch(this.getProperties().getEtag());
            if (accessCondition != null) {
                etagLockCondition.setLeaseID(accessCondition.getLeaseID());
            }
            BlobInputStream streamRef = this.openInputStream(etagLockCondition, options, opContext);
            boolean validateMd5 = streamRef.getValidateBlobMd5();
            streamRef.setValidateBlobMd5(false);
            streamRef.mark(Integer.MAX_VALUE);
            try {
                if (opContext.getCurrentOperationByteCount() > 0L) {
                    streamRef.skip(opContext.getCurrentOperationByteCount());
                }
                StreamMd5AndLength descriptor = Utility.writeToOutputStream(streamRef, outStream, -1L, false, validateMd5, null, opContext);
                if (validateMd5 && !this.properties.getContentMD5().equals(descriptor.getMd5())) {
                    throw new StorageException("InvalidMd5", String.format("Blob data corrupted (integrity check failed), Expected value is %s, retrieved %s", this.properties.getContentMD5(), descriptor.getMd5()), 306, null, null);
                }
            }
            catch (IOException secondEx) {
                opContext.setIntermediateMD5(null);
                if (secondEx.getCause() != null && secondEx.getCause() instanceof StorageException) {
                    throw (StorageException)secondEx.getCause();
                }
                throw secondEx;
            }
        }
    }

    @DoesServiceRequest
    public final void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public final void downloadAttributes(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.getProperties(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.snapshotID, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                BlobAttributes retrievedAttributes = BlobResponse.getAttributes(request, blob.getUri(), blob.snapshotID, opContext);
                if (retrievedAttributes.getProperties().getBlobType() != blob.properties.getBlobType()) {
                    throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s", new Object[]{blob.properties.getBlobType(), retrievedAttributes.getProperties().getBlobType()}), 306, null, null);
                }
                blob.properties = retrievedAttributes.getProperties();
                blob.metadata = retrievedAttributes.getMetadata();
                blob.copyState = retrievedAttributes.getCopyState();
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, int length, byte[] buffer, int bufferOffet) throws StorageException {
        this.downloadRangeInternal(offset, length, buffer, bufferOffet, null, null, null);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, int length, byte[] buffer, int bufferOffet, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset < 0L || length <= 0) {
            throw new IndexOutOfBoundsException();
        }
        Utility.assertNotNull("buffer", buffer);
        if (length + bufferOffet > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        opContext.initialize();
        this.downloadRangeInternal(offset, length, buffer, bufferOffet, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    protected final void downloadRangeInternal(final long blobOffset, final int length, final byte[] buffer, final int bufferOffset, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (blobOffset < 0L || length <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        if (options.getUseTransactionalContentMD5() && length > 0x400000) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 checking via the BlobRequestOptions.");
        }
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.get(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blob.snapshotID, blobOffset, length, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                if (blobOptions.getUseTransactionalContentMD5()) {
                    request.setRequestProperty("x-ms-range-get-content-md5", "true");
                }
                this.signRequest(client, request, -1L, null);
                InputStream sourceStream = ExecutionEngine.getInputStream(request, opContext, this.getResult());
                int totalRead = 0;
                int nextRead = buffer.length - bufferOffset;
                int count = sourceStream.read(buffer, bufferOffset, nextRead);
                while (count > 0) {
                    nextRead = buffer.length - (bufferOffset + (totalRead += count));
                    if (nextRead == 0 && sourceStream.read(new byte[1], 0, 1) != -1) {
                        throw new StorageException("OutOfRangeInput", "An incorrect number of bytes was read from the connection. The connection may have been closed", 306, null, null);
                    }
                    count = sourceStream.read(buffer, bufferOffset + totalRead, nextRead);
                }
                ExecutionEngine.getResponseCode(this.getResult(), request, opContext);
                if (this.getResult().getStatusCode() != 206) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                long originalBlobLength = blob.properties.getLength();
                String originalContentMD5 = blob.properties.getContentMD5();
                BlobAttributes retrievedAttributes = BlobResponse.getAttributes(request, blob.getUri(), blob.snapshotID, opContext);
                blob.properties = retrievedAttributes.getProperties();
                blob.metadata = retrievedAttributes.getMetadata();
                blob.copyState = retrievedAttributes.getCopyState();
                blob.properties.setContentMD5(originalContentMD5);
                blob.properties.setLength(originalBlobLength);
                String contentLength = request.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                if ((long)totalRead != expectedLength) {
                    throw new StorageException("OutOfRangeInput", "An incorrect number of bytes was read from the connection. The connection may have been closed", 306, null, null);
                }
                if (blobOptions.getUseTransactionalContentMD5()) {
                    String contentMD5 = request.getHeaderField("Content-MD5");
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        digest.update(buffer, bufferOffset, length);
                        String calculatedMD5 = Base64.encode(digest.digest());
                        if (!contentMD5.equals(calculatedMD5)) {
                            throw new StorageException("InvalidMd5", String.format("Blob data corrupted (integrity check failed), Expected value is %s, retrieved %s", contentMD5, calculatedMD5), 306, null, null);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw Utility.generateNewUnexpectedStorageException(e);
                    }
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public final boolean exists(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Boolean> impl = new StorageOperation<CloudBlobClient, CloudBlob, Boolean>((RequestOptions)options){

            @Override
            public Boolean execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.getProperties(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.snapshotID, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 200) {
                    BlobAttributes retrievedAttributes = BlobResponse.getAttributes(request, blob.getUri(), blob.snapshotID, opContext);
                    blob.properties = retrievedAttributes.getProperties();
                    blob.metadata = retrievedAttributes.getMetadata();
                    blob.copyState = retrievedAttributes.getCopyState();
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public String generateSharedAccessSignature(SharedAccessBlobPolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        if (!this.blobServiceClient.getCredentials().canCredentialsSignRequest()) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the BlobServiceClient.");
        }
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature for snapshots. Perform the operation on the root blob instead.");
        }
        String resourceName = this.getCanonicalName(true);
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHash(policy, groupPolicyIdentifier, resourceName, (ServiceClient)this.blobServiceClient, null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignature(policy, groupPolicyIdentifier, "b", signature);
        return builder.toString();
    }

    String getCanonicalName(boolean ignoreSnapshotTime) {
        String canonicalName = this.blobServiceClient.isUsePathStyleUris() ? this.getUri().getRawPath() : PathUtility.getCanonicalPathFromCredentials(this.blobServiceClient.getCredentials(), this.getUri().getRawPath());
        if (!ignoreSnapshotTime && this.snapshotID != null) {
            canonicalName = canonicalName.concat("?snapshot=");
            canonicalName = canonicalName.concat(this.snapshotID);
        }
        return canonicalName;
    }

    @Override
    public final CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        if (this.container == null) {
            URI containerURI = PathUtility.getContainerURI(this.getUri(), this.blobServiceClient.isUsePathStyleUris());
            this.container = new CloudBlobContainer(containerURI, this.blobServiceClient);
        }
        return this.container;
    }

    public final HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public final String getName() throws URISyntaxException {
        if (Utility.isNullOrEmpty(this.name)) {
            this.name = PathUtility.getBlobNameFromURI(this.getUri(), this.blobServiceClient.isUsePathStyleUris());
        }
        return this.name;
    }

    @Override
    public final CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        if (this.parent == null) {
            URI parentURI = PathUtility.getParentAddress(this.getUri(), this.blobServiceClient.getDirectoryDelimiter(), this.blobServiceClient.isUsePathStyleUris());
            this.parent = new CloudBlobDirectory(parentURI, null, this.blobServiceClient);
        }
        return this.parent;
    }

    public final BlobProperties getProperties() {
        return this.properties;
    }

    public CopyState getCopyState() {
        return this.copyState;
    }

    public final URI getQualifiedUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            return PathUtility.addToQuery(this.getUri(), String.format("snapshot=%s", this.snapshotID));
        }
        if (this.blobServiceClient.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            return this.blobServiceClient.getCredentials().transformUri(this.getUri());
        }
        return this.getUri();
    }

    public final CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public final String getSnapshotID() {
        return this.snapshotID;
    }

    protected final URI getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.blobServiceClient.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.getUri().isAbsolute()) {
                return this.blobServiceClient.getCredentials().transformUri(this.getUri(), opContext);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Blob Object relative URIs not supported.");
            throw ex;
        }
        return this.getUri();
    }

    @Override
    public final URI getUri() {
        return this.uri;
    }

    public final boolean isSnapshot() {
        return this.snapshotID != null;
    }

    @DoesServiceRequest
    public final BlobInputStream openInputStream() throws StorageException {
        return this.openInputStream(null, null, null);
    }

    @DoesServiceRequest
    public final BlobInputStream openInputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        this.assertNoWriteOperationForSnapshot();
        options.applyDefaults(this.blobServiceClient);
        return new BlobInputStream(this, accessCondition, options, opContext);
    }

    protected void parseURIQueryStringAndVerify(URI completeUri, CloudBlobClient existingClient, boolean usePathStyleUris) throws StorageException {
        Utility.assertNotNull("resourceUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address '%s' is not an absolute address. Relative addresses are not permitted in here.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.uri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        String[] snapshotIDs = queryParameters.get("snapshot");
        if (snapshotIDs != null && snapshotIDs.length > 0) {
            this.snapshotID = snapshotIDs[0];
        }
        if (sasCreds == null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            try {
                this.blobServiceClient = new CloudBlobClient(new URI(PathUtility.getServiceClientBaseAddress(this.getUri(), usePathStyleUris)), sasCreds);
            }
            catch (URISyntaxException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.blobServiceClient.setPageBlobStreamWriteSizeInBytes(existingClient.getPageBlobStreamWriteSizeInBytes());
            this.blobServiceClient.setSingleBlobPutThresholdInBytes(existingClient.getSingleBlobPutThresholdInBytes());
            this.blobServiceClient.setStreamMinimumReadSizeInBytes(existingClient.getStreamMinimumReadSizeInBytes());
            this.blobServiceClient.setWriteBlockSizeInBytes(existingClient.getWriteBlockSizeInBytes());
            this.blobServiceClient.setConcurrentRequestCount(existingClient.getConcurrentRequestCount());
            this.blobServiceClient.setDirectoryDelimiter(existingClient.getDirectoryDelimiter());
            this.blobServiceClient.setRetryPolicyFactory(existingClient.getRetryPolicyFactory());
            this.blobServiceClient.setTimeoutInMs(existingClient.getTimeoutInMs());
        }
    }

    void updateEtagAndLastModifiedFromResponse(HttpURLConnection request) {
        String tempStr = request.getHeaderField("ETag");
        if (!Utility.isNullOrEmpty(tempStr)) {
            this.getProperties().setEtag(tempStr);
        }
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    void updateLengthFromResponse(HttpURLConnection request) {
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            this.getProperties().setLength(Long.parseLong(xContentLengthHeader));
        }
    }

    @DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition) throws StorageException {
        this.releaseLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void releaseLease(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.RELEASE, null, null, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition) throws StorageException {
        this.renewLease(accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void renewLease(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.RENEW, null, null, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void changeLease(String proposedLeaseId, AccessCondition accessCondition) throws StorageException {
        this.changeLease(proposedLeaseId, accessCondition, null, null);
    }

    @DoesServiceRequest
    public final void changeLease(final String proposedLeaseId, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.CHANGE, null, proposedLeaseId, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected final void setContainer(CloudBlobContainer container) {
        this.container = container;
    }

    public final void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected final void setProperties(BlobProperties properties) {
        this.properties = properties;
    }

    public void setCopyState(CopyState copyState) {
        this.copyState = copyState;
    }

    public final void setSnapshotID(String snapshotID) {
        this.snapshotID = snapshotID;
    }

    @DoesServiceRequest
    public final long tryBreakLease() throws StorageException {
        return this.tryBreakLease(null, null, null);
    }

    @DoesServiceRequest
    public final long tryBreakLease(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Long> impl = new StorageOperation<CloudBlobClient, CloudBlob, Long>((RequestOptions)options){

            @Override
            public Long execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.lease(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), LeaseAction.BREAK, null, null, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 409) {
                    StorageException potentialConflictException = StorageException.translateException(request, null, opContext);
                    StorageExtendedErrorInformation extendedInfo = potentialConflictException.getExtendedErrorInformation();
                    if (extendedInfo == null) {
                        throw potentialConflictException;
                    }
                    if (!extendedInfo.getErrorCode().equals("LeaseAlreadyBroken")) {
                        this.setException(potentialConflictException);
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return -1L;
                }
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return -1L;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                String leaseTime = BlobResponse.getLeaseTime(request, opContext);
                return Utility.isNullOrEmpty(leaseTime) ? -1L : Long.parseLong(leaseTime);
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public abstract void upload(InputStream var1, long var2) throws StorageException, IOException;

    @DoesServiceRequest
    public abstract void upload(InputStream var1, long var2, AccessCondition var4, BlobRequestOptions var5, OperationContext var6) throws StorageException, IOException;

    @DoesServiceRequest
    protected final void uploadFullBlob(final InputStream sourceStream, final long length, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        this.assertNoWriteOperationForSnapshot();
        sourceStream.mark(0x4000000);
        if (length < 0L || length > 0x4000000L) {
            throw new IllegalArgumentException(String.format("Invalid stream length; stream must be between 0 and %s MB in length.", 64));
        }
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.put(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.properties, blob.properties.getBlobType(), 0L, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                this.signRequest(client, request, length, null);
                StreamMd5AndLength descriptor = Utility.writeToOutputStream(sourceStream, request.getOutputStream(), length, true, false, null, opContext);
                if (length != descriptor.getLength()) {
                    throw new StorageException("InvalidInput", "An incorrect stream length was specified, resulting in an authentication failure. Please specify correct length, or -1.", 403, null, null);
                }
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadMetadata(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.setMetadata(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), accessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void uploadProperties() throws StorageException {
        this.uploadProperties(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadProperties(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.setProperties(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.properties, null, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected void assertNoWriteOperationForSnapshot() {
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot perform this operation on a blob representing a snapshot.");
        }
    }
}

