/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobListingContext;
import com.microsoft.windowsazure.services.blob.client.BlobListingDetails;
import com.microsoft.windowsazure.services.blob.client.BlobProperties;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.BlockEntry;
import com.microsoft.windowsazure.services.blob.client.BlockListingFilter;
import com.microsoft.windowsazure.services.blob.client.BlockSearchMode;
import com.microsoft.windowsazure.services.blob.client.ContainerRequest;
import com.microsoft.windowsazure.services.blob.client.DeleteSnapshotsOption;
import com.microsoft.windowsazure.services.blob.client.PageOperationType;
import com.microsoft.windowsazure.services.blob.client.PageProperties;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseRequest;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LeaseAction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class BlobRequest {
    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        BaseRequest.addMetadata(request, name, value, opContext);
    }

    public static HttpURLConnection copyFrom(URI uri, int timeout, String source, String sourceSnapshotID, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (sourceSnapshotID != null) {
            source = source.concat("?snapshot=");
            source = source.concat(sourceSnapshotID);
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, null, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-source", source);
        if (sourceAccessCondition != null) {
            sourceAccessCondition.applyConditionToRequest(request, true);
        }
        if (destinationAccessCondition != null) {
            destinationAccessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection abortCopy(URI uri, int timeout, String copyId, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "copy");
        builder.add("copyid", copyId);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-action", "abort");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request, true);
        }
        return request;
    }

    private static HttpURLConnection createURLConnection(URI uri, int timeout, UriQueryBuilder query, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.createURLConnection(uri, timeout, query, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, String snapshotVersion, DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (snapshotVersion != null && deleteSnapshotsOption != DeleteSnapshotsOption.NONE) {
            throw new IllegalArgumentException(String.format("The option '%s' must be 'None' to delete a specific snapshot specified by '%s'", "deleteSnapshotsOption", "snapshot"));
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.delete(uri, timeout, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        switch (deleteSnapshotsOption) {
            case NONE: {
                break;
            }
            case INCLUDE_SNAPSHOTS: {
                request.setRequestProperty("x-ms-delete-snapshots", "include");
                break;
            }
            case DELETE_SNAPSHOTS_ONLY: {
                request.setRequestProperty("x-ms-delete-snapshots", "only");
                break;
            }
        }
        return request;
    }

    public static HttpURLConnection get(URI uri, int timeout, String snapshotVersion, long offset, long count, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BlobRequest.get(uri, timeout, snapshotVersion, accessCondition, blobOptions, opContext);
        String rangeHeaderValue = String.format(Utility.LOCALE_US, "bytes=%d-%d", offset, offset + count - 1L);
        request.setRequestProperty("x-ms-range", rangeHeaderValue);
        return request;
    }

    public static HttpURLConnection get(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getBlockList(URI uri, int timeout, String snapshotVersion, BlockListingFilter blockFilter, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "blocklist");
        builder.add("blocklisttype", blockFilter.toString());
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getPageRanges(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "pagelist");
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BaseRequest.addOptionalHeader(request, "snapshot", snapshotVersion);
        return request;
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.getProperties(uri, timeout, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection lease(URI uri, int timeout, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "lease");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("x-ms-lease-action", action.toString());
        if (leaseTimeInSeconds != null) {
            request.setRequestProperty("x-ms-lease-duration", leaseTimeInSeconds.toString());
        } else {
            request.setRequestProperty("x-ms-lease-duration", "-1");
        }
        if (proposedLeaseId != null) {
            request.setRequestProperty("x-ms-proposed-lease-id", proposedLeaseId);
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection list(URI uri, int timeout, BlobListingContext listingContext, BlobRequestOptions blobOptions, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getDelimiter())) {
                builder.add("delimiter", listingContext.getDelimiter());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
            if (listingContext.getListingDetails().size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean started = false;
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.SNAPSHOTS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append("snapshots");
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.UNCOMMITTED_BLOBS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append("uncommittedblobs");
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.METADATA)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append("metadata");
                }
                builder.add("include", sb.toString());
            }
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection put(URI uri, int timeout, BlobProperties properties, BlobType blobType, long pageBlobSize, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (blobType == BlobType.UNSPECIFIED) {
            throw new IllegalArgumentException("The blob type cannot be undefined.");
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, null, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        BaseRequest.addOptionalHeader(request, "Cache-Control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "Content-Type", properties.getContentType());
        BaseRequest.addOptionalHeader(request, "Content-MD5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "Content-Language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "Content-Encoding", properties.getContentEncoding());
        if (blobType == BlobType.PAGE_BLOB) {
            request.setFixedLengthStreamingMode(0);
            request.setRequestProperty("Content-Length", "0");
            request.setRequestProperty("x-ms-blob-type", "PageBlob");
            request.setRequestProperty("x-ms-blob-content-length", String.valueOf(pageBlobSize));
            properties.setLength(pageBlobSize);
        } else {
            request.setRequestProperty("x-ms-blob-type", "BlockBlob");
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlock(URI uri, int timeout, String blockId, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "block");
        builder.add("blockid", blockId);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlockList(URI uri, int timeout, BlobProperties properties, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "blocklist");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BaseRequest.addOptionalHeader(request, "x-ms-blob-cache-control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-encoding", properties.getContentEncoding());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-md5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-type", properties.getContentType());
        return request;
    }

    public static HttpURLConnection putPage(URI uri, int timeout, PageProperties properties, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "page");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (properties.getPageOperation() == PageOperationType.CLEAR) {
            request.setFixedLengthStreamingMode(0);
        }
        request.setRequestProperty("x-ms-page-write", properties.getPageOperation().toString());
        request.setRequestProperty("x-ms-range", properties.getRange().toString());
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.setMetadata(uri, timeout, null, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setProperties(URI uri, int timeout, BlobProperties properties, Long newBlobSize, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (newBlobSize != null) {
            request.setRequestProperty("x-ms-blob-content-length", newBlobSize.toString());
            properties.setLength(newBlobSize);
        }
        BaseRequest.addOptionalHeader(request, "x-ms-blob-cache-control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-encoding", properties.getContentEncoding());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-md5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-type", properties.getContentType());
        return request;
    }

    public static HttpURLConnection snapshot(URI uri, int timeout, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "snapshot");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static byte[] writeBlockListToStream(Iterable<BlockEntry> blockList, OperationContext opContext) throws XMLStreamException, StorageException {
        StringWriter outWriter = new StringWriter();
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("BlockList");
        for (BlockEntry block : blockList) {
            if (block.searchMode == BlockSearchMode.COMMITTED) {
                xmlw.writeStartElement("Committed");
            } else if (block.searchMode == BlockSearchMode.UNCOMMITTED) {
                xmlw.writeStartElement("Uncommitted");
            } else if (block.searchMode == BlockSearchMode.LATEST) {
                xmlw.writeStartElement("Latest");
            }
            xmlw.writeCharacters(block.getId());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    private BlobRequest() {
    }
}

