/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobContainerAttributes;
import com.microsoft.windowsazure.services.blob.client.BlobContainerProperties;
import com.microsoft.windowsazure.services.blob.client.BlobProperties;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.BlockEntry;
import com.microsoft.windowsazure.services.blob.client.BlockSearchMode;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.CloudBlobDirectory;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.CopyState;
import com.microsoft.windowsazure.services.blob.client.CopyStatus;
import com.microsoft.windowsazure.services.blob.client.ListBlobItem;
import com.microsoft.windowsazure.services.blob.client.PageRange;
import com.microsoft.windowsazure.services.core.storage.LeaseDuration;
import com.microsoft.windowsazure.services.core.storage.LeaseState;
import com.microsoft.windowsazure.services.core.storage.LeaseStatus;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.DeserializationHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class BlobDeserializationHelper {
    protected static CloudBlob readBlob(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Blob");
        String blobName = "";
        String snapshotID = null;
        String urlString = null;
        HashMap<String, String> metadata = null;
        BlobProperties properties = null;
        CopyState copyState = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Url")) {
                    urlString = Utility.readElementFromXMLReader(xmlr, "Url");
                    continue;
                }
                if (name.equals("Snapshot")) {
                    snapshotID = Utility.readElementFromXMLReader(xmlr, "Snapshot");
                    continue;
                }
                if (name.equals("Name")) {
                    blobName = Utility.readElementFromXMLReader(xmlr, "Name");
                    continue;
                }
                if (name.equals("Properties")) {
                    properties = BlobDeserializationHelper.readBlobProperties(xmlr);
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (name.equals("Metadata")) {
                    metadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                    xmlr.require(2, null, "Metadata");
                    continue;
                }
                if (name.equals("CopyId")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCopyId(Utility.readElementFromXMLReader(xmlr, "CopyId"));
                    continue;
                }
                if (name.equals("CopyCompletionTime")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "CopyCompletionTime")));
                    continue;
                }
                if (name.equals("CopyStatus")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatus(CopyStatus.parse(Utility.readElementFromXMLReader(xmlr, "CopyStatus")));
                    continue;
                }
                if (name.equals("CopySource")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setSource(new URI(Utility.readElementFromXMLReader(xmlr, "CopySource")));
                    continue;
                }
                if (name.equals("CopyProgress")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    String tempString = Utility.readElementFromXMLReader(xmlr, "CopyProgress");
                    String[] progressSequence = tempString.split("/");
                    copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                    copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
                    continue;
                }
                if (!name.equals("CopyStatusDescription")) continue;
                if (copyState == null) {
                    copyState = new CopyState();
                }
                copyState.setStatusDescription(Utility.readElementFromXMLReader(xmlr, "CopyStatusDescription"));
                continue;
            }
            if (eventType != 2 || !name.equals("Blob")) continue;
            break;
        }
        xmlr.require(2, null, "Blob");
        if (properties != null) {
            CloudBlob retBlob = null;
            int blobNameSectionIndex = urlString.lastIndexOf("/".concat(blobName));
            URI baseUri = new URI(urlString.substring(0, blobNameSectionIndex + 1));
            String query = null;
            if (blobNameSectionIndex + 1 + blobName.length() < urlString.length()) {
                query = urlString.substring(blobNameSectionIndex + blobName.length() + 1);
            }
            URI blobURI = new URI(baseUri.getScheme(), baseUri.getAuthority(), baseUri.getRawPath().concat(blobName), query, null);
            if (properties.getBlobType() == BlobType.BLOCK_BLOB) {
                retBlob = new CloudBlockBlob(blobURI, serviceClient, container);
            } else if (properties.getBlobType() == BlobType.PAGE_BLOB) {
                retBlob = new CloudPageBlob(blobURI, serviceClient, container);
            } else {
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            retBlob.uri = blobURI;
            retBlob.snapshotID = snapshotID;
            retBlob.properties = properties;
            retBlob.metadata = metadata;
            retBlob.copyState = copyState;
            return retBlob;
        }
        throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
    }

    public static ArrayList<BlockEntry> readBlobBlocks(XMLStreamReader xmlr, BlockSearchMode searchMode) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<BlockEntry> retBlocks = new ArrayList<BlockEntry>();
        xmlr.require(1, null, "Block");
        while (xmlr.hasNext() && "Block".equals(xmlr.getName().toString())) {
            String blockName = null;
            long blockSize = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    if (name.equals("Name")) {
                        blockName = Utility.readElementFromXMLReader(xmlr, "Name");
                        continue;
                    }
                    if (name.equals("Size")) {
                        String sizeString = Utility.readElementFromXMLReader(xmlr, "Size");
                        blockSize = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                BlockEntry newBlock = new BlockEntry(blockName, searchMode);
                newBlock.setSize(blockSize);
                retBlocks.add(newBlock);
                break;
            }
            eventType = xmlr.next();
        }
        return retBlocks;
    }

    protected static BlobContainerAttributes readBlobContainerAttributes(XMLStreamReader xmlr) throws XMLStreamException, ParseException, URISyntaxException {
        int eventType = xmlr.getEventType();
        BlobContainerAttributes attributes = new BlobContainerAttributes();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Properties")) {
                    attributes.setProperties(BlobDeserializationHelper.readBlobContainerProperties(xmlr));
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (name.equals("Url")) {
                    attributes.setUri(new URI(Utility.readElementFromXMLReader(xmlr, "Url")));
                    continue;
                }
                if (name.equals("Name")) {
                    attributes.setName(Utility.readElementFromXMLReader(xmlr, "Name"));
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                attributes.setMetadata(DeserializationHelper.parseMetadateFromXML(xmlr));
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Container")) continue;
            break;
        }
        return attributes;
    }

    protected static BlobContainerProperties readBlobContainerProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobContainerProperties properties = new BlobContainerProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(Utility.readElementFromXMLReader(xmlr, "Etag"));
                    continue;
                }
                if (name.equals("LeaseStatus")) {
                    properties.setLeaseStatus(LeaseStatus.parse(Utility.readElementFromXMLReader(xmlr, "LeaseStatus")));
                    continue;
                }
                if (name.equals("LeaseState")) {
                    properties.setLeaseState(LeaseState.parse(Utility.readElementFromXMLReader(xmlr, "LeaseState")));
                    continue;
                }
                if (!name.equals("LeaseDuration")) continue;
                properties.setLeaseDuration(LeaseDuration.parse(Utility.readElementFromXMLReader(xmlr, "LeaseDuration")));
                continue;
            }
            xmlr.require(2, null, "Properties");
            break;
        }
        return properties;
    }

    public static ArrayList<ListBlobItem> readBlobItems(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<ListBlobItem> retBlobs = new ArrayList<ListBlobItem>();
        xmlr.require(1, null, "Blobs");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType != 1) break;
            if (name.equals("Blob")) {
                retBlobs.add(BlobDeserializationHelper.readBlob(xmlr, serviceClient, container));
                continue;
            }
            if (name.equals("BlobPrefix")) {
                retBlobs.add(BlobDeserializationHelper.readDirectory(xmlr, serviceClient, container));
                continue;
            }
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        xmlr.require(2, null, "Blobs");
        return retBlobs;
    }

    protected static BlobProperties readBlobProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException, StorageException, URISyntaxException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobProperties properties = new BlobProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                String tempString;
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader(xmlr, "Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(Utility.readElementFromXMLReader(xmlr, "Etag"));
                    continue;
                }
                if (name.equals("Content-Length")) {
                    tempString = Utility.readElementFromXMLReader(xmlr, "Content-Length");
                    properties.setLength(Long.parseLong(tempString));
                    continue;
                }
                if (name.equals("Content-Type")) {
                    properties.setContentType(Utility.readElementFromXMLReader(xmlr, "Content-Type"));
                    continue;
                }
                if (name.equals("Content-Encoding")) {
                    properties.setContentEncoding(Utility.readElementFromXMLReader(xmlr, "Content-Encoding"));
                    continue;
                }
                if (name.equals("Content-Language")) {
                    properties.setContentLanguage(Utility.readElementFromXMLReader(xmlr, "Content-Language"));
                    continue;
                }
                if (name.equals("Content-MD5")) {
                    properties.setContentMD5(Utility.readElementFromXMLReader(xmlr, "Content-MD5"));
                    continue;
                }
                if (name.equals("Cache-Control")) {
                    properties.setCacheControl(Utility.readElementFromXMLReader(xmlr, "Cache-Control"));
                    continue;
                }
                if (name.equals("Cache-Control")) {
                    properties.setCacheControl(Utility.readElementFromXMLReader(xmlr, "Cache-Control"));
                    continue;
                }
                if (name.equals("x-ms-blob-sequence-number")) {
                    Utility.readElementFromXMLReader(xmlr, "x-ms-blob-sequence-number");
                    continue;
                }
                if (name.equals("BlobType")) {
                    tempString = Utility.readElementFromXMLReader(xmlr, "BlobType");
                    if (tempString.equals("BlockBlob")) {
                        properties.setBlobType(BlobType.BLOCK_BLOB);
                        continue;
                    }
                    if (tempString.equals("PageBlob")) {
                        properties.setBlobType(BlobType.PAGE_BLOB);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseStatus")) {
                    tempString = Utility.readElementFromXMLReader(xmlr, "LeaseStatus");
                    if (tempString.equals("Locked".toLowerCase())) {
                        properties.setLeaseStatus(LeaseStatus.LOCKED);
                        continue;
                    }
                    if (tempString.equals("Unlocked".toLowerCase())) {
                        properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseState")) {
                    properties.setLeaseState(LeaseState.parse(Utility.readElementFromXMLReader(xmlr, "LeaseState")));
                    continue;
                }
                if (!name.equals("LeaseDuration")) continue;
                properties.setLeaseDuration(LeaseDuration.parse(Utility.readElementFromXMLReader(xmlr, "LeaseDuration")));
                continue;
            }
            if (eventType != 2) continue;
            xmlr.require(2, null, "Properties");
            break;
        }
        return properties;
    }

    protected static CloudBlobContainer readContainer(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Container");
        BlobContainerAttributes attributes = BlobDeserializationHelper.readBlobContainerAttributes(xmlr);
        CloudBlobContainer retContainer = new CloudBlobContainer(attributes.getUri(), serviceClient);
        retContainer.setMetadata(attributes.getMetadata());
        retContainer.setName(attributes.getName());
        retContainer.setProperties(attributes.getProperties());
        retContainer.setUri(attributes.getUri());
        xmlr.require(2, null, "Container");
        return retContainer;
    }

    public static ArrayList<CloudBlobContainer> readContainers(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Containers");
        ArrayList<CloudBlobContainer> containers = new ArrayList<CloudBlobContainer>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Container".equals(xmlr.getName().toString())) {
            containers.add(BlobDeserializationHelper.readContainer(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Containers");
        return containers;
    }

    protected static CloudBlobDirectory readDirectory(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "BlobPrefix");
        xmlr.next();
        xmlr.require(1, null, "Name");
        String prefixName = Utility.readElementFromXMLReader(xmlr, "Name");
        xmlr.next();
        xmlr.require(2, null, "BlobPrefix");
        return container.getDirectoryReference(prefixName);
    }

    public static ArrayList<PageRange> readPageRanges(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<PageRange> retRanges = new ArrayList<PageRange>();
        xmlr.require(1, null, "PageRange");
        while (xmlr.hasNext() && "PageRange".equals(xmlr.getName().toString())) {
            long startOffset = -1L;
            long endOffset = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    String sizeString;
                    if (name.equals("Start")) {
                        sizeString = Utility.readElementFromXMLReader(xmlr, "Start");
                        startOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    if (name.equals("End")) {
                        sizeString = Utility.readElementFromXMLReader(xmlr, "End");
                        endOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                if (startOffset == -1L || endOffset == -1L) {
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                PageRange pageRef = new PageRange(startOffset, endOffset);
                retRanges.add(pageRef);
                break;
            }
            eventType = xmlr.next();
        }
        return retRanges;
    }

    private BlobDeserializationHelper() {
    }
}

