/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.services.core.storage.AccessPolicyResponseBase;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class BlobAccessPolicyResponse
extends AccessPolicyResponseBase<SharedAccessBlobPolicy> {
    public BlobAccessPolicyResponse(InputStream stream) {
        super(stream);
    }

    @Override
    protected SharedAccessBlobPolicy readPolicyFromXML(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "AccessPolicy");
        SharedAccessBlobPolicy retPolicy = new SharedAccessBlobPolicy();
        while (xmlr.hasNext()) {
            String tempString;
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("Permission")) {
                retPolicy.setPermissions(SharedAccessBlobPolicy.permissionsFromString(Utility.readElementFromXMLReader(xmlr, "Permission")));
                continue;
            }
            if (eventType == 1 && name.equals("Start")) {
                tempString = Utility.readElementFromXMLReader(xmlr, "Start");
                retPolicy.setSharedAccessStartTime(Utility.parseISO8061LongDateFromString(tempString));
                continue;
            }
            if (eventType == 1 && name.equals("Expiry")) {
                tempString = Utility.readElementFromXMLReader(xmlr, "Expiry");
                retPolicy.setSharedAccessExpiryTime(Utility.parseISO8061LongDateFromString(tempString));
                continue;
            }
            if (eventType != 2 || !name.equals("AccessPolicy")) continue;
            break;
        }
        xmlr.require(2, null, "AccessPolicy");
        return retPolicy;
    }
}

