/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.ConfigurationSettingInfo;
import com.microsoft.windowsazure.serviceruntime.CurrentRoleInstanceInfo;
import com.microsoft.windowsazure.serviceruntime.EndpointInfo;
import com.microsoft.windowsazure.serviceruntime.EndpointsInfo;
import com.microsoft.windowsazure.serviceruntime.LocalResource;
import com.microsoft.windowsazure.serviceruntime.LocalResourceInfo;
import com.microsoft.windowsazure.serviceruntime.Role;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentData;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentDataDeserializer;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentInfo;
import com.microsoft.windowsazure.serviceruntime.RoleInfo;
import com.microsoft.windowsazure.serviceruntime.RoleInstance;
import com.microsoft.windowsazure.serviceruntime.RoleInstanceEndpoint;
import com.microsoft.windowsazure.serviceruntime.RoleInstanceInfo;
import com.microsoft.windowsazure.serviceruntime.RoleInstancesInfo;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

class XmlRoleEnvironmentDataDeserializer
implements RoleEnvironmentDataDeserializer {
    @Override
    public RoleEnvironmentData deserialize(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)RoleEnvironmentInfo.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            RoleEnvironmentInfo environmentInfo = (RoleEnvironmentInfo)((JAXBElement)unmarshaller.unmarshal(stream)).getValue();
            Map<String, String> configurationSettings = this.translateConfigurationSettings(environmentInfo);
            Map<String, LocalResource> localResources = this.translateLocalResources(environmentInfo);
            RoleInstance currentInstance = this.translateCurrentInstance(environmentInfo);
            Map<String, Role> roles = this.translateRoles(environmentInfo, currentInstance, environmentInfo.getCurrentInstance().getRoleName());
            return new RoleEnvironmentData(environmentInfo.getDeployment().getId(), configurationSettings, localResources, currentInstance, roles, environmentInfo.getDeployment().isEmulated());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> translateConfigurationSettings(RoleEnvironmentInfo environmentInfo) {
        HashMap<String, String> configurationSettings = new HashMap<String, String>();
        for (ConfigurationSettingInfo settingInfo : environmentInfo.getCurrentInstance().getConfigurationSettings().getConfigurationSetting()) {
            configurationSettings.put(settingInfo.getName(), settingInfo.getValue());
        }
        return configurationSettings;
    }

    private Map<String, LocalResource> translateLocalResources(RoleEnvironmentInfo environmentInfo) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        for (LocalResourceInfo resourceInfo : environmentInfo.getCurrentInstance().getLocalResources().getLocalResource()) {
            localResources.put(resourceInfo.getName(), new LocalResource(resourceInfo.getSizeInMB(), resourceInfo.getName(), resourceInfo.getPath()));
        }
        return localResources;
    }

    private Map<String, Role> translateRoles(RoleEnvironmentInfo environmentInfo, RoleInstance currentInstance, String currentRole) {
        HashMap<String, Role> roles = new HashMap<String, Role>();
        for (RoleInfo roleInfo : environmentInfo.getRoles().getRole()) {
            Map<String, RoleInstance> instances = this.translateRoleInstances(roleInfo.getInstances());
            if (roleInfo.getName().equals(currentRole)) {
                instances.put(currentInstance.getId(), currentInstance);
            }
            Role role = new Role(roleInfo.getName(), instances);
            for (RoleInstance instance : role.getInstances().values()) {
                instance.setRole(role);
            }
            roles.put(roleInfo.getName(), role);
        }
        if (!roles.containsKey(currentRole)) {
            HashMap<String, RoleInstance> instances = new HashMap<String, RoleInstance>();
            instances.put(currentInstance.getId(), currentInstance);
            Role singleRole = new Role(currentRole, instances);
            currentInstance.setRole(singleRole);
            roles.put(currentRole, singleRole);
        }
        return roles;
    }

    private Map<String, RoleInstance> translateRoleInstances(RoleInstancesInfo instancesInfo) {
        HashMap<String, RoleInstance> roleInstances = new HashMap<String, RoleInstance>();
        for (RoleInstanceInfo instanceInfo : instancesInfo.getInstance()) {
            RoleInstance instance = new RoleInstance(instanceInfo.getId(), instanceInfo.getFaultDomain(), instanceInfo.getUpdateDomain(), this.translateRoleInstanceEndpoints(instanceInfo.getEndpoints()));
            for (RoleInstanceEndpoint endpoint : instance.getInstanceEndpoints().values()) {
                endpoint.setRoleInstance(instance);
            }
            roleInstances.put(instance.getId(), instance);
        }
        return roleInstances;
    }

    private Map<String, RoleInstanceEndpoint> translateRoleInstanceEndpoints(EndpointsInfo endpointsInfo) {
        HashMap<String, RoleInstanceEndpoint> endpoints = new HashMap<String, RoleInstanceEndpoint>();
        for (EndpointInfo endpointInfo : endpointsInfo.getEndpoint()) {
            RoleInstanceEndpoint endpoint = new RoleInstanceEndpoint(endpointInfo.getProtocol().toString(), new InetSocketAddress(endpointInfo.getAddress(), endpointInfo.getPort()));
            endpoints.put(endpointInfo.getName(), endpoint);
        }
        return endpoints;
    }

    private RoleInstance translateCurrentInstance(RoleEnvironmentInfo environmentInfo) {
        CurrentRoleInstanceInfo currentInstanceInfo = environmentInfo.getCurrentInstance();
        RoleInstance currentInstance = new RoleInstance(currentInstanceInfo.getId(), currentInstanceInfo.getFaultDomain(), currentInstanceInfo.getUpdateDomain(), this.translateRoleInstanceEndpoints(environmentInfo.getCurrentInstance().getEndpoints()));
        for (RoleInstanceEndpoint endpoint : currentInstance.getInstanceEndpoints().values()) {
            endpoint.setRoleInstance(currentInstance);
        }
        return currentInstance;
    }
}

