/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.InputChannel;
import com.microsoft.windowsazure.serviceruntime.RuntimeServerDiscoveryInfo;
import com.microsoft.windowsazure.serviceruntime.RuntimeServerEndpointInfo;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

class RuntimeVersionProtocolClient {
    private final InputChannel inputChannel;

    public RuntimeVersionProtocolClient(InputChannel inputChannel) {
        this.inputChannel = inputChannel;
    }

    public Map<String, String> getVersionMap(String connectionPath) {
        try {
            HashMap<String, String> versions = new HashMap<String, String>();
            JAXBContext context = JAXBContext.newInstance((String)RuntimeServerDiscoveryInfo.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            InputStream input = this.inputChannel.getInputStream(connectionPath);
            RuntimeServerDiscoveryInfo discoveryInfo = (RuntimeServerDiscoveryInfo)((JAXBElement)unmarshaller.unmarshal(input)).getValue();
            for (RuntimeServerEndpointInfo endpointInfo : discoveryInfo.getRuntimeServerEndpoints().getRuntimeServerEndpoint()) {
                versions.put(endpointInfo.getVersion(), endpointInfo.getPath());
            }
            return versions;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

