/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.AcquireCurrentState;
import com.microsoft.windowsazure.serviceruntime.CurrentState;
import com.microsoft.windowsazure.serviceruntime.CurrentStatus;
import com.microsoft.windowsazure.serviceruntime.GoalState;
import com.microsoft.windowsazure.serviceruntime.GoalStateChangedListener;
import com.microsoft.windowsazure.serviceruntime.LocalResource;
import com.microsoft.windowsazure.serviceruntime.ReleaseCurrentState;
import com.microsoft.windowsazure.serviceruntime.Role;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentChange;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentChangedEvent;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentChangedListener;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentChangingEvent;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentChangingListener;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentConfigurationSettingChange;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentData;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentNotAvailableException;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentStoppingListener;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentTopologyChange;
import com.microsoft.windowsazure.serviceruntime.RoleInstance;
import com.microsoft.windowsazure.serviceruntime.RoleInstanceEndpoint;
import com.microsoft.windowsazure.serviceruntime.RoleInstanceStatus;
import com.microsoft.windowsazure.serviceruntime.RuntimeClient;
import com.microsoft.windowsazure.serviceruntime.RuntimeKernel;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public final class RoleEnvironment {
    private static final String VersionEndpointEnvironmentName = "WaRuntimeEndpoint";
    private static final String VersionEndpointFixedPath = "\\\\.\\pipe\\WindowsAzureRuntime";
    private static final String clientId;
    private static RuntimeClient runtimeClient;
    private static AtomicReference<GoalState> currentGoalState;
    private static AtomicReference<RoleEnvironmentData> currentEnvironmentData;
    private static List<RoleEnvironmentChangingListener> changingListeners;
    private static List<RoleEnvironmentChangedListener> changedListeners;
    private static List<RoleEnvironmentStoppingListener> stoppingListeners;
    private static AtomicReference<CurrentState> lastState;
    private static final Calendar maxDateTime;

    private RoleEnvironment() {
    }

    private static synchronized void initialize() {
        if (runtimeClient == null) {
            String endpoint = System.getenv(VersionEndpointEnvironmentName);
            if (endpoint == null) {
                endpoint = VersionEndpointFixedPath;
            }
            RuntimeKernel kernel = RuntimeKernel.getKernel();
            try {
                runtimeClient = kernel.getRuntimeVersionManager().getRuntimeClient(endpoint);
            }
            catch (Throwable t) {
                throw new RoleEnvironmentNotAvailableException(t);
            }
            changingListeners = new LinkedList<RoleEnvironmentChangingListener>();
            changedListeners = new LinkedList<RoleEnvironmentChangedListener>();
            stoppingListeners = new LinkedList<RoleEnvironmentStoppingListener>();
            try {
                currentGoalState = new AtomicReference<GoalState>(runtimeClient.getCurrentGoalState());
                currentEnvironmentData = new AtomicReference<RoleEnvironmentData>(runtimeClient.getRoleEnvironmentData());
            }
            catch (InterruptedException e) {
                throw new RoleEnvironmentNotAvailableException(e);
            }
            lastState = new AtomicReference();
            runtimeClient.addGoalStateChangedListener(new GoalStateChangedListener(){

                @Override
                public void goalStateChanged(GoalState newGoalState) {
                    switch (newGoalState.getExpectedState()) {
                        case STARTED: {
                            if (newGoalState.getIncarnation().compareTo(((GoalState)currentGoalState.get()).getIncarnation()) <= 0) break;
                            RoleEnvironment.processGoalStateChange(newGoalState);
                            break;
                        }
                        case STOPPED: {
                            RoleEnvironment.raiseStoppingEvent();
                            AcquireCurrentState stoppedState = new AcquireCurrentState(clientId, newGoalState.getIncarnation(), CurrentStatus.STOPPED, maxDateTime);
                            runtimeClient.setCurrentState(stoppedState);
                        }
                    }
                }
            });
        } else {
            try {
                currentGoalState.set(runtimeClient.getCurrentGoalState());
                currentEnvironmentData.set(runtimeClient.getRoleEnvironmentData());
            }
            catch (InterruptedException e) {
                throw new RoleEnvironmentNotAvailableException(e);
            }
        }
    }

    private static void processGoalStateChange(GoalState newGoalState) {
        LinkedList<RoleEnvironmentChange> changes = new LinkedList<RoleEnvironmentChange>();
        RoleEnvironmentChangingEvent changingEvent = new RoleEnvironmentChangingEvent(changes);
        CurrentState last = lastState.get();
        RoleEnvironment.calculateChanges(changes);
        if (changes.isEmpty()) {
            RoleEnvironment.acceptLatestIncarnation(newGoalState, last);
        } else {
            for (RoleEnvironmentChangingListener roleEnvironmentChangingListener : changingListeners) {
                try {
                    roleEnvironmentChangingListener.roleEnvironmentChanging(changingEvent);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (changingEvent.isCancelled()) {
                AcquireCurrentState recycleState = new AcquireCurrentState(clientId, newGoalState.getIncarnation(), CurrentStatus.RECYCLE, maxDateTime);
                runtimeClient.setCurrentState(recycleState);
                return;
            }
            RoleEnvironment.acceptLatestIncarnation(newGoalState, last);
            try {
                currentEnvironmentData.set(runtimeClient.getRoleEnvironmentData());
            }
            catch (InterruptedException e) {
                throw new RoleEnvironmentNotAvailableException(e);
            }
            for (RoleEnvironmentChangedListener roleEnvironmentChangedListener : changedListeners) {
                try {
                    roleEnvironmentChangedListener.roleEnvironmentChanged(new RoleEnvironmentChangedEvent(changes));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static void acceptLatestIncarnation(GoalState newGoalState, CurrentState last) {
        if (last != null && last instanceof AcquireCurrentState) {
            AcquireCurrentState acquireState = (AcquireCurrentState)last;
            AcquireCurrentState acceptState = new AcquireCurrentState(clientId, newGoalState.getIncarnation(), acquireState.getStatus(), acquireState.getExpiration());
            runtimeClient.setCurrentState(acceptState);
        }
        currentGoalState.set(newGoalState);
    }

    private static void calculateChanges(List<RoleEnvironmentChange> changes) {
        RoleInstanceEndpoint newEndpoint;
        RoleInstanceEndpoint currentEndpoint;
        RoleInstance newInstance;
        RoleInstance currentInstance;
        Role newRole;
        Role currentRole;
        RoleEnvironmentData newData;
        RoleEnvironmentData current = currentEnvironmentData.get();
        try {
            newData = runtimeClient.getRoleEnvironmentData();
        }
        catch (InterruptedException e) {
            throw new RoleEnvironmentNotAvailableException(e);
        }
        Map<String, String> currentConfig = current.getConfigurationSettings();
        Map<String, String> newConfig = newData.getConfigurationSettings();
        Map<String, Role> currentRoles = current.getRoles();
        Map<String, Role> newRoles = newData.getRoles();
        for (String setting : currentConfig.keySet()) {
            if (newConfig.containsKey(setting)) {
                if (newConfig.get(setting).equals(currentConfig.get(setting))) continue;
                changes.add(new RoleEnvironmentConfigurationSettingChange(setting));
                continue;
            }
            changes.add(new RoleEnvironmentConfigurationSettingChange(setting));
        }
        for (String setting : newConfig.keySet()) {
            if (currentConfig.containsKey(setting)) continue;
            changes.add(new RoleEnvironmentConfigurationSettingChange(setting));
        }
        HashSet<String> changedRoleSet = new HashSet<String>();
        for (String role : currentRoles.keySet()) {
            if (newRoles.containsKey(role)) {
                currentRole = currentRoles.get(role);
                newRole = newRoles.get(role);
                for (String instance : currentRole.getInstances().keySet()) {
                    if (newRole.getInstances().containsKey(instance)) {
                        currentInstance = currentRole.getInstances().get(instance);
                        newInstance = newRole.getInstances().get(instance);
                        if (currentInstance.getUpdateDomain() == newInstance.getUpdateDomain() && currentInstance.getFaultDomain() == newInstance.getFaultDomain()) {
                            for (String endpoint : currentInstance.getInstanceEndpoints().keySet()) {
                                if (newInstance.getInstanceEndpoints().containsKey(endpoint)) {
                                    currentEndpoint = currentInstance.getInstanceEndpoints().get(endpoint);
                                    newEndpoint = newInstance.getInstanceEndpoints().get(endpoint);
                                    if (currentEndpoint.getProtocol().equals(newEndpoint.getProtocol()) && currentEndpoint.getIpEndPoint().equals(newEndpoint.getIpEndPoint())) continue;
                                    changedRoleSet.add(role);
                                    continue;
                                }
                                changedRoleSet.add(role);
                            }
                            continue;
                        }
                        changedRoleSet.add(role);
                        continue;
                    }
                    changedRoleSet.add(role);
                }
                continue;
            }
            changedRoleSet.add(role);
        }
        for (String role : newRoles.keySet()) {
            if (currentRoles.containsKey(role)) {
                currentRole = currentRoles.get(role);
                newRole = newRoles.get(role);
                for (String instance : newRole.getInstances().keySet()) {
                    if (currentRole.getInstances().containsKey(instance)) {
                        currentInstance = currentRole.getInstances().get(instance);
                        newInstance = newRole.getInstances().get(instance);
                        if (currentInstance.getUpdateDomain() == newInstance.getUpdateDomain() && currentInstance.getFaultDomain() == newInstance.getFaultDomain()) {
                            for (String endpoint : newInstance.getInstanceEndpoints().keySet()) {
                                if (currentInstance.getInstanceEndpoints().containsKey(endpoint)) {
                                    currentEndpoint = currentInstance.getInstanceEndpoints().get(endpoint);
                                    newEndpoint = newInstance.getInstanceEndpoints().get(endpoint);
                                    if (currentEndpoint.getProtocol().equals(newEndpoint.getProtocol()) && currentEndpoint.getIpEndPoint().equals(newEndpoint.getIpEndPoint())) continue;
                                    changedRoleSet.add(role);
                                    continue;
                                }
                                changedRoleSet.add(role);
                            }
                            continue;
                        }
                        changedRoleSet.add(role);
                        continue;
                    }
                    changedRoleSet.add(role);
                }
                continue;
            }
            changedRoleSet.add(role);
        }
        for (String role : changedRoleSet) {
            changes.add(new RoleEnvironmentTopologyChange(role));
        }
    }

    private static synchronized void raiseStoppingEvent() {
        for (RoleEnvironmentStoppingListener listener : stoppingListeners) {
            try {
                listener.roleEnvironmentStopping();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static RoleInstance getCurrentRoleInstance() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().getCurrentInstance();
    }

    public static String getDeploymentId() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().getDeploymentId();
    }

    public static boolean isAvailable() {
        try {
            RoleEnvironment.initialize();
        }
        catch (RoleEnvironmentNotAvailableException roleEnvironmentNotAvailableException) {
            // empty catch block
        }
        return runtimeClient != null;
    }

    public static boolean isEmulated() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().isEmulated();
    }

    public static Map<String, Role> getRoles() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().getRoles();
    }

    public static Map<String, String> getConfigurationSettings() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().getConfigurationSettings();
    }

    public static Map<String, LocalResource> getLocalResources() {
        RoleEnvironment.initialize();
        return currentEnvironmentData.get().getLocalResources();
    }

    public static void requestRecycle() {
        RoleEnvironment.initialize();
        AcquireCurrentState recycleState = new AcquireCurrentState(clientId, currentGoalState.get().getIncarnation(), CurrentStatus.RECYCLE, maxDateTime);
        runtimeClient.setCurrentState(recycleState);
    }

    public static void setStatus(RoleInstanceStatus status, Date expiration_utc) {
        RoleEnvironment.initialize();
        CurrentStatus currentStatus = CurrentStatus.STARTED;
        switch (status) {
            case Busy: {
                currentStatus = CurrentStatus.BUSY;
                break;
            }
            case Ready: {
                currentStatus = CurrentStatus.STARTED;
            }
        }
        Calendar expiration = Calendar.getInstance();
        expiration.setTime(expiration_utc);
        AcquireCurrentState newState = new AcquireCurrentState(clientId, currentGoalState.get().getIncarnation(), currentStatus, expiration);
        lastState.set(newState);
        runtimeClient.setCurrentState(newState);
    }

    public static void clearStatus() {
        RoleEnvironment.initialize();
        ReleaseCurrentState newState = new ReleaseCurrentState(clientId);
        lastState.set(newState);
        runtimeClient.setCurrentState(newState);
    }

    public static synchronized void addRoleEnvironmentChangedListener(RoleEnvironmentChangedListener listener) {
        RoleEnvironment.initialize();
        changedListeners.add(listener);
    }

    public static synchronized void removeRoleEnvironmentChangedListener(RoleEnvironmentChangedListener listener) {
        RoleEnvironment.initialize();
        changedListeners.remove(listener);
    }

    public static synchronized void addRoleEnvironmentChangingListener(RoleEnvironmentChangingListener listener) {
        RoleEnvironment.initialize();
        changingListeners.add(listener);
    }

    public static void removeRoleEnvironmentChangingListener(RoleEnvironmentChangingListener listener) {
        RoleEnvironment.initialize();
        changingListeners.remove(listener);
    }

    public static synchronized void addRoleEnvironmentStoppingListener(RoleEnvironmentStoppingListener listener) {
        RoleEnvironment.initialize();
        stoppingListeners.add(listener);
    }

    public static synchronized void removeRoleEnvironmentStoppingListener(RoleEnvironmentStoppingListener listener) {
        RoleEnvironment.initialize();
        stoppingListeners.remove(listener);
    }

    static {
        try {
            JAXBContext.newInstance((String)RoleEnvironment.class.getPackage().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        clientId = UUID.randomUUID().toString();
        maxDateTime = DatatypeConverter.parseDateTime((String)"9999-12-31T23:59:59.9999999");
    }
}

