/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.GoalState;
import com.microsoft.windowsazure.serviceruntime.GoalStateChangedListener;
import com.microsoft.windowsazure.serviceruntime.GoalStateDeserializer;
import com.microsoft.windowsazure.serviceruntime.InputChannel;
import com.microsoft.windowsazure.serviceruntime.Protocol1RuntimeCurrentStateClient;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentData;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentDataDeserializer;
import com.microsoft.windowsazure.serviceruntime.RuntimeGoalStateClient;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class Protocol1RuntimeGoalStateClient
implements RuntimeGoalStateClient {
    private final Protocol1RuntimeCurrentStateClient currentStateClient;
    private Thread ioThread;
    private final GoalStateDeserializer goalStateDeserializer;
    private final RoleEnvironmentDataDeserializer roleEnvironmentDeserializer;
    private final InputChannel inputChannel;
    private final CountDownLatch goalStateLatch;
    private final List<GoalStateChangedListener> listeners;
    private String endpoint;
    private AtomicReference<GoalState> currentGoalState;
    private AtomicReference<RoleEnvironmentData> currentEnvironmentData;

    public Protocol1RuntimeGoalStateClient(Protocol1RuntimeCurrentStateClient currentStateClient, GoalStateDeserializer goalStateDeserializer, RoleEnvironmentDataDeserializer roleEnvironmentDeserializer, InputChannel inputChannel) {
        this.currentStateClient = currentStateClient;
        this.goalStateDeserializer = goalStateDeserializer;
        this.roleEnvironmentDeserializer = roleEnvironmentDeserializer;
        this.inputChannel = inputChannel;
        this.listeners = new LinkedList<GoalStateChangedListener>();
        this.goalStateLatch = new CountDownLatch(1);
        this.currentGoalState = new AtomicReference();
        this.currentEnvironmentData = new AtomicReference();
    }

    @Override
    public GoalState getCurrentGoalState() throws InterruptedException {
        this.ensureGoalStateRetrieved();
        return this.currentGoalState.get();
    }

    @Override
    public synchronized RoleEnvironmentData getRoleEnvironmentData() throws InterruptedException {
        this.ensureGoalStateRetrieved();
        if (this.currentEnvironmentData.get() == null) {
            GoalState current = this.currentGoalState.get();
            if (current.getEnvironmentPath() == null) {
                throw new InterruptedException("No role environment data for the current goal state.");
            }
            InputStream environmentStream = this.inputChannel.getInputStream(current.getEnvironmentPath());
            this.currentEnvironmentData.set(this.roleEnvironmentDeserializer.deserialize(environmentStream));
        }
        return this.currentEnvironmentData.get();
    }

    @Override
    public void addGoalStateChangedListener(GoalStateChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeGoalStateChangedListener(GoalStateChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    private void ensureGoalStateRetrieved() throws InterruptedException {
        this.ensureThread();
        if (this.currentGoalState.get() == null) {
            while (!this.goalStateLatch.await(100L, TimeUnit.MILLISECONDS)) {
                this.ensureThread();
            }
        }
    }

    private void ensureThread() {
        if (this.ioThread == null || !this.ioThread.isAlive()) {
            this.startGoalStateTask();
        }
    }

    private void startGoalStateTask() {
        Runnable goalStateListener = new Runnable(){

            @Override
            public void run() {
                InputStream inputStream = Protocol1RuntimeGoalStateClient.this.inputChannel.getInputStream(Protocol1RuntimeGoalStateClient.this.endpoint);
                Protocol1RuntimeGoalStateClient.this.goalStateDeserializer.initialize(inputStream);
                GoalState goalState = Protocol1RuntimeGoalStateClient.this.goalStateDeserializer.deserialize();
                if (goalState == null) {
                    return;
                }
                Protocol1RuntimeGoalStateClient.this.currentGoalState.set(goalState);
                if (goalState.getEnvironmentPath() != null) {
                    Protocol1RuntimeGoalStateClient.this.currentEnvironmentData.set(null);
                }
                Protocol1RuntimeGoalStateClient.this.currentStateClient.setEndpoint(((GoalState)Protocol1RuntimeGoalStateClient.this.currentGoalState.get()).getCurrentStateEndpoint());
                Protocol1RuntimeGoalStateClient.this.goalStateLatch.countDown();
                block0: while ((goalState = Protocol1RuntimeGoalStateClient.this.goalStateDeserializer.deserialize()) != null) {
                    Protocol1RuntimeGoalStateClient.this.currentGoalState.set(goalState);
                    if (goalState.getEnvironmentPath() != null) {
                        Protocol1RuntimeGoalStateClient.this.currentEnvironmentData.set(null);
                    }
                    Protocol1RuntimeGoalStateClient.this.currentStateClient.setEndpoint(((GoalState)Protocol1RuntimeGoalStateClient.this.currentGoalState.get()).getCurrentStateEndpoint());
                    Iterator i$ = Protocol1RuntimeGoalStateClient.this.listeners.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block0;
                        GoalStateChangedListener listener = (GoalStateChangedListener)i$.next();
                        listener.goalStateChanged((GoalState)Protocol1RuntimeGoalStateClient.this.currentGoalState.get());
                    }
                    break;
                }
                return;
            }
        };
        this.ioThread = new Thread(goalStateListener);
        this.ioThread.setDaemon(true);
        this.ioThread.start();
    }
}

