/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.serviceruntime;

import com.microsoft.windowsazure.serviceruntime.CurrentState;
import com.microsoft.windowsazure.serviceruntime.CurrentStateSerializer;
import com.microsoft.windowsazure.serviceruntime.OutputChannel;
import com.microsoft.windowsazure.serviceruntime.RoleEnvironmentNotAvailableException;
import com.microsoft.windowsazure.serviceruntime.RuntimeCurrentStateClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;

class Protocol1RuntimeCurrentStateClient
implements RuntimeCurrentStateClient {
    private final CurrentStateSerializer serializer;
    private final OutputChannel outputChannel;
    private final AtomicReference<String> endpoint;

    public Protocol1RuntimeCurrentStateClient(CurrentStateSerializer serializer, OutputChannel outputChannel) {
        this.serializer = serializer;
        this.outputChannel = outputChannel;
        this.endpoint = new AtomicReference();
    }

    public void setEndpoint(String endpoint) {
        this.endpoint.set(endpoint);
    }

    @Override
    public void setCurrentState(CurrentState state) {
        OutputStream outputStream = this.outputChannel.getOutputStream(this.endpoint.get());
        this.serializer.serialize(state, outputStream);
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new RoleEnvironmentNotAvailableException(e);
        }
    }
}

