/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithm;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithmFactoryList;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKeyCache;
import com.microsoft.sqlserver.jdbc.SqlFedAuthToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SQLServerSecurityUtility {
    private static final Logger connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerConnection");
    static final int GONE = 410;
    static final int TOO_MANY_RESQUESTS = 429;
    static final int NOT_FOUND = 404;
    static final int INTERNAL_SERVER_ERROR = 500;
    static final int NETWORK_CONNECT_TIMEOUT_ERROR = 599;
    static final String WINDOWS_KEY_STORE_NAME = "MSSQL_CERTIFICATE_STORE";

    SQLServerSecurityUtility() {
    }

    static byte[] getHMACWithSHA256(byte[] plainText, byte[] key, int length) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] hash = new byte[length];
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec ivkeySpec = new SecretKeySpec(key, "HmacSHA256");
        mac.init(ivkeySpec);
        byte[] computedHash = mac.doFinal(plainText);
        System.arraycopy(computedHash, 0, hash, 0, hash.length);
        return hash;
    }

    static boolean compareBytes(byte[] buffer1, byte[] buffer2, int buffer2Index, int lengthToCompare) {
        if (null == buffer1 || null == buffer2) {
            return false;
        }
        if (buffer2.length - buffer2Index < lengthToCompare) {
            return false;
        }
        for (int index = 0; index < buffer1.length && index < lengthToCompare; ++index) {
            if (buffer1[index] == buffer2[buffer2Index + index]) continue;
            return false;
        }
        return true;
    }

    static SQLServerColumnEncryptionKeyStoreProvider getColumnEncryptionKeyStoreProvider(String providerName, SQLServerConnection connection, SQLServerStatement statement) throws SQLServerException {
        assert (providerName != null && providerName.length() != 0) : "Provider name should not be null or empty";
        if (statement != null && statement.hasColumnEncryptionKeyStoreProvidersRegistered()) {
            return statement.getColumnEncryptionKeyStoreProvider(providerName);
        }
        return connection.getColumnEncryptionKeyStoreProviderOnConnection(providerName);
    }

    static boolean shouldUseInstanceLevelProviderFlow(String keyStoreName, SQLServerConnection connection, SQLServerStatement statement) {
        return !keyStoreName.equalsIgnoreCase(WINDOWS_KEY_STORE_NAME) && (connection.hasConnectionColumnEncryptionKeyStoreProvidersRegistered() || null != statement && statement.hasColumnEncryptionKeyStoreProvidersRegistered());
    }

    static SQLServerSymmetricKey getKeyFromLocalProviders(EncryptionKeyInfo keyInfo, SQLServerConnection connection, SQLServerStatement statement) throws SQLServerException {
        String serverName = connection.getTrustedServerNameAE();
        assert (null != serverName) : "serverName should not be null in getKey.";
        if (connectionlogger.isLoggable(Level.FINE)) {
            connectionlogger.fine("Checking trusted master key path...");
        }
        Boolean[] hasEntry = new Boolean[1];
        List<String> trustedKeyPaths = SQLServerConnection.getColumnEncryptionTrustedMasterKeyPaths(serverName, hasEntry);
        if (hasEntry[0].booleanValue() && (null == trustedKeyPaths || 0 == trustedKeyPaths.size() || !trustedKeyPaths.contains(keyInfo.keyPath))) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UntrustedKeyPath"));
            Object[] msgArgs = new Object[]{keyInfo.keyPath, serverName};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        SQLServerException lastException = null;
        SQLServerColumnEncryptionKeyStoreProvider provider = null;
        byte[] plaintextKey = null;
        try {
            provider = SQLServerSecurityUtility.getColumnEncryptionKeyStoreProvider(keyInfo.keyStoreName, connection, statement);
            plaintextKey = provider.decryptColumnEncryptionKey(keyInfo.keyPath, keyInfo.algorithmName, keyInfo.encryptedKey);
        }
        catch (SQLServerException e) {
            lastException = e;
        }
        if (null == plaintextKey) {
            if (null != lastException) {
                throw lastException;
            }
            throw new SQLServerException(null, SQLServerException.getErrString("R_CEKDecryptionFailed"), null, 0, false);
        }
        return new SQLServerSymmetricKey(plaintextKey);
    }

    static byte[] encryptWithKey(byte[] plainText, CryptoMetadata md, SQLServerConnection connection, SQLServerStatement statement) throws SQLServerException {
        String serverName = connection.getTrustedServerNameAE();
        assert (serverName != null) : "Server name should not be null in EncryptWithKey";
        if (!md.isAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(md, connection, statement);
        }
        assert (md.isAlgorithmInitialized());
        byte[] cipherText = md.cipherAlgorithm.encryptData(plainText);
        if (null == cipherText || 0 == cipherText.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullCipherTextAE"), null, 0, false);
        }
        return cipherText;
    }

    private static String ValidateAndGetEncryptionAlgorithmName(byte cipherAlgorithmId, String cipherAlgorithmName) throws SQLServerException {
        if (2 != cipherAlgorithmId) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_CustomCipherAlgorithmNotSupportedAE"), null, 0, false);
        }
        return "AEAD_AES_256_CBC_HMAC_SHA256";
    }

    static void decryptSymmetricKey(CryptoMetadata md, SQLServerConnection connection, SQLServerStatement statement) throws SQLServerException {
        assert (null != md) : "md should not be null in DecryptSymmetricKey.";
        assert (null != md.cekTableEntry) : "md.EncryptionInfo should not be null in DecryptSymmetricKey.";
        assert (null != md.cekTableEntry.columnEncryptionKeyValues) : "md.EncryptionInfo.ColumnEncryptionKeyValues should not be null in DecryptSymmetricKey.";
        SQLServerSymmetricKey symKey = null;
        EncryptionKeyInfo encryptionkeyInfoChosen = null;
        SQLServerSymmetricKeyCache globalCEKCache = SQLServerSymmetricKeyCache.getInstance();
        Iterator<EncryptionKeyInfo> it = md.cekTableEntry.columnEncryptionKeyValues.iterator();
        SQLServerException lastException = null;
        while (it.hasNext()) {
            EncryptionKeyInfo keyInfo = it.next();
            try {
                symKey = SQLServerSecurityUtility.shouldUseInstanceLevelProviderFlow(keyInfo.keyStoreName, connection, statement) ? SQLServerSecurityUtility.getKeyFromLocalProviders(keyInfo, connection, statement) : globalCEKCache.getKey(keyInfo, connection);
                if (null == symKey) continue;
                encryptionkeyInfoChosen = keyInfo;
                break;
            }
            catch (SQLServerException e) {
                lastException = e;
            }
        }
        if (null == symKey) {
            if (null != lastException) {
                throw lastException;
            }
            throw new SQLServerException(null, SQLServerException.getErrString("R_CEKDecryptionFailed"), null, 0, false);
        }
        md.cipherAlgorithm = null;
        SQLServerEncryptionAlgorithm cipherAlgorithm = null;
        String algorithmName = SQLServerSecurityUtility.ValidateAndGetEncryptionAlgorithmName(md.cipherAlgorithmId, md.cipherAlgorithmName);
        cipherAlgorithm = SQLServerEncryptionAlgorithmFactoryList.getInstance().getAlgorithm(symKey, md.encryptionType, algorithmName);
        assert (null != cipherAlgorithm) : "Cipher algorithm cannot be null in DecryptSymmetricKey";
        md.cipherAlgorithm = cipherAlgorithm;
        md.encryptionKeyInfo = encryptionkeyInfoChosen;
    }

    static byte[] decryptWithKey(byte[] cipherText, CryptoMetadata md, SQLServerConnection connection, SQLServerStatement statement) throws SQLServerException {
        String serverName = connection.getTrustedServerNameAE();
        assert (null != serverName) : "serverName should not be null in DecryptWithKey.";
        if (!md.isAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(md, connection, statement);
        }
        assert (md.isAlgorithmInitialized()) : "Decryption Algorithm is not initialized";
        byte[] plainText = md.cipherAlgorithm.decryptData(cipherText);
        if (null == plainText) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_PlainTextNullAE"), null, 0, false);
        }
        return plainText;
    }

    static void verifyColumnMasterKeyMetadata(SQLServerConnection connection, SQLServerStatement statement, String keyStoreName, String keyPath, String serverName, boolean isEnclaveEnabled, byte[] CMKSignature) throws SQLServerException {
        Boolean[] hasEntry = new Boolean[1];
        List<String> trustedKeyPaths = SQLServerConnection.getColumnEncryptionTrustedMasterKeyPaths(serverName, hasEntry);
        if (hasEntry[0].booleanValue() && (null == trustedKeyPaths || 0 == trustedKeyPaths.size() || !trustedKeyPaths.contains(keyPath))) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UntrustedKeyPath"));
            Object[] msgArgs = new Object[]{keyPath, serverName};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        SQLServerColumnEncryptionKeyStoreProvider provider = null;
        provider = SQLServerSecurityUtility.shouldUseInstanceLevelProviderFlow(keyStoreName, connection, statement) ? SQLServerSecurityUtility.getColumnEncryptionKeyStoreProvider(keyStoreName, connection, statement) : connection.getSystemOrGlobalColumnEncryptionKeyStoreProvider(keyStoreName);
        if (!provider.verifyColumnMasterKeyMetadata(keyPath, isEnclaveEnabled, CMKSignature)) {
            throw new SQLServerException(SQLServerException.getErrString("R_VerifySignature"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SqlFedAuthToken getMSIAuthToken(String resource, String msiClientId) throws SQLServerException {
        boolean isAzureFunction;
        String identityHeader;
        int imdsUpgradeTimeInMs = 70000;
        ArrayList<Integer> retrySlots = new ArrayList<Integer>();
        StringBuilder urlString = new StringBuilder();
        int retry = 1;
        int maxRetry = 1;
        String identityEndpoint = System.getenv("IDENTITY_ENDPOINT");
        if (null == identityEndpoint || identityEndpoint.trim().isEmpty()) {
            identityEndpoint = System.getenv("MSI_ENDPOINT");
        }
        if (null == (identityHeader = System.getenv("IDENTITY_HEADER")) || identityHeader.trim().isEmpty()) {
            identityHeader = System.getenv("MSI_SECRET");
        }
        boolean bl = isAzureFunction = null != identityEndpoint && !identityEndpoint.isEmpty() && null != identityHeader && !identityHeader.isEmpty();
        if (isAzureFunction) {
            urlString.append(identityEndpoint).append("?api-version=2019-08-01&resource=").append(resource);
        } else {
            urlString.append("http://169.254.169.254/metadata/identity/oauth2/token?api-version=2018-02-01").append("&resource=").append(resource);
            maxRetry = 20;
            for (int x = 0; x < maxRetry; ++x) {
                retrySlots.add(500 * ((2 << x) - 1) / 1000);
            }
        }
        if (null != msiClientId && !msiClientId.isEmpty()) {
            urlString.append("&client_id=").append(msiClientId);
        }
        while (retry <= maxRetry) {
            SqlFedAuthToken sqlFedAuthToken;
            HttpURLConnection connection;
            block32: {
                connection = null;
                connection = (HttpURLConnection)new URL(urlString.toString()).openConnection();
                connection.setRequestMethod("GET");
                if (isAzureFunction) {
                    connection.setRequestProperty("X-IDENTITY-HEADER", identityHeader);
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer("Using Azure Function/App Service Managed Identity auth: " + urlString);
                    }
                } else {
                    connection.setRequestProperty("Metadata", "true");
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer("Using Azure Managed Identity auth: " + urlString);
                    }
                }
                connection.connect();
                InputStream stream = connection.getInputStream();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8), 100);
                    StringBuilder result = new StringBuilder(reader.readLine());
                    int startIndex_AT = result.indexOf("\"access_token\":\"") + "\"access_token\":\"".length();
                    String accessToken = result.substring(startIndex_AT, result.indexOf("\"", startIndex_AT + 1));
                    Calendar cal = new Calendar.Builder().setInstant(new Date()).build();
                    int startIndex_ATX = result.indexOf("\"expires_in\":\"") + "\"expires_in\":\"".length();
                    String accessTokenExpiry = result.substring(startIndex_ATX, result.indexOf("\"", startIndex_ATX + 1));
                    cal.add(13, Integer.parseInt(accessTokenExpiry));
                    sqlFedAuthToken = new SqlFedAuthToken(accessToken, cal.getTime());
                    if (stream == null) break block32;
                }
                catch (Throwable reader) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable result) {
                                reader.addSuppressed(result);
                            }
                        }
                        throw reader;
                    }
                    catch (Exception e) {
                        if (++retry > maxRetry) {
                            if (connection == null) break;
                            connection.disconnect();
                            break;
                        }
                        try {
                            try {
                                int responseCode = connection.getResponseCode();
                                if (410 == responseCode || 429 == responseCode || 404 == responseCode || 500 <= responseCode && 599 >= responseCode) {
                                    try {
                                        int retryTimeoutInMs = (Integer)retrySlots.get(ThreadLocalRandom.current().nextInt(retry - 1));
                                        retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                                        Thread.sleep(retryTimeoutInMs);
                                        continue;
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        throw new RuntimeException(ex);
                                    }
                                }
                                if (null != msiClientId && !msiClientId.isEmpty()) {
                                    throw new SQLServerException(SQLServerException.getErrString("R_MSITokenFailureImdsClientId"), null);
                                }
                                throw new SQLServerException(SQLServerException.getErrString("R_MSITokenFailureImds"), null);
                            }
                            catch (IOException io) {
                                throw new SQLServerException(SQLServerException.getErrString("R_MSITokenFailureUnexpected"), null);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (connection == null) continue;
                            connection.disconnect();
                            continue;
                        }
                    }
                }
                stream.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
            return sqlFedAuthToken;
        }
        if (retry > maxRetry) {
            throw new SQLServerException(SQLServerException.getErrString(isAzureFunction ? "R_MSITokenFailureEndpoint" : "R_MSITokenFailureImds"), null);
        }
        return null;
    }
}

