/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.stepwiseplanner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class SystemStep {
    @Nullable
    private String thought;
    @Nullable
    private String action;
    @JsonProperty(value="action_variables")
    @Nullable
    private Map<String, String> actionVariables;
    @Nullable
    private String observation;
    @JsonProperty(value="final_answer")
    @Nullable
    private String finalAnswer;
    @JsonProperty(value="original_response")
    @Nullable
    private String originalResponse;

    public SystemStep() {
    }

    @JsonCreator
    public SystemStep(@JsonProperty(value="thought") @Nullable String thought, @JsonProperty(value="action") @Nullable String action, @JsonProperty(value="action_variables") @Nullable Map<String, String> actionVariables, @JsonProperty(value="observation") @Nullable String observation, @JsonProperty(value="final_answer") @Nullable String finalAnswer, @JsonProperty(value="original_response") @Nullable String originalResponse) {
        this.thought = thought;
        this.action = action;
        this.actionVariables = actionVariables == null ? null : Collections.unmodifiableMap(actionVariables);
        this.observation = observation;
        this.finalAnswer = finalAnswer;
        this.originalResponse = originalResponse;
    }

    @Nullable
    public String getThought() {
        return this.thought;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Nullable
    public Map<String, String> getActionVariables() {
        if (this.actionVariables == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.actionVariables);
    }

    @Nullable
    public String getObservation() {
        return this.observation;
    }

    @Nullable
    public String getFinalAnswer() {
        return this.finalAnswer;
    }

    @Nullable
    public String getOriginalResponse() {
        return this.originalResponse;
    }

    public void setThought(@Nullable String thought) {
        this.thought = thought;
    }

    public void setAction(@Nullable String action) {
        this.action = action;
    }

    public void setActionVariables(@Nullable Map<String, String> actionVariables) {
        this.actionVariables = actionVariables == null ? null : Collections.unmodifiableMap(actionVariables);
    }

    public void setFinalAnswer(@Nullable String finalAnswer) {
        this.finalAnswer = finalAnswer;
    }

    public void setObservation(@Nullable String observation) {
        this.observation = observation;
    }

    public void setOriginalResponse(@Nullable String originalResponse) {
        this.originalResponse = originalResponse;
    }
}

