/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.plugin.KernelPluginFactory;
import java.util.Objects;
import javax.annotation.Nullable;

public class OutputVariable<T> {
    @Nullable
    private final String description;
    private final String type;

    @JsonCreator
    public OutputVariable(@Nullable @JsonProperty(value="type", defaultValue="java.lang.String") String type, @Nullable @JsonProperty(value="description") String description) {
        this.description = description;
        if (type == null || type.isEmpty()) {
            type = "java.lang.String";
        }
        this.type = type;
    }

    public OutputVariable(@Nullable String description, Class<T> type) {
        this.description = description;
        this.type = type.getName();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Class<?> getType() {
        return KernelPluginFactory.getTypeForName(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        OutputVariable that = (OutputVariable)obj;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.description, that.description);
    }
}

