/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.DefaultPromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateFactory;
import com.microsoft.semantickernel.templateengine.handlebars.HandlebarsPromptTemplate;
import java.util.Locale;
import javax.annotation.Nonnull;

public class KernelPromptTemplateFactory
implements PromptTemplateFactory {
    @Override
    public PromptTemplate tryCreate(@Nonnull PromptTemplateConfig templateConfig) {
        if (templateConfig.getTemplate() == null) {
            throw new SKException(String.format("No prompt template was provided for the prompt %s.", templateConfig.getName()));
        }
        switch (templateConfig.getTemplateFormat().toLowerCase(Locale.ROOT)) {
            case "semantic-kernel": {
                return DefaultPromptTemplate.build(templateConfig);
            }
            case "handlebars": {
                return new HandlebarsPromptTemplate(templateConfig);
            }
        }
        throw new PromptTemplateFactory.UnknownTemplateFormatException(templateConfig.getTemplateFormat());
    }
}

