/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.CodeRendering;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.FunctionIdBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.NamedArgBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.VarBlock;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionMetadata;
import com.microsoft.semantickernel.templateengine.semantickernel.TemplateException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class CodeBlock
extends Block
implements CodeRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeBlock.class);
    private final List<Block> tokens;

    public CodeBlock(List<Block> tokens, String content) {
        super(content, BlockTypes.CODE);
        this.tokens = Collections.unmodifiableList(tokens);
    }

    @Override
    public boolean isValid() {
        Optional<Block> invalid = this.tokens.stream().filter(token -> !token.isValid()).findFirst();
        if (invalid.isPresent()) {
            LOGGER.error("Invalid block" + invalid.get().getContent());
            return false;
        }
        if (!this.tokens.isEmpty() && this.tokens.get(0).getType() == BlockTypes.NAMED_ARG) {
            LOGGER.error("Unexpected named argument found. Expected function name first.");
            return false;
        }
        return this.tokens.size() <= 1 || this.isValidFunctionCall();
    }

    private boolean isValidFunctionCall() {
        if (this.tokens.get(0).getType() != BlockTypes.FUNCTION_ID) {
            LOGGER.error("Unexpected second token found: " + this.tokens.get(1).getContent());
            return false;
        }
        if (this.tokens.get(1).getType() != BlockTypes.VALUE && this.tokens.get(1).getType() != BlockTypes.VARIABLE && this.tokens.get(1).getType() != BlockTypes.NAMED_ARG) {
            LOGGER.error("The first arg of a function must be a quoted string, variable or named argument");
            return false;
        }
        for (int i = 2; i < this.tokens.size(); ++i) {
            if (this.tokens.get(i).getType() == BlockTypes.NAMED_ARG) continue;
            LOGGER.error("Functions only support named arguments after the first argument. Argument " + i + " is not named.");
            return false;
        }
        return true;
    }

    @Override
    public Mono<String> renderCodeAsync(Kernel kernel, @Nullable KernelFunctionArguments arguments, @Nullable InvocationContext context) {
        if (!this.isValid()) {
            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR);
        }
        if (context == null) {
            context = InvocationContext.builder().build();
        }
        switch (this.tokens.get(0).getType()) {
            case VALUE: 
            case VARIABLE: {
                return Mono.just((Object)((TextRendering)((Object)this.tokens.get(0))).render(context.getContextVariableTypes(), arguments));
            }
            case FUNCTION_ID: {
                return this.renderFunctionCallAsync((FunctionIdBlock)this.tokens.get(0), kernel, arguments, context, context.getContextVariableTypes().getVariableTypeForClass(String.class)).map(ContextVariable::getValue).map(StringEscapeUtils::escapeXml11);
            }
        }
        throw new RuntimeException("Unknown type");
    }

    private <T> Mono<ContextVariable<T>> renderFunctionCallAsync(FunctionIdBlock fBlock, Kernel kernel, @Nullable KernelFunctionArguments arguments, InvocationContext context, ContextVariableType<T> resultType) {
        if (this.tokens.size() > 1) {
            arguments = this.enrichFunctionArguments(kernel, fBlock, KernelFunctionArguments.builder().withVariables(arguments).build(), context);
        }
        return kernel.invokeAsync(fBlock.getPluginName(), fBlock.getFunctionName()).withArguments(arguments).withResultType(resultType).map(FunctionResult::getResultVariable);
    }

    private KernelFunctionArguments enrichFunctionArguments(Kernel kernel, FunctionIdBlock fBlock, KernelFunctionArguments arguments, @Nullable InvocationContext context) {
        Object arg;
        Block firstArg = this.tokens.get(1);
        ContextVariableTypes types = context == null ? new ContextVariableTypes() : context.getContextVariableTypes();
        KernelFunctionMetadata<?> functionMetadata = kernel.getFunction(fBlock.getPluginName(), fBlock.getFunctionName()).getMetadata();
        if (functionMetadata.getParameters().isEmpty()) {
            throw new SKException("Function " + fBlock.getPluginName() + "." + fBlock.getFunctionName() + " does not take any arguments but it is being called in the template with {this._tokens.Count - 1} arguments.");
        }
        String firstPositionalParameterName = null;
        ContextVariable<?> firstPositionalInputValue = null;
        int namedArgsStartIndex = 1;
        if (firstArg.getType() != BlockTypes.NAMED_ARG) {
            String contextVariableName = firstPositionalParameterName = functionMetadata.getParameters().get(0).getName();
            if (firstArg instanceof VarBlock) {
                contextVariableName = ((VarBlock)firstArg).getName();
            }
            arg = arguments.get(contextVariableName);
            Class<?> desiredType = functionMetadata.getParameters().get(0).getTypeClass();
            if (arg != null) {
                try {
                    firstPositionalInputValue = ContextVariable.convert(arg, desiredType, types);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (firstPositionalInputValue == null) {
                firstPositionalInputValue = ((TextRendering)((Object)this.tokens.get(1))).render(types, arguments);
                firstPositionalInputValue = ContextVariable.convert(firstPositionalInputValue, functionMetadata.getParameters().get(0).getTypeClass(), types);
            }
            if (firstPositionalInputValue == null) {
                throw new SKException("Unexpected null value for first positional argument: " + this.tokens.get(1).getContent());
            }
            arguments.put(firstPositionalParameterName, types.contextVariableOf(firstPositionalInputValue));
            ++namedArgsStartIndex;
        }
        for (int i = namedArgsStartIndex; i < this.tokens.size(); ++i) {
            if (!(this.tokens.get(i) instanceof NamedArgBlock)) {
                throw new SKException("Unexpected first token type: {this._tokens[i].Type:G}");
            }
            arg = (NamedArgBlock)this.tokens.get(i);
            if (firstPositionalParameterName != null && firstPositionalParameterName.equalsIgnoreCase(((NamedArgBlock)arg).getName())) {
                throw new SKException("Ambiguity found as a named parameter '{arg.Name}' cannot be set for the first parameter when there is also a positional value: '{firstPositionalInputValue}' provided. Function: {fBlock.PluginName}.{fBlock.FunctionName}");
            }
            arguments.put(((NamedArgBlock)arg).getName(), types.contextVariableOf(((NamedArgBlock)arg).getValue(types, arguments)));
        }
        return arguments;
    }
}

