/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.ai.embeddings;

import com.microsoft.semantickernel.ai.embeddings.VectorOperations;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Embedding {
    private final List<Float> vector;
    private static final Embedding EMPTY = new Embedding();

    public static Embedding empty() {
        return EMPTY;
    }

    public Embedding() {
        this.vector = Collections.emptyList();
    }

    public Embedding(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        this.vector = Collections.unmodifiableList(vector);
    }

    public List<Float> getVector() {
        return this.vector;
    }

    public float dot(@Nonnull Embedding other) {
        Objects.requireNonNull(other);
        return VectorOperations.dot(this.vector, other.getVector());
    }

    public float euclideanLength() {
        return VectorOperations.euclideanLength(this.vector);
    }

    public float cosineSimilarity(@Nonnull Embedding other) {
        Objects.requireNonNull(other);
        return VectorOperations.cosineSimilarity(this.vector, other.getVector());
    }

    public Embedding multiply(float multiplier) {
        return new Embedding(VectorOperations.multiply(this.vector, multiplier));
    }

    public Embedding divide(float divisor) {
        return new Embedding(VectorOperations.divide(this.vector, divisor));
    }

    public Embedding normalize() {
        return new Embedding(VectorOperations.normalize(this.vector));
    }
}

