/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel;

import com.microsoft.semantickernel.KernelConfig;
import com.microsoft.semantickernel.KernelException;
import com.microsoft.semantickernel.SkillExecutor;
import com.microsoft.semantickernel.ai.embeddings.TextEmbeddingGeneration;
import com.microsoft.semantickernel.builders.Buildable;
import com.microsoft.semantickernel.builders.BuildersSingleton;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.memory.MemoryStore;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.semanticfunctions.SemanticFunctionConfig;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public interface Kernel
extends SkillExecutor,
Buildable {
    public KernelConfig getConfig();

    public PromptTemplateEngine getPromptTemplateEngine();

    public SemanticTextMemory getMemory();

    public Mono<SKContext> runAsync(SKFunction<?> ... var1);

    public Mono<SKContext> runAsync(String var1, SKFunction<?> ... var2);

    public Mono<SKContext> runAsync(ContextVariables var1, SKFunction<?> ... var2);

    public CompletionSKFunction registerSemanticFunction(String var1, String var2, SemanticFunctionConfig var3);

    public CompletionSKFunction.Builder getSemanticFunctionBuilder();

    public <T extends AIService> T getService(@Nullable String var1, Class<T> var2) throws KernelException;

    public <RequestConfiguration, FunctionType extends SKFunction<RequestConfiguration>> FunctionType registerSemanticFunction(FunctionType var1);

    public SKFunction getFunction(String var1, String var2);

    public static Builder builder() {
        return BuildersSingleton.INST.getInstance(Builder.class);
    }

    public static interface Builder
    extends SemanticKernelBuilder<Kernel> {
        public Builder withConfiguration(KernelConfig var1);

        public Builder withPromptTemplateEngine(PromptTemplateEngine var1);

        public Builder withMemoryStorage(MemoryStore var1);

        public Builder withMemoryStorage(Supplier<MemoryStore> var1);

        public <T extends AIService> Builder withDefaultAIService(T var1);

        public <T extends AIService> Builder withDefaultAIService(T var1, Class<T> var2);

        public <T extends AIService> Builder withDefaultAIService(Supplier<T> var1, Class<T> var2);

        public <T extends AIService> Builder withAIService(@Nullable String var1, T var2, boolean var3, Class<T> var4);

        public <T extends AIService> Builder withAIServiceFactory(@Nullable String var1, Function<KernelConfig, T> var2, boolean var3, Class<T> var4);

        public Builder withMemory(SemanticTextMemory var1);

        public Builder withMemoryStorageAndTextEmbeddingGeneration(MemoryStore var1, TextEmbeddingGeneration var2);
    }
}

