/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpMethod;
import com.microsoft.rest.v2.protocol.HttpResponseDecoder;
import io.reactivex.Flowable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class HttpRequest {
    private String callerMethod;
    private HttpMethod httpMethod;
    private URL url;
    private HttpHeaders headers;
    private Flowable<ByteBuffer> body;
    private Context context;
    private final HttpResponseDecoder responseDecoder;

    public HttpRequest(String callerMethod, HttpMethod httpMethod, URL url, HttpResponseDecoder responseDecoder) {
        this.callerMethod = callerMethod;
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = new HttpHeaders();
        this.body = null;
        this.responseDecoder = responseDecoder;
    }

    public HttpRequest(String callerMethod, HttpMethod httpMethod, URL url, HttpHeaders headers, Flowable<ByteBuffer> body, HttpResponseDecoder responseDecoder) {
        this.callerMethod = callerMethod;
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.responseDecoder = responseDecoder;
    }

    public String callerMethod() {
        return this.callerMethod;
    }

    public HttpRequest withCallerMethod(String callerMethod) {
        this.callerMethod = callerMethod;
        return this;
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public HttpRequest withHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URL url() {
        return this.url;
    }

    public HttpRequest withUrl(URL url) {
        this.url = url;
        return this;
    }

    public HttpResponseDecoder responseDecoder() {
        return this.responseDecoder;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpRequest withHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest withHeader(String headerName, String headerValue) {
        this.headers.set(headerName, headerValue);
        return this;
    }

    public Flowable<ByteBuffer> body() {
        return this.body;
    }

    public HttpRequest withBody(String body) {
        byte[] bodyBytes = body.getBytes(StandardCharsets.UTF_8);
        return this.withBody(bodyBytes);
    }

    public HttpRequest withBody(byte[] body) {
        this.headers.set("Content-Length", String.valueOf(body.length));
        return this.withBody((Flowable<ByteBuffer>)Flowable.just((Object)ByteBuffer.wrap(body)));
    }

    public HttpRequest withBody(Flowable<ByteBuffer> body) {
        this.body = body;
        return this;
    }

    public Context context() {
        return this.context;
    }

    public HttpRequest withContext(Context context) {
        this.context = context;
        return this;
    }

    public HttpRequest buffer() {
        HttpHeaders bufferedHeaders = new HttpHeaders(this.headers);
        return new HttpRequest(this.callerMethod, this.httpMethod, this.url, bufferedHeaders, this.body, this.responseDecoder);
    }
}

