/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.concurrent.TimeUnit;

public class RetryPolicyFactory
implements RequestPolicyFactory {
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_DELAY = 0;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final int maxRetries;
    private final long delayTime;
    private final TimeUnit timeUnit;

    public RetryPolicyFactory() {
        this.maxRetries = 3;
        this.delayTime = 0L;
        this.timeUnit = DEFAULT_TIME_UNIT;
    }

    public RetryPolicyFactory(int maxRetries, long delayTime, TimeUnit timeUnit) {
        this.maxRetries = maxRetries;
        this.delayTime = delayTime;
        this.timeUnit = timeUnit;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new RetryPolicy(next);
    }

    private final class RetryPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private RetryPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            return this.attemptAsync(request, 0);
        }

        private Single<HttpResponse> attemptAsync(HttpRequest request, int tryCount) {
            return this.next.sendAsync(request.buffer()).flatMap(httpResponse -> {
                if (this.shouldRetry((HttpResponse)httpResponse, tryCount)) {
                    return this.attemptAsync(request, tryCount + 1).delaySubscription(RetryPolicyFactory.this.delayTime, RetryPolicyFactory.this.timeUnit);
                }
                return Single.just((Object)httpResponse);
            }).onErrorResumeNext(err -> tryCount < RetryPolicyFactory.this.maxRetries ? this.attemptAsync(request, tryCount + 1).delaySubscription(RetryPolicyFactory.this.delayTime, RetryPolicyFactory.this.timeUnit) : Single.error((Throwable)err));
        }

        private boolean shouldRetry(HttpResponse response, int tryCount) {
            int code = response.statusCode();
            return tryCount < RetryPolicyFactory.this.maxRetries && (code == 408 || code >= 500 && code != 501 && code != 505);
        }
    }
}

