/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.AbstractRequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.net.MalformedURLException;

public class HostPolicyFactory
implements RequestPolicyFactory {
    private final String host;

    public HostPolicyFactory(String host) {
        this.host = host;
    }

    @Override
    public HostPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new HostPolicy(next, options);
    }

    private final class HostPolicy
    extends AbstractRequestPolicy {
        private HostPolicy(RequestPolicy nextPolicy, RequestPolicyOptions options) {
            super(nextPolicy, options);
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            Single<HttpResponse> result;
            if (this.shouldLog(HttpPipelineLogLevel.INFO)) {
                this.log(HttpPipelineLogLevel.INFO, "Setting host to {0}", HostPolicyFactory.this.host);
            }
            UrlBuilder urlBuilder = UrlBuilder.parse(request.url());
            try {
                request.withUrl(urlBuilder.withHost(HostPolicyFactory.this.host).toURL());
                result = this.nextPolicy().sendAsync(request);
            }
            catch (MalformedURLException e) {
                result = Single.error((Throwable)e);
            }
            return result;
        }
    }
}

