"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.source = void 0;
const source = "\"use strict\";\nvar __create = Object.create;\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __getProtoOf = Object.getPrototypeOf;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __commonJS = (cb, mod) => function __require() {\n  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, \"default\", { value: mod, enumerable: true }) : target, mod));\n\n// packages/playwright-core/src/server/isomorphic/cssTokenizer.js\nvar require_cssTokenizer = __commonJS({\n  \"packages/playwright-core/src/server/isomorphic/cssTokenizer.js\"(exports2) {\n    \"use strict\";\n    var between = function(num, first, last) {\n      return num >= first && num <= last;\n    };\n    function digit(code) {\n      return between(code, 48, 57);\n    }\n    function hexdigit(code) {\n      return digit(code) || between(code, 65, 70) || between(code, 97, 102);\n    }\n    function uppercaseletter(code) {\n      return between(code, 65, 90);\n    }\n    function lowercaseletter(code) {\n      return between(code, 97, 122);\n    }\n    function letter(code) {\n      return uppercaseletter(code) || lowercaseletter(code);\n    }\n    function nonascii(code) {\n      return code >= 128;\n    }\n    function namestartchar(code) {\n      return letter(code) || nonascii(code) || code == 95;\n    }\n    function namechar(code) {\n      return namestartchar(code) || digit(code) || code == 45;\n    }\n    function nonprintable(code) {\n      return between(code, 0, 8) || code == 11 || between(code, 14, 31) || code == 127;\n    }\n    function newline(code) {\n      return code == 10;\n    }\n    function whitespace(code) {\n      return newline(code) || code == 9 || code == 32;\n    }\n    var maximumallowedcodepoint = 1114111;\n    var InvalidCharacterError = function(message) {\n      this.message = message;\n    };\n    InvalidCharacterError.prototype = new Error();\n    InvalidCharacterError.prototype.name = \"InvalidCharacterError\";\n    function preprocess(str) {\n      var codepoints = [];\n      for (var i = 0; i < str.length; i++) {\n        var code = str.charCodeAt(i);\n        if (code == 13 && str.charCodeAt(i + 1) == 10) {\n          code = 10;\n          i++;\n        }\n        if (code == 13 || code == 12)\n          code = 10;\n        if (code == 0)\n          code = 65533;\n        if (between(code, 55296, 56319) && between(str.charCodeAt(i + 1), 56320, 57343)) {\n          var lead = code - 55296;\n          var trail = str.charCodeAt(i + 1) - 56320;\n          code = Math.pow(2, 16) + lead * Math.pow(2, 10) + trail;\n          i++;\n        }\n        codepoints.push(code);\n      }\n      return codepoints;\n    }\n    function stringFromCode(code) {\n      if (code <= 65535)\n        return String.fromCharCode(code);\n      code -= Math.pow(2, 16);\n      var lead = Math.floor(code / Math.pow(2, 10)) + 55296;\n      var trail = code % Math.pow(2, 10) + 56320;\n      return String.fromCharCode(lead) + String.fromCharCode(trail);\n    }\n    function tokenize2(str) {\n      str = preprocess(str);\n      var i = -1;\n      var tokens = [];\n      var code;\n      var line = 0;\n      var column = 0;\n      var lastLineLength = 0;\n      var incrLineno = function() {\n        line += 1;\n        lastLineLength = column;\n        column = 0;\n      };\n      var locStart = { line, column };\n      var codepoint = function(i2) {\n        if (i2 >= str.length) {\n          return -1;\n        }\n        return str[i2];\n      };\n      var next = function(num) {\n        if (num === void 0)\n          num = 1;\n        if (num > 3)\n          throw \"Spec Error: no more than three codepoints of lookahead.\";\n        return codepoint(i + num);\n      };\n      var consume = function(num) {\n        if (num === void 0)\n          num = 1;\n        i += num;\n        code = codepoint(i);\n        if (newline(code))\n          incrLineno();\n        else\n          column += num;\n        return true;\n      };\n      var reconsume = function() {\n        i -= 1;\n        if (newline(code)) {\n          line -= 1;\n          column = lastLineLength;\n        } else {\n          column -= 1;\n        }\n        locStart.line = line;\n        locStart.column = column;\n        return true;\n      };\n      var eof = function(codepoint2) {\n        if (codepoint2 === void 0)\n          codepoint2 = code;\n        return codepoint2 == -1;\n      };\n      var donothing = function() {\n      };\n      var parseerror = function() {\n        console.log(\"Parse error at index \" + i + \", processing codepoint 0x\" + code.toString(16) + \".\");\n        return true;\n      };\n      var consumeAToken = function() {\n        consumeComments();\n        consume();\n        if (whitespace(code)) {\n          while (whitespace(next()))\n            consume();\n          return new WhitespaceToken2();\n        } else if (code == 34)\n          return consumeAStringToken();\n        else if (code == 35) {\n          if (namechar(next()) || areAValidEscape(next(1), next(2))) {\n            var token = new HashToken2();\n            if (wouldStartAnIdentifier(next(1), next(2), next(3)))\n              token.type = \"id\";\n            token.value = consumeAName();\n            return token;\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 36) {\n          if (next() == 61) {\n            consume();\n            return new SuffixMatchToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 39)\n          return consumeAStringToken();\n        else if (code == 40)\n          return new OpenParenToken();\n        else if (code == 41)\n          return new CloseParenToken2();\n        else if (code == 42) {\n          if (next() == 61) {\n            consume();\n            return new SubstringMatchToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 43) {\n          if (startsWithANumber()) {\n            reconsume();\n            return consumeANumericToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 44)\n          return new CommaToken2();\n        else if (code == 45) {\n          if (startsWithANumber()) {\n            reconsume();\n            return consumeANumericToken();\n          } else if (next(1) == 45 && next(2) == 62) {\n            consume(2);\n            return new CDCToken2();\n          } else if (startsWithAnIdentifier()) {\n            reconsume();\n            return consumeAnIdentlikeToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 46) {\n          if (startsWithANumber()) {\n            reconsume();\n            return consumeANumericToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 58)\n          return new ColonToken2();\n        else if (code == 59)\n          return new SemicolonToken2();\n        else if (code == 60) {\n          if (next(1) == 33 && next(2) == 45 && next(3) == 45) {\n            consume(3);\n            return new CDOToken2();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 64) {\n          if (wouldStartAnIdentifier(next(1), next(2), next(3))) {\n            return new AtKeywordToken2(consumeAName());\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 91)\n          return new OpenSquareToken2();\n        else if (code == 92) {\n          if (startsWithAValidEscape()) {\n            reconsume();\n            return consumeAnIdentlikeToken();\n          } else {\n            parseerror();\n            return new DelimToken2(code);\n          }\n        } else if (code == 93)\n          return new CloseSquareToken2();\n        else if (code == 94) {\n          if (next() == 61) {\n            consume();\n            return new PrefixMatchToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 123)\n          return new OpenCurlyToken2();\n        else if (code == 124) {\n          if (next() == 61) {\n            consume();\n            return new DashMatchToken();\n          } else if (next() == 124) {\n            consume();\n            return new ColumnToken2();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (code == 125)\n          return new CloseCurlyToken2();\n        else if (code == 126) {\n          if (next() == 61) {\n            consume();\n            return new IncludeMatchToken();\n          } else {\n            return new DelimToken2(code);\n          }\n        } else if (digit(code)) {\n          reconsume();\n          return consumeANumericToken();\n        } else if (namestartchar(code)) {\n          reconsume();\n          return consumeAnIdentlikeToken();\n        } else if (eof())\n          return new EOFToken2();\n        else\n          return new DelimToken2(code);\n      };\n      var consumeComments = function() {\n        while (next(1) == 47 && next(2) == 42) {\n          consume(2);\n          while (true) {\n            consume();\n            if (code == 42 && next() == 47) {\n              consume();\n              break;\n            } else if (eof()) {\n              parseerror();\n              return;\n            }\n          }\n        }\n      };\n      var consumeANumericToken = function() {\n        var num = consumeANumber();\n        if (wouldStartAnIdentifier(next(1), next(2), next(3))) {\n          var token = new DimensionToken();\n          token.value = num.value;\n          token.repr = num.repr;\n          token.type = num.type;\n          token.unit = consumeAName();\n          return token;\n        } else if (next() == 37) {\n          consume();\n          var token = new PercentageToken2();\n          token.value = num.value;\n          token.repr = num.repr;\n          return token;\n        } else {\n          var token = new NumberToken2();\n          token.value = num.value;\n          token.repr = num.repr;\n          token.type = num.type;\n          return token;\n        }\n      };\n      var consumeAnIdentlikeToken = function() {\n        var str2 = consumeAName();\n        if (str2.toLowerCase() == \"url\" && next() == 40) {\n          consume();\n          while (whitespace(next(1)) && whitespace(next(2)))\n            consume();\n          if (next() == 34 || next() == 39) {\n            return new FunctionToken2(str2);\n          } else if (whitespace(next()) && (next(2) == 34 || next(2) == 39)) {\n            return new FunctionToken2(str2);\n          } else {\n            return consumeAURLToken();\n          }\n        } else if (next() == 40) {\n          consume();\n          return new FunctionToken2(str2);\n        } else {\n          return new IdentToken2(str2);\n        }\n      };\n      var consumeAStringToken = function(endingCodePoint) {\n        if (endingCodePoint === void 0)\n          endingCodePoint = code;\n        var string = \"\";\n        while (consume()) {\n          if (code == endingCodePoint || eof()) {\n            return new StringToken2(string);\n          } else if (newline(code)) {\n            parseerror();\n            reconsume();\n            return new BadStringToken2();\n          } else if (code == 92) {\n            if (eof(next())) {\n              donothing();\n            } else if (newline(next())) {\n              consume();\n            } else {\n              string += stringFromCode(consumeEscape());\n            }\n          } else {\n            string += stringFromCode(code);\n          }\n        }\n      };\n      var consumeAURLToken = function() {\n        var token = new URLToken2(\"\");\n        while (whitespace(next()))\n          consume();\n        if (eof(next()))\n          return token;\n        while (consume()) {\n          if (code == 41 || eof()) {\n            return token;\n          } else if (whitespace(code)) {\n            while (whitespace(next()))\n              consume();\n            if (next() == 41 || eof(next())) {\n              consume();\n              return token;\n            } else {\n              consumeTheRemnantsOfABadURL();\n              return new BadURLToken2();\n            }\n          } else if (code == 34 || code == 39 || code == 40 || nonprintable(code)) {\n            parseerror();\n            consumeTheRemnantsOfABadURL();\n            return new BadURLToken2();\n          } else if (code == 92) {\n            if (startsWithAValidEscape()) {\n              token.value += stringFromCode(consumeEscape());\n            } else {\n              parseerror();\n              consumeTheRemnantsOfABadURL();\n              return new BadURLToken2();\n            }\n          } else {\n            token.value += stringFromCode(code);\n          }\n        }\n      };\n      var consumeEscape = function() {\n        consume();\n        if (hexdigit(code)) {\n          var digits = [code];\n          for (var total = 0; total < 5; total++) {\n            if (hexdigit(next())) {\n              consume();\n              digits.push(code);\n            } else {\n              break;\n            }\n          }\n          if (whitespace(next()))\n            consume();\n          var value = parseInt(digits.map(function(x) {\n            return String.fromCharCode(x);\n          }).join(\"\"), 16);\n          if (value > maximumallowedcodepoint)\n            value = 65533;\n          return value;\n        } else if (eof()) {\n          return 65533;\n        } else {\n          return code;\n        }\n      };\n      var areAValidEscape = function(c1, c2) {\n        if (c1 != 92)\n          return false;\n        if (newline(c2))\n          return false;\n        return true;\n      };\n      var startsWithAValidEscape = function() {\n        return areAValidEscape(code, next());\n      };\n      var wouldStartAnIdentifier = function(c1, c2, c3) {\n        if (c1 == 45) {\n          return namestartchar(c2) || c2 == 45 || areAValidEscape(c2, c3);\n        } else if (namestartchar(c1)) {\n          return true;\n        } else if (c1 == 92) {\n          return areAValidEscape(c1, c2);\n        } else {\n          return false;\n        }\n      };\n      var startsWithAnIdentifier = function() {\n        return wouldStartAnIdentifier(code, next(1), next(2));\n      };\n      var wouldStartANumber = function(c1, c2, c3) {\n        if (c1 == 43 || c1 == 45) {\n          if (digit(c2))\n            return true;\n          if (c2 == 46 && digit(c3))\n            return true;\n          return false;\n        } else if (c1 == 46) {\n          if (digit(c2))\n            return true;\n          return false;\n        } else if (digit(c1)) {\n          return true;\n        } else {\n          return false;\n        }\n      };\n      var startsWithANumber = function() {\n        return wouldStartANumber(code, next(1), next(2));\n      };\n      var consumeAName = function() {\n        var result = \"\";\n        while (consume()) {\n          if (namechar(code)) {\n            result += stringFromCode(code);\n          } else if (startsWithAValidEscape()) {\n            result += stringFromCode(consumeEscape());\n          } else {\n            reconsume();\n            return result;\n          }\n        }\n      };\n      var consumeANumber = function() {\n        var repr = [];\n        var type = \"integer\";\n        if (next() == 43 || next() == 45) {\n          consume();\n          repr += stringFromCode(code);\n        }\n        while (digit(next())) {\n          consume();\n          repr += stringFromCode(code);\n        }\n        if (next(1) == 46 && digit(next(2))) {\n          consume();\n          repr += stringFromCode(code);\n          consume();\n          repr += stringFromCode(code);\n          type = \"number\";\n          while (digit(next())) {\n            consume();\n            repr += stringFromCode(code);\n          }\n        }\n        var c1 = next(1), c2 = next(2), c3 = next(3);\n        if ((c1 == 69 || c1 == 101) && digit(c2)) {\n          consume();\n          repr += stringFromCode(code);\n          consume();\n          repr += stringFromCode(code);\n          type = \"number\";\n          while (digit(next())) {\n            consume();\n            repr += stringFromCode(code);\n          }\n        } else if ((c1 == 69 || c1 == 101) && (c2 == 43 || c2 == 45) && digit(c3)) {\n          consume();\n          repr += stringFromCode(code);\n          consume();\n          repr += stringFromCode(code);\n          consume();\n          repr += stringFromCode(code);\n          type = \"number\";\n          while (digit(next())) {\n            consume();\n            repr += stringFromCode(code);\n          }\n        }\n        var value = convertAStringToANumber(repr);\n        return { type, value, repr };\n      };\n      var convertAStringToANumber = function(string) {\n        return +string;\n      };\n      var consumeTheRemnantsOfABadURL = function() {\n        while (consume()) {\n          if (code == 41 || eof()) {\n            return;\n          } else if (startsWithAValidEscape()) {\n            consumeEscape();\n            donothing();\n          } else {\n            donothing();\n          }\n        }\n      };\n      var iterationCount = 0;\n      while (!eof(next())) {\n        tokens.push(consumeAToken());\n        iterationCount++;\n        if (iterationCount > str.length * 2)\n          return \"I'm infinite-looping!\";\n      }\n      return tokens;\n    }\n    function CSSParserToken() {\n      throw \"Abstract Base Class\";\n    }\n    CSSParserToken.prototype.toJSON = function() {\n      return { token: this.tokenType };\n    };\n    CSSParserToken.prototype.toString = function() {\n      return this.tokenType;\n    };\n    CSSParserToken.prototype.toSource = function() {\n      return \"\" + this;\n    };\n    function BadStringToken2() {\n      return this;\n    }\n    BadStringToken2.prototype = Object.create(CSSParserToken.prototype);\n    BadStringToken2.prototype.tokenType = \"BADSTRING\";\n    function BadURLToken2() {\n      return this;\n    }\n    BadURLToken2.prototype = Object.create(CSSParserToken.prototype);\n    BadURLToken2.prototype.tokenType = \"BADURL\";\n    function WhitespaceToken2() {\n      return this;\n    }\n    WhitespaceToken2.prototype = Object.create(CSSParserToken.prototype);\n    WhitespaceToken2.prototype.tokenType = \"WHITESPACE\";\n    WhitespaceToken2.prototype.toString = function() {\n      return \"WS\";\n    };\n    WhitespaceToken2.prototype.toSource = function() {\n      return \" \";\n    };\n    function CDOToken2() {\n      return this;\n    }\n    CDOToken2.prototype = Object.create(CSSParserToken.prototype);\n    CDOToken2.prototype.tokenType = \"CDO\";\n    CDOToken2.prototype.toSource = function() {\n      return \"<!--\";\n    };\n    function CDCToken2() {\n      return this;\n    }\n    CDCToken2.prototype = Object.create(CSSParserToken.prototype);\n    CDCToken2.prototype.tokenType = \"CDC\";\n    CDCToken2.prototype.toSource = function() {\n      return \"-->\";\n    };\n    function ColonToken2() {\n      return this;\n    }\n    ColonToken2.prototype = Object.create(CSSParserToken.prototype);\n    ColonToken2.prototype.tokenType = \":\";\n    function SemicolonToken2() {\n      return this;\n    }\n    SemicolonToken2.prototype = Object.create(CSSParserToken.prototype);\n    SemicolonToken2.prototype.tokenType = \";\";\n    function CommaToken2() {\n      return this;\n    }\n    CommaToken2.prototype = Object.create(CSSParserToken.prototype);\n    CommaToken2.prototype.tokenType = \",\";\n    function GroupingToken() {\n      throw \"Abstract Base Class\";\n    }\n    GroupingToken.prototype = Object.create(CSSParserToken.prototype);\n    function OpenCurlyToken2() {\n      this.value = \"{\";\n      this.mirror = \"}\";\n      return this;\n    }\n    OpenCurlyToken2.prototype = Object.create(GroupingToken.prototype);\n    OpenCurlyToken2.prototype.tokenType = \"{\";\n    function CloseCurlyToken2() {\n      this.value = \"}\";\n      this.mirror = \"{\";\n      return this;\n    }\n    CloseCurlyToken2.prototype = Object.create(GroupingToken.prototype);\n    CloseCurlyToken2.prototype.tokenType = \"}\";\n    function OpenSquareToken2() {\n      this.value = \"[\";\n      this.mirror = \"]\";\n      return this;\n    }\n    OpenSquareToken2.prototype = Object.create(GroupingToken.prototype);\n    OpenSquareToken2.prototype.tokenType = \"[\";\n    function CloseSquareToken2() {\n      this.value = \"]\";\n      this.mirror = \"[\";\n      return this;\n    }\n    CloseSquareToken2.prototype = Object.create(GroupingToken.prototype);\n    CloseSquareToken2.prototype.tokenType = \"]\";\n    function OpenParenToken() {\n      this.value = \"(\";\n      this.mirror = \")\";\n      return this;\n    }\n    OpenParenToken.prototype = Object.create(GroupingToken.prototype);\n    OpenParenToken.prototype.tokenType = \"(\";\n    function CloseParenToken2() {\n      this.value = \")\";\n      this.mirror = \"(\";\n      return this;\n    }\n    CloseParenToken2.prototype = Object.create(GroupingToken.prototype);\n    CloseParenToken2.prototype.tokenType = \")\";\n    function IncludeMatchToken() {\n      return this;\n    }\n    IncludeMatchToken.prototype = Object.create(CSSParserToken.prototype);\n    IncludeMatchToken.prototype.tokenType = \"~=\";\n    function DashMatchToken() {\n      return this;\n    }\n    DashMatchToken.prototype = Object.create(CSSParserToken.prototype);\n    DashMatchToken.prototype.tokenType = \"|=\";\n    function PrefixMatchToken() {\n      return this;\n    }\n    PrefixMatchToken.prototype = Object.create(CSSParserToken.prototype);\n    PrefixMatchToken.prototype.tokenType = \"^=\";\n    function SuffixMatchToken() {\n      return this;\n    }\n    SuffixMatchToken.prototype = Object.create(CSSParserToken.prototype);\n    SuffixMatchToken.prototype.tokenType = \"$=\";\n    function SubstringMatchToken() {\n      return this;\n    }\n    SubstringMatchToken.prototype = Object.create(CSSParserToken.prototype);\n    SubstringMatchToken.prototype.tokenType = \"*=\";\n    function ColumnToken2() {\n      return this;\n    }\n    ColumnToken2.prototype = Object.create(CSSParserToken.prototype);\n    ColumnToken2.prototype.tokenType = \"||\";\n    function EOFToken2() {\n      return this;\n    }\n    EOFToken2.prototype = Object.create(CSSParserToken.prototype);\n    EOFToken2.prototype.tokenType = \"EOF\";\n    EOFToken2.prototype.toSource = function() {\n      return \"\";\n    };\n    function DelimToken2(code) {\n      this.value = stringFromCode(code);\n      return this;\n    }\n    DelimToken2.prototype = Object.create(CSSParserToken.prototype);\n    DelimToken2.prototype.tokenType = \"DELIM\";\n    DelimToken2.prototype.toString = function() {\n      return \"DELIM(\" + this.value + \")\";\n    };\n    DelimToken2.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      return json;\n    };\n    DelimToken2.prototype.toSource = function() {\n      if (this.value == \"\\\\\")\n        return \"\\\\\\n\";\n      else\n        return this.value;\n    };\n    function StringValuedToken() {\n      throw \"Abstract Base Class\";\n    }\n    StringValuedToken.prototype = Object.create(CSSParserToken.prototype);\n    StringValuedToken.prototype.ASCIIMatch = function(str) {\n      return this.value.toLowerCase() == str.toLowerCase();\n    };\n    StringValuedToken.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      return json;\n    };\n    function IdentToken2(val) {\n      this.value = val;\n    }\n    IdentToken2.prototype = Object.create(StringValuedToken.prototype);\n    IdentToken2.prototype.tokenType = \"IDENT\";\n    IdentToken2.prototype.toString = function() {\n      return \"IDENT(\" + this.value + \")\";\n    };\n    IdentToken2.prototype.toSource = function() {\n      return escapeIdent(this.value);\n    };\n    function FunctionToken2(val) {\n      this.value = val;\n      this.mirror = \")\";\n    }\n    FunctionToken2.prototype = Object.create(StringValuedToken.prototype);\n    FunctionToken2.prototype.tokenType = \"FUNCTION\";\n    FunctionToken2.prototype.toString = function() {\n      return \"FUNCTION(\" + this.value + \")\";\n    };\n    FunctionToken2.prototype.toSource = function() {\n      return escapeIdent(this.value) + \"(\";\n    };\n    function AtKeywordToken2(val) {\n      this.value = val;\n    }\n    AtKeywordToken2.prototype = Object.create(StringValuedToken.prototype);\n    AtKeywordToken2.prototype.tokenType = \"AT-KEYWORD\";\n    AtKeywordToken2.prototype.toString = function() {\n      return \"AT(\" + this.value + \")\";\n    };\n    AtKeywordToken2.prototype.toSource = function() {\n      return \"@\" + escapeIdent(this.value);\n    };\n    function HashToken2(val) {\n      this.value = val;\n      this.type = \"unrestricted\";\n    }\n    HashToken2.prototype = Object.create(StringValuedToken.prototype);\n    HashToken2.prototype.tokenType = \"HASH\";\n    HashToken2.prototype.toString = function() {\n      return \"HASH(\" + this.value + \")\";\n    };\n    HashToken2.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      json.type = this.type;\n      return json;\n    };\n    HashToken2.prototype.toSource = function() {\n      if (this.type == \"id\") {\n        return \"#\" + escapeIdent(this.value);\n      } else {\n        return \"#\" + escapeHash(this.value);\n      }\n    };\n    function StringToken2(val) {\n      this.value = val;\n    }\n    StringToken2.prototype = Object.create(StringValuedToken.prototype);\n    StringToken2.prototype.tokenType = \"STRING\";\n    StringToken2.prototype.toString = function() {\n      return '\"' + escapeString(this.value) + '\"';\n    };\n    function URLToken2(val) {\n      this.value = val;\n    }\n    URLToken2.prototype = Object.create(StringValuedToken.prototype);\n    URLToken2.prototype.tokenType = \"URL\";\n    URLToken2.prototype.toString = function() {\n      return \"URL(\" + this.value + \")\";\n    };\n    URLToken2.prototype.toSource = function() {\n      return 'url(\"' + escapeString(this.value) + '\")';\n    };\n    function NumberToken2() {\n      this.value = null;\n      this.type = \"integer\";\n      this.repr = \"\";\n    }\n    NumberToken2.prototype = Object.create(CSSParserToken.prototype);\n    NumberToken2.prototype.tokenType = \"NUMBER\";\n    NumberToken2.prototype.toString = function() {\n      if (this.type == \"integer\")\n        return \"INT(\" + this.value + \")\";\n      return \"NUMBER(\" + this.value + \")\";\n    };\n    NumberToken2.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      json.type = this.type;\n      json.repr = this.repr;\n      return json;\n    };\n    NumberToken2.prototype.toSource = function() {\n      return this.repr;\n    };\n    function PercentageToken2() {\n      this.value = null;\n      this.repr = \"\";\n    }\n    PercentageToken2.prototype = Object.create(CSSParserToken.prototype);\n    PercentageToken2.prototype.tokenType = \"PERCENTAGE\";\n    PercentageToken2.prototype.toString = function() {\n      return \"PERCENTAGE(\" + this.value + \")\";\n    };\n    PercentageToken2.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      json.repr = this.repr;\n      return json;\n    };\n    PercentageToken2.prototype.toSource = function() {\n      return this.repr + \"%\";\n    };\n    function DimensionToken() {\n      this.value = null;\n      this.type = \"integer\";\n      this.repr = \"\";\n      this.unit = \"\";\n    }\n    DimensionToken.prototype = Object.create(CSSParserToken.prototype);\n    DimensionToken.prototype.tokenType = \"DIMENSION\";\n    DimensionToken.prototype.toString = function() {\n      return \"DIM(\" + this.value + \",\" + this.unit + \")\";\n    };\n    DimensionToken.prototype.toJSON = function() {\n      var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n      json.value = this.value;\n      json.type = this.type;\n      json.repr = this.repr;\n      json.unit = this.unit;\n      return json;\n    };\n    DimensionToken.prototype.toSource = function() {\n      var source = this.repr;\n      var unit = escapeIdent(this.unit);\n      if (unit[0].toLowerCase() == \"e\" && (unit[1] == \"-\" || between(unit.charCodeAt(1), 48, 57))) {\n        unit = \"\\\\65 \" + unit.slice(1, unit.length);\n      }\n      return source + unit;\n    };\n    function escapeIdent(string) {\n      string = \"\" + string;\n      var result = \"\";\n      var firstcode = string.charCodeAt(0);\n      for (var i = 0; i < string.length; i++) {\n        var code = string.charCodeAt(i);\n        if (code == 0) {\n          throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n        }\n        if (between(code, 1, 31) || code == 127 || i == 0 && between(code, 48, 57) || i == 1 && between(code, 48, 57) && firstcode == 45) {\n          result += \"\\\\\" + code.toString(16) + \" \";\n        } else if (code >= 128 || code == 45 || code == 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122)) {\n          result += string[i];\n        } else {\n          result += \"\\\\\" + string[i];\n        }\n      }\n      return result;\n    }\n    function escapeHash(string) {\n      string = \"\" + string;\n      var result = \"\";\n      var firstcode = string.charCodeAt(0);\n      for (var i = 0; i < string.length; i++) {\n        var code = string.charCodeAt(i);\n        if (code == 0) {\n          throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n        }\n        if (code >= 128 || code == 45 || code == 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122)) {\n          result += string[i];\n        } else {\n          result += \"\\\\\" + code.toString(16) + \" \";\n        }\n      }\n      return result;\n    }\n    function escapeString(string) {\n      string = \"\" + string;\n      var result = \"\";\n      for (var i = 0; i < string.length; i++) {\n        var code = string.charCodeAt(i);\n        if (code == 0) {\n          throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n        }\n        if (between(code, 1, 31) || code == 127) {\n          result += \"\\\\\" + code.toString(16) + \" \";\n        } else if (code == 34 || code == 92) {\n          result += \"\\\\\" + string[i];\n        } else {\n          result += string[i];\n        }\n      }\n      return result;\n    }\n    exports2.tokenize = tokenize2;\n    exports2.IdentToken = IdentToken2;\n    exports2.FunctionToken = FunctionToken2;\n    exports2.AtKeywordToken = AtKeywordToken2;\n    exports2.HashToken = HashToken2;\n    exports2.StringToken = StringToken2;\n    exports2.BadStringToken = BadStringToken2;\n    exports2.URLToken = URLToken2;\n    exports2.BadURLToken = BadURLToken2;\n    exports2.DelimToken = DelimToken2;\n    exports2.NumberToken = NumberToken2;\n    exports2.PercentageToken = PercentageToken2;\n    exports2.DimensionToken = DimensionToken;\n    exports2.IncludeMatchToken = IncludeMatchToken;\n    exports2.DashMatchToken = DashMatchToken;\n    exports2.PrefixMatchToken = PrefixMatchToken;\n    exports2.SuffixMatchToken = SuffixMatchToken;\n    exports2.SubstringMatchToken = SubstringMatchToken;\n    exports2.ColumnToken = ColumnToken2;\n    exports2.WhitespaceToken = WhitespaceToken2;\n    exports2.CDOToken = CDOToken2;\n    exports2.CDCToken = CDCToken2;\n    exports2.ColonToken = ColonToken2;\n    exports2.SemicolonToken = SemicolonToken2;\n    exports2.CommaToken = CommaToken2;\n    exports2.OpenParenToken = OpenParenToken;\n    exports2.CloseParenToken = CloseParenToken2;\n    exports2.OpenSquareToken = OpenSquareToken2;\n    exports2.CloseSquareToken = CloseSquareToken2;\n    exports2.OpenCurlyToken = OpenCurlyToken2;\n    exports2.CloseCurlyToken = CloseCurlyToken2;\n    exports2.EOFToken = EOFToken2;\n    exports2.CSSParserToken = CSSParserToken;\n    exports2.GroupingToken = GroupingToken;\n  }\n});\n\n// packages/playwright-core/src/server/injected/selectorUtils.ts\nfunction shouldSkipForTextMatching(element) {\n  return element.nodeName === \"SCRIPT\" || element.nodeName === \"NOSCRIPT\" || element.nodeName === \"STYLE\" || document.head && document.head.contains(element);\n}\nfunction elementText(cache, root) {\n  let value = cache.get(root);\n  if (value === void 0) {\n    value = { full: \"\", immediate: [] };\n    if (!shouldSkipForTextMatching(root)) {\n      let currentImmediate = \"\";\n      if (root instanceof HTMLInputElement && (root.type === \"submit\" || root.type === \"button\")) {\n        value = { full: root.value, immediate: [root.value] };\n      } else {\n        for (let child = root.firstChild; child; child = child.nextSibling) {\n          if (child.nodeType === Node.TEXT_NODE) {\n            value.full += child.nodeValue || \"\";\n            currentImmediate += child.nodeValue || \"\";\n          } else {\n            if (currentImmediate)\n              value.immediate.push(currentImmediate);\n            currentImmediate = \"\";\n            if (child.nodeType === Node.ELEMENT_NODE)\n              value.full += elementText(cache, child).full;\n          }\n        }\n        if (currentImmediate)\n          value.immediate.push(currentImmediate);\n        if (root.shadowRoot)\n          value.full += elementText(cache, root.shadowRoot).full;\n      }\n    }\n    cache.set(root, value);\n  }\n  return value;\n}\n\n// packages/playwright-core/src/server/injected/selectorGenerator.ts\nvar cacheAllowText = /* @__PURE__ */ new Map();\nvar cacheDisallowText = /* @__PURE__ */ new Map();\nvar kNthScore = 1e3;\nfunction querySelector(injectedScript, selector, ownerDocument) {\n  try {\n    const parsedSelector = injectedScript.parseSelector(selector);\n    return {\n      selector,\n      elements: injectedScript.querySelectorAll(parsedSelector, ownerDocument)\n    };\n  } catch (e) {\n    return {\n      selector,\n      elements: []\n    };\n  }\n}\nfunction generateSelector(injectedScript, targetElement, strict) {\n  injectedScript._evaluator.begin();\n  try {\n    targetElement = targetElement.closest(\"button,select,input,[role=button],[role=checkbox],[role=radio]\") || targetElement;\n    const targetTokens = generateSelectorFor(injectedScript, targetElement, strict);\n    const bestTokens = targetTokens || cssFallback(injectedScript, targetElement, strict);\n    const selector = joinTokens(bestTokens);\n    const parsedSelector = injectedScript.parseSelector(selector);\n    return {\n      selector,\n      elements: injectedScript.querySelectorAll(parsedSelector, targetElement.ownerDocument)\n    };\n  } finally {\n    cacheAllowText.clear();\n    cacheDisallowText.clear();\n    injectedScript._evaluator.end();\n  }\n}\nfunction filterRegexTokens(textCandidates) {\n  return textCandidates.filter((c) => c[0].selector[0] !== \"/\");\n}\nfunction generateSelectorFor(injectedScript, targetElement, strict) {\n  if (targetElement.ownerDocument.documentElement === targetElement)\n    return [{ engine: \"css\", selector: \"html\", score: 1 }];\n  const calculate = (element, allowText) => {\n    const allowNthMatch = element === targetElement;\n    let textCandidates = allowText ? buildTextCandidates(injectedScript, element, element === targetElement).map((token) => [token]) : [];\n    if (element !== targetElement) {\n      textCandidates = filterRegexTokens(textCandidates);\n    }\n    const noTextCandidates = buildCandidates(injectedScript, element).map((token) => [token]);\n    let result = chooseFirstSelector(injectedScript, targetElement.ownerDocument, element, [...textCandidates, ...noTextCandidates], allowNthMatch, strict);\n    textCandidates = filterRegexTokens(textCandidates);\n    const checkWithText = (textCandidatesToUse) => {\n      const allowParentText = allowText && !textCandidatesToUse.length;\n      const candidates = [...textCandidatesToUse, ...noTextCandidates].filter((c) => {\n        if (!result)\n          return true;\n        return combineScores(c) < combineScores(result);\n      });\n      let bestPossibleInParent = candidates[0];\n      if (!bestPossibleInParent)\n        return;\n      for (let parent = parentElementOrShadowHost(element); parent; parent = parentElementOrShadowHost(parent)) {\n        const parentTokens = calculateCached(parent, allowParentText);\n        if (!parentTokens)\n          continue;\n        if (result && combineScores([...parentTokens, ...bestPossibleInParent]) >= combineScores(result))\n          continue;\n        bestPossibleInParent = chooseFirstSelector(injectedScript, parent, element, candidates, allowNthMatch, strict);\n        if (!bestPossibleInParent)\n          return;\n        const combined = [...parentTokens, ...bestPossibleInParent];\n        if (!result || combineScores(combined) < combineScores(result))\n          result = combined;\n      }\n    };\n    checkWithText(textCandidates);\n    if (element === targetElement && textCandidates.length)\n      checkWithText([]);\n    return result;\n  };\n  const calculateCached = (element, allowText) => {\n    const cache = allowText ? cacheAllowText : cacheDisallowText;\n    let value = cache.get(element);\n    if (value === void 0) {\n      value = calculate(element, allowText);\n      cache.set(element, value);\n    }\n    return value;\n  };\n  return calculateCached(targetElement, true);\n}\nfunction buildCandidates(injectedScript, element) {\n  const candidates = [];\n  for (const attribute of [\"data-testid\", \"data-test-id\", \"data-test\"]) {\n    if (element.getAttribute(attribute))\n      candidates.push({ engine: \"css\", selector: `[${attribute}=${quoteAttributeValue(element.getAttribute(attribute))}]`, score: 1 });\n  }\n  if (element.nodeName === \"INPUT\") {\n    const input = element;\n    if (input.placeholder)\n      candidates.push({ engine: \"css\", selector: `[placeholder=${quoteAttributeValue(input.placeholder)}]`, score: 10 });\n  }\n  if (element.getAttribute(\"aria-label\"))\n    candidates.push({ engine: \"css\", selector: `[aria-label=${quoteAttributeValue(element.getAttribute(\"aria-label\"))}]`, score: 10 });\n  if (element.getAttribute(\"alt\") && [\"APPLET\", \"AREA\", \"IMG\", \"INPUT\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[alt=${quoteAttributeValue(element.getAttribute(\"alt\"))}]`, score: 10 });\n  if (element.getAttribute(\"role\"))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[role=${quoteAttributeValue(element.getAttribute(\"role\"))}]`, score: 50 });\n  if (element.getAttribute(\"name\") && [\"BUTTON\", \"FORM\", \"FIELDSET\", \"FRAME\", \"IFRAME\", \"INPUT\", \"KEYGEN\", \"OBJECT\", \"OUTPUT\", \"SELECT\", \"TEXTAREA\", \"MAP\", \"META\", \"PARAM\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[name=${quoteAttributeValue(element.getAttribute(\"name\"))}]`, score: 50 });\n  if ([\"INPUT\", \"TEXTAREA\"].includes(element.nodeName) && element.getAttribute(\"type\") !== \"hidden\") {\n    if (element.getAttribute(\"type\"))\n      candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[type=${quoteAttributeValue(element.getAttribute(\"type\"))}]`, score: 50 });\n  }\n  if ([\"INPUT\", \"TEXTAREA\", \"SELECT\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: cssEscape(element.nodeName.toLowerCase()), score: 50 });\n  const idAttr = element.getAttribute(\"id\");\n  if (idAttr && !isGuidLike(idAttr))\n    candidates.push({ engine: \"css\", selector: makeSelectorForId(idAttr), score: 100 });\n  candidates.push({ engine: \"css\", selector: cssEscape(element.nodeName.toLowerCase()), score: 200 });\n  return candidates;\n}\nfunction buildTextCandidates(injectedScript, element, allowHasText) {\n  if (element.nodeName === \"SELECT\")\n    return [];\n  const text = elementText(injectedScript._evaluator._cacheText, element).full.trim().replace(/\\s+/g, \" \").substring(0, 80);\n  if (!text)\n    return [];\n  const candidates = [];\n  let escaped = text;\n  if (text.includes('\"') || text.includes(\">>\") || text[0] === \"/\")\n    escaped = `/.*${escapeForRegex(text)}.*/`;\n  candidates.push({ engine: \"text\", selector: escaped, score: 10 });\n  if (allowHasText && escaped === text) {\n    let prefix = element.nodeName.toLowerCase();\n    if (element.hasAttribute(\"role\"))\n      prefix += `[role=${quoteAttributeValue(element.getAttribute(\"role\"))}]`;\n    candidates.push({ engine: \"css\", selector: `${prefix}:has-text(\"${text}\")`, score: 30 });\n  }\n  return candidates;\n}\nfunction parentElementOrShadowHost(element) {\n  if (element.parentElement)\n    return element.parentElement;\n  if (!element.parentNode)\n    return null;\n  if (element.parentNode.nodeType === Node.DOCUMENT_FRAGMENT_NODE && element.parentNode.host)\n    return element.parentNode.host;\n  return null;\n}\nfunction makeSelectorForId(id) {\n  return /^[a-zA-Z][a-zA-Z0-9\\-\\_]+$/.test(id) ? \"#\" + id : `[id=\"${cssEscape(id)}\"]`;\n}\nfunction cssFallback(injectedScript, targetElement, strict) {\n  const kFallbackScore = 1e7;\n  const root = targetElement.ownerDocument;\n  const tokens = [];\n  function uniqueCSSSelector(prefix) {\n    const path = tokens.slice();\n    if (prefix)\n      path.unshift(prefix);\n    const selector = path.join(\" > \");\n    const parsedSelector = injectedScript.parseSelector(selector);\n    const node = injectedScript.querySelector(parsedSelector, targetElement.ownerDocument, false);\n    return node === targetElement ? selector : void 0;\n  }\n  function makeStrict(selector) {\n    const token = { engine: \"css\", selector, score: kFallbackScore };\n    if (!strict)\n      return [token];\n    const parsedSelector = injectedScript.parseSelector(selector);\n    const elements = injectedScript.querySelectorAll(parsedSelector, targetElement.ownerDocument);\n    if (elements.length === 1)\n      return [token];\n    const nth = { engine: \"nth\", selector: String(elements.indexOf(targetElement)), score: kNthScore };\n    return [token, nth];\n  }\n  for (let element = targetElement; element && element !== root; element = parentElementOrShadowHost(element)) {\n    const nodeName = element.nodeName.toLowerCase();\n    let bestTokenForLevel = \"\";\n    if (element.id) {\n      const token = makeSelectorForId(element.id);\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      bestTokenForLevel = token;\n    }\n    const parent = element.parentNode;\n    const classes = [...element.classList];\n    for (let i = 0; i < classes.length; ++i) {\n      const token = \".\" + cssEscape(classes.slice(0, i + 1).join(\".\"));\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      if (!bestTokenForLevel && parent) {\n        const sameClassSiblings = parent.querySelectorAll(token);\n        if (sameClassSiblings.length === 1)\n          bestTokenForLevel = token;\n      }\n    }\n    if (parent) {\n      const siblings = [...parent.children];\n      const sameTagSiblings = siblings.filter((sibling) => sibling.nodeName.toLowerCase() === nodeName);\n      const token = sameTagSiblings.indexOf(element) === 0 ? cssEscape(nodeName) : `${cssEscape(nodeName)}:nth-child(${1 + siblings.indexOf(element)})`;\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      if (!bestTokenForLevel)\n        bestTokenForLevel = token;\n    } else if (!bestTokenForLevel) {\n      bestTokenForLevel = nodeName;\n    }\n    tokens.unshift(bestTokenForLevel);\n  }\n  return makeStrict(uniqueCSSSelector());\n}\nfunction escapeForRegex(text) {\n  return text.replace(/[.*+?^>${}()|[\\]\\\\]/g, \"\\\\$&\");\n}\nfunction quoteAttributeValue(text) {\n  return `\"${cssEscape(text).replace(/\\\\ /g, \" \")}\"`;\n}\nfunction joinTokens(tokens) {\n  const parts = [];\n  let lastEngine = \"\";\n  for (const { engine, selector } of tokens) {\n    if (parts.length && (lastEngine !== \"css\" || engine !== \"css\" || selector.startsWith(\":nth-match(\")))\n      parts.push(\">>\");\n    lastEngine = engine;\n    if (engine === \"css\")\n      parts.push(selector);\n    else\n      parts.push(`${engine}=${selector}`);\n  }\n  return parts.join(\" \");\n}\nfunction combineScores(tokens) {\n  let score = 0;\n  for (let i = 0; i < tokens.length; i++)\n    score += tokens[i].score * (tokens.length - i);\n  return score;\n}\nfunction chooseFirstSelector(injectedScript, scope, targetElement, selectors, allowNthMatch, strict) {\n  const joined = selectors.map((tokens) => ({ tokens, score: combineScores(tokens) }));\n  joined.sort((a, b) => a.score - b.score);\n  let bestWithIndex = null;\n  for (const { tokens } of joined) {\n    const parsedSelector = injectedScript.parseSelector(joinTokens(tokens));\n    const result = injectedScript.querySelectorAll(parsedSelector, scope);\n    const isStrictEnough = !strict || result.length === 1;\n    const index = result.indexOf(targetElement);\n    if (index === 0 && isStrictEnough) {\n      return tokens;\n    }\n    if (!allowNthMatch || bestWithIndex || index === -1 || result.length > 5)\n      continue;\n    const nth = { engine: \"nth\", selector: String(index), score: kNthScore };\n    bestWithIndex = [...tokens, nth];\n  }\n  return bestWithIndex;\n}\nfunction isGuidLike(id) {\n  let lastCharacterType;\n  let transitionCount = 0;\n  for (let i = 0; i < id.length; ++i) {\n    const c = id[i];\n    let characterType;\n    if (c === \"-\" || c === \"_\")\n      continue;\n    if (c >= \"a\" && c <= \"z\")\n      characterType = \"lower\";\n    else if (c >= \"A\" && c <= \"Z\")\n      characterType = \"upper\";\n    else if (c >= \"0\" && c <= \"9\")\n      characterType = \"digit\";\n    else\n      characterType = \"other\";\n    if (characterType === \"lower\" && lastCharacterType === \"upper\") {\n      lastCharacterType = characterType;\n      continue;\n    }\n    if (lastCharacterType && lastCharacterType !== characterType)\n      ++transitionCount;\n    lastCharacterType = characterType;\n  }\n  return transitionCount >= id.length / 4;\n}\nfunction cssEscape(s) {\n  let result = \"\";\n  for (let i = 0; i < s.length; i++)\n    result += cssEscapeOne(s, i);\n  return result;\n}\nfunction cssEscapeOne(s, i) {\n  const c = s.charCodeAt(i);\n  if (c === 0)\n    return \"\\uFFFD\";\n  if (c >= 1 && c <= 31 || c >= 48 && c <= 57 && (i === 0 || i === 1 && s.charCodeAt(0) === 45))\n    return \"\\\\\" + c.toString(16) + \" \";\n  if (i === 0 && c === 45 && s.length === 1)\n    return \"\\\\\" + s.charAt(i);\n  if (c >= 128 || c === 45 || c === 95 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122)\n    return s.charAt(i);\n  return \"\\\\\" + s.charAt(i);\n}\n\n// packages/playwright-core/src/server/isomorphic/cssParser.ts\nvar css = __toESM(require_cssTokenizer());\n\n// packages/playwright-core/src/server/isomorphic/selectorParser.ts\nfunction stringifySelector(selector) {\n  if (typeof selector === \"string\")\n    return selector;\n  return selector.parts.map((p, i) => {\n    const prefix = p.name === \"css\" ? \"\" : p.name + \"=\";\n    return `${i === selector.capture ? \"*\" : \"\"}${prefix}${p.source}`;\n  }).join(\" >> \");\n}\n\n// packages/playwright-core/src/server/injected/highlight.ts\nvar Highlight = class {\n  constructor(injectedScript) {\n    this._highlightEntries = [];\n    this._injectedScript = injectedScript;\n    this._isUnderTest = injectedScript.isUnderTest;\n    this._glassPaneElement = document.createElement(\"x-pw-glass\");\n    this._glassPaneElement.style.position = \"fixed\";\n    this._glassPaneElement.style.top = \"0\";\n    this._glassPaneElement.style.right = \"0\";\n    this._glassPaneElement.style.bottom = \"0\";\n    this._glassPaneElement.style.left = \"0\";\n    this._glassPaneElement.style.zIndex = \"2147483647\";\n    this._glassPaneElement.style.pointerEvents = \"none\";\n    this._glassPaneElement.style.display = \"flex\";\n    this._actionPointElement = document.createElement(\"x-pw-action-point\");\n    this._actionPointElement.setAttribute(\"hidden\", \"true\");\n    this._glassPaneShadow = this._glassPaneElement.attachShadow({ mode: \"closed\" });\n    this._glassPaneShadow.appendChild(this._actionPointElement);\n    const styleElement = document.createElement(\"style\");\n    styleElement.textContent = `\n        x-pw-tooltip {\n          align-items: center;\n          backdrop-filter: blur(5px);\n          background-color: rgba(0, 0, 0, 0.7);\n          border-radius: 2px;\n          box-shadow: rgba(0, 0, 0, 0.1) 0px 3.6px 3.7px,\n                      rgba(0, 0, 0, 0.15) 0px 12.1px 12.3px,\n                      rgba(0, 0, 0, 0.1) 0px -2px 4px,\n                      rgba(0, 0, 0, 0.15) 0px -12.1px 24px,\n                      rgba(0, 0, 0, 0.25) 0px 54px 55px;\n          color: rgb(204, 204, 204);\n          display: none;\n          font-family: 'Dank Mono', 'Operator Mono', Inconsolata, 'Fira Mono',\n                      'SF Mono', Monaco, 'Droid Sans Mono', 'Source Code Pro', monospace;\n          font-size: 12.8px;\n          font-weight: normal;\n          left: 0;\n          line-height: 1.5;\n          max-width: 600px;\n          padding: 3.2px 5.12px 3.2px;\n          position: absolute;\n          top: 0;\n        }\n        x-pw-action-point {\n          position: absolute;\n          width: 20px;\n          height: 20px;\n          background: red;\n          border-radius: 10px;\n          pointer-events: none;\n          margin: -10px 0 0 -10px;\n          z-index: 2;\n        }\n        *[hidden] {\n          display: none !important;\n        }\n    `;\n    this._glassPaneShadow.appendChild(styleElement);\n  }\n  install() {\n    document.documentElement.appendChild(this._glassPaneElement);\n  }\n  runHighlightOnRaf(selector) {\n    if (this._rafRequest)\n      cancelAnimationFrame(this._rafRequest);\n    this.updateHighlight(this._injectedScript.querySelectorAll(selector, document.documentElement), stringifySelector(selector), false);\n    this._rafRequest = requestAnimationFrame(() => this.runHighlightOnRaf(selector));\n  }\n  uninstall() {\n    if (this._rafRequest)\n      cancelAnimationFrame(this._rafRequest);\n    this._glassPaneElement.remove();\n  }\n  isInstalled() {\n    return this._glassPaneElement.parentElement === document.documentElement && !this._glassPaneElement.nextElementSibling;\n  }\n  showActionPoint(x, y) {\n    this._actionPointElement.style.top = y + \"px\";\n    this._actionPointElement.style.left = x + \"px\";\n    this._actionPointElement.hidden = false;\n    if (this._isUnderTest)\n      console.error(\"Action point for test: \" + JSON.stringify({ x, y }));\n  }\n  hideActionPoint() {\n    this._actionPointElement.hidden = true;\n  }\n  clearHighlight() {\n    var _a, _b;\n    for (const entry of this._highlightEntries) {\n      (_a = entry.highlightElement) == null ? void 0 : _a.remove();\n      (_b = entry.tooltipElement) == null ? void 0 : _b.remove();\n    }\n    this._highlightEntries = [];\n  }\n  updateHighlight(elements, selector, isRecording) {\n    let color;\n    if (isRecording)\n      color = \"#dc6f6f7f\";\n    else\n      color = elements.length > 1 ? \"#f6b26b7f\" : \"#6fa8dc7f\";\n    this._innerUpdateHighlight(elements, { color, tooltipText: selector });\n  }\n  maskElements(elements) {\n    this._innerUpdateHighlight(elements, { color: \"#F0F\" });\n  }\n  _innerUpdateHighlight(elements, options) {\n    if (this._highlightIsUpToDate(elements))\n      return;\n    this.clearHighlight();\n    for (let i = 0; i < elements.length; ++i) {\n      const highlightElement = this._createHighlightElement();\n      this._glassPaneShadow.appendChild(highlightElement);\n      let tooltipElement;\n      if (options.tooltipText) {\n        tooltipElement = document.createElement(\"x-pw-tooltip\");\n        this._glassPaneShadow.appendChild(tooltipElement);\n        const suffix = elements.length > 1 ? ` [${i + 1} of ${elements.length}]` : \"\";\n        tooltipElement.textContent = options.tooltipText + suffix;\n        tooltipElement.style.top = \"0\";\n        tooltipElement.style.left = \"0\";\n        tooltipElement.style.display = \"flex\";\n        if (this._isUnderTest)\n          console.error(\"Highlight text for test: \" + JSON.stringify(tooltipElement.textContent));\n      }\n      this._highlightEntries.push({ targetElement: elements[i], tooltipElement, highlightElement });\n    }\n    for (const entry of this._highlightEntries) {\n      entry.box = entry.targetElement.getBoundingClientRect();\n      if (!entry.tooltipElement)\n        continue;\n      const tooltipWidth = entry.tooltipElement.offsetWidth;\n      const tooltipHeight = entry.tooltipElement.offsetHeight;\n      const totalWidth = this._glassPaneElement.offsetWidth;\n      const totalHeight = this._glassPaneElement.offsetHeight;\n      let anchorLeft = entry.box.left;\n      if (anchorLeft + tooltipWidth > totalWidth - 5)\n        anchorLeft = totalWidth - tooltipWidth - 5;\n      let anchorTop = entry.box.bottom + 5;\n      if (anchorTop + tooltipHeight > totalHeight - 5) {\n        if (entry.box.top > tooltipHeight + 5) {\n          anchorTop = entry.box.top - tooltipHeight - 5;\n        } else {\n          anchorTop = totalHeight - 5 - tooltipHeight;\n        }\n      }\n      entry.tooltipTop = anchorTop;\n      entry.tooltipLeft = anchorLeft;\n    }\n    for (const entry of this._highlightEntries) {\n      if (entry.tooltipElement) {\n        entry.tooltipElement.style.top = entry.tooltipTop + \"px\";\n        entry.tooltipElement.style.left = entry.tooltipLeft + \"px\";\n      }\n      const box = entry.box;\n      entry.highlightElement.style.backgroundColor = options.color;\n      entry.highlightElement.style.left = box.x + \"px\";\n      entry.highlightElement.style.top = box.y + \"px\";\n      entry.highlightElement.style.width = box.width + \"px\";\n      entry.highlightElement.style.height = box.height + \"px\";\n      entry.highlightElement.style.display = \"block\";\n      if (this._isUnderTest)\n        console.error(\"Highlight box for test: \" + JSON.stringify({ x: box.x, y: box.y, width: box.width, height: box.height }));\n    }\n  }\n  _highlightIsUpToDate(elements) {\n    if (elements.length !== this._highlightEntries.length)\n      return false;\n    for (let i = 0; i < this._highlightEntries.length; ++i) {\n      if (elements[i] !== this._highlightEntries[i].targetElement)\n        return false;\n      const oldBox = this._highlightEntries[i].box;\n      if (!oldBox)\n        return false;\n      const box = elements[i].getBoundingClientRect();\n      if (box.top !== oldBox.top || box.right !== oldBox.right || box.bottom !== oldBox.bottom || box.left !== oldBox.left)\n        return false;\n    }\n    return true;\n  }\n  _createHighlightElement() {\n    const highlightElement = document.createElement(\"x-pw-highlight\");\n    highlightElement.style.position = \"absolute\";\n    highlightElement.style.top = \"0\";\n    highlightElement.style.left = \"0\";\n    highlightElement.style.width = \"0\";\n    highlightElement.style.height = \"0\";\n    highlightElement.style.boxSizing = \"border-box\";\n    return highlightElement;\n  }\n};\n\n// packages/playwright-core/src/server/injected/recorder.ts\nvar Recorder = class {\n  constructor(injectedScript) {\n    this._performingAction = false;\n    this._listeners = [];\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._activeModel = null;\n    this._expectProgrammaticKeyUp = false;\n    this._mode = \"none\";\n    this._injectedScript = injectedScript;\n    this._highlight = new Highlight(injectedScript);\n    this._refreshListenersIfNeeded();\n    injectedScript.onGlobalListenersRemoved.add(() => this._refreshListenersIfNeeded());\n    globalThis.__pw_refreshOverlay = () => {\n      this._pollRecorderMode().catch((e) => console.log(e));\n    };\n    globalThis.__pw_refreshOverlay();\n    if (injectedScript.isUnderTest)\n      console.error(\"Recorder script ready for test\");\n  }\n  _refreshListenersIfNeeded() {\n    if (this._highlight.isInstalled())\n      return;\n    removeEventListeners(this._listeners);\n    this._listeners = [\n      addEventListener(document, \"click\", (event) => this._onClick(event), true),\n      addEventListener(document, \"auxclick\", (event) => this._onClick(event), true),\n      addEventListener(document, \"input\", (event) => this._onInput(event), true),\n      addEventListener(document, \"keydown\", (event) => this._onKeyDown(event), true),\n      addEventListener(document, \"keyup\", (event) => this._onKeyUp(event), true),\n      addEventListener(document, \"mousedown\", (event) => this._onMouseDown(event), true),\n      addEventListener(document, \"mouseup\", (event) => this._onMouseUp(event), true),\n      addEventListener(document, \"mousemove\", (event) => this._onMouseMove(event), true),\n      addEventListener(document, \"mouseleave\", (event) => this._onMouseLeave(event), true),\n      addEventListener(document, \"focus\", () => this._onFocus(), true),\n      addEventListener(document, \"scroll\", () => {\n        this._hoveredModel = null;\n        this._highlight.hideActionPoint();\n        this._updateHighlight();\n      }, true)\n    ];\n    this._highlight.install();\n  }\n  async _pollRecorderMode() {\n    var _a;\n    const pollPeriod = 1e3;\n    if (this._pollRecorderModeTimer)\n      clearTimeout(this._pollRecorderModeTimer);\n    const state = await globalThis.__pw_recorderState().catch((e) => null);\n    if (!state) {\n      this._pollRecorderModeTimer = setTimeout(() => this._pollRecorderMode(), pollPeriod);\n      return;\n    }\n    const { mode, actionPoint, actionSelector } = state;\n    if (mode !== this._mode) {\n      this._mode = mode;\n      this._clearHighlight();\n    }\n    if (actionPoint && this._actionPoint && actionPoint.x === this._actionPoint.x && actionPoint.y === this._actionPoint.y) {\n    } else if (!actionPoint && !this._actionPoint) {\n    } else {\n      if (actionPoint)\n        this._highlight.showActionPoint(actionPoint.x, actionPoint.y);\n      else\n        this._highlight.hideActionPoint();\n      this._actionPoint = actionPoint;\n    }\n    if (this._actionSelector && !((_a = this._hoveredModel) == null ? void 0 : _a.elements.length))\n      this._actionSelector = void 0;\n    if (actionSelector !== this._actionSelector) {\n      this._hoveredModel = actionSelector ? querySelector(this._injectedScript, actionSelector, document) : null;\n      this._updateHighlight();\n      this._actionSelector = actionSelector;\n    }\n    this._pollRecorderModeTimer = setTimeout(() => this._pollRecorderMode(), pollPeriod);\n  }\n  _clearHighlight() {\n    this._hoveredModel = null;\n    this._activeModel = null;\n    this._updateHighlight();\n  }\n  _actionInProgress(event) {\n    if (this._performingAction)\n      return true;\n    consumeEvent(event);\n    return false;\n  }\n  _consumedDueToNoModel(event, model) {\n    if (model)\n      return false;\n    consumeEvent(event);\n    return true;\n  }\n  _consumedDueWrongTarget(event) {\n    if (this._activeModel && this._activeModel.elements[0] === this._deepEventTarget(event))\n      return false;\n    consumeEvent(event);\n    return true;\n  }\n  _onClick(event) {\n    if (this._mode === \"inspecting\")\n      globalThis.__pw_recorderSetSelector(this._hoveredModel ? this._hoveredModel.selector : \"\");\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (this._actionInProgress(event))\n      return;\n    if (this._consumedDueToNoModel(event, this._hoveredModel))\n      return;\n    const checkbox = asCheckbox(this._deepEventTarget(event));\n    if (checkbox) {\n      this._performAction({\n        name: checkbox.checked ? \"check\" : \"uncheck\",\n        selector: this._hoveredModel.selector,\n        signals: []\n      });\n      return;\n    }\n    this._performAction({\n      name: \"click\",\n      selector: this._hoveredModel.selector,\n      position: positionForEvent(event),\n      signals: [],\n      button: buttonForEvent(event),\n      modifiers: modifiersForEvent(event),\n      clickCount: event.detail\n    });\n  }\n  _shouldIgnoreMouseEvent(event) {\n    const target = this._deepEventTarget(event);\n    if (this._mode === \"none\")\n      return true;\n    if (this._mode === \"inspecting\") {\n      consumeEvent(event);\n      return true;\n    }\n    const nodeName = target.nodeName;\n    if (nodeName === \"SELECT\")\n      return true;\n    if (nodeName === \"INPUT\" && [\"date\"].includes(target.type))\n      return true;\n    return false;\n  }\n  _onMouseDown(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n    this._activeModel = this._hoveredModel;\n  }\n  _onMouseUp(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n  }\n  _onMouseMove(event) {\n    if (this._mode === \"none\")\n      return;\n    const target = this._deepEventTarget(event);\n    if (this._hoveredElement === target)\n      return;\n    this._hoveredElement = target;\n    this._updateModelForHoveredElement();\n  }\n  _onMouseLeave(event) {\n    if (this._deepEventTarget(event).nodeType === Node.DOCUMENT_NODE) {\n      this._hoveredElement = null;\n      this._updateModelForHoveredElement();\n    }\n  }\n  _onFocus() {\n    const activeElement = this._deepActiveElement(document);\n    const result = activeElement ? generateSelector(this._injectedScript, activeElement, true) : null;\n    this._activeModel = result && result.selector ? result : null;\n    if (this._injectedScript.isUnderTest)\n      console.error(\"Highlight updated for test: \" + (result ? result.selector : null));\n  }\n  _updateModelForHoveredElement() {\n    if (!this._hoveredElement) {\n      this._hoveredModel = null;\n      this._updateHighlight();\n      return;\n    }\n    const hoveredElement = this._hoveredElement;\n    const { selector, elements } = generateSelector(this._injectedScript, hoveredElement, true);\n    if (this._hoveredModel && this._hoveredModel.selector === selector || this._hoveredElement !== hoveredElement)\n      return;\n    this._hoveredModel = selector ? { selector, elements } : null;\n    this._updateHighlight();\n    if (this._injectedScript.isUnderTest)\n      console.error(\"Highlight updated for test: \" + selector);\n  }\n  _updateHighlight() {\n    const elements = this._hoveredModel ? this._hoveredModel.elements : [];\n    const selector = this._hoveredModel ? this._hoveredModel.selector : \"\";\n    this._highlight.updateHighlight(elements, selector, this._mode === \"recording\");\n  }\n  _onInput(event) {\n    if (this._mode !== \"recording\")\n      return true;\n    const target = this._deepEventTarget(event);\n    if ([\"INPUT\", \"TEXTAREA\"].includes(target.nodeName)) {\n      const inputElement = target;\n      const elementType = (inputElement.type || \"\").toLowerCase();\n      if ([\"checkbox\", \"radio\"].includes(elementType)) {\n        return;\n      }\n      if (elementType === \"file\") {\n        globalThis.__pw_recorderRecordAction({\n          name: \"setInputFiles\",\n          selector: this._activeModel.selector,\n          signals: [],\n          files: [...inputElement.files || []].map((file) => file.name)\n        });\n        return;\n      }\n      if (this._consumedDueWrongTarget(event))\n        return;\n      globalThis.__pw_recorderRecordAction({\n        name: \"fill\",\n        selector: this._activeModel.selector,\n        signals: [],\n        text: inputElement.value\n      });\n    }\n    if (target.nodeName === \"SELECT\") {\n      const selectElement = target;\n      if (this._actionInProgress(event))\n        return;\n      this._performAction({\n        name: \"select\",\n        selector: this._hoveredModel.selector,\n        options: [...selectElement.selectedOptions].map((option) => option.value),\n        signals: []\n      });\n    }\n  }\n  _shouldGenerateKeyPressFor(event) {\n    if ([\"Backspace\", \"Delete\", \"AltGraph\"].includes(event.key))\n      return false;\n    if (event.key === \"@\" && event.code === \"KeyL\")\n      return false;\n    if (navigator.platform.includes(\"Mac\")) {\n      if (event.key === \"v\" && event.metaKey)\n        return false;\n    } else {\n      if (event.key === \"v\" && event.ctrlKey)\n        return false;\n      if (event.key === \"Insert\" && event.shiftKey)\n        return false;\n    }\n    if ([\"Shift\", \"Control\", \"Meta\", \"Alt\", \"Process\"].includes(event.key))\n      return false;\n    const hasModifier = event.ctrlKey || event.altKey || event.metaKey;\n    if (event.key.length === 1 && !hasModifier)\n      return !!asCheckbox(this._deepEventTarget(event));\n    return true;\n  }\n  _onKeyDown(event) {\n    if (this._mode === \"inspecting\") {\n      consumeEvent(event);\n      return;\n    }\n    if (this._mode !== \"recording\")\n      return;\n    if (!this._shouldGenerateKeyPressFor(event))\n      return;\n    if (this._actionInProgress(event)) {\n      this._expectProgrammaticKeyUp = true;\n      return;\n    }\n    if (this._consumedDueWrongTarget(event))\n      return;\n    if (event.key === \" \") {\n      const checkbox = asCheckbox(this._deepEventTarget(event));\n      if (checkbox) {\n        this._performAction({\n          name: checkbox.checked ? \"uncheck\" : \"check\",\n          selector: this._activeModel.selector,\n          signals: []\n        });\n        return;\n      }\n    }\n    this._performAction({\n      name: \"press\",\n      selector: this._activeModel.selector,\n      signals: [],\n      key: event.key,\n      modifiers: modifiersForEvent(event)\n    });\n  }\n  _onKeyUp(event) {\n    if (this._mode === \"none\")\n      return;\n    if (!this._shouldGenerateKeyPressFor(event))\n      return;\n    if (!this._expectProgrammaticKeyUp) {\n      consumeEvent(event);\n      return;\n    }\n    this._expectProgrammaticKeyUp = false;\n  }\n  async _performAction(action) {\n    this._clearHighlight();\n    this._performingAction = true;\n    await globalThis.__pw_recorderPerformAction(action).catch(() => {\n    });\n    this._performingAction = false;\n    this._updateModelForHoveredElement();\n    this._onFocus();\n    if (this._injectedScript.isUnderTest) {\n      console.error(\"Action performed for test: \" + JSON.stringify({\n        hovered: this._hoveredModel ? this._hoveredModel.selector : null,\n        active: this._activeModel ? this._activeModel.selector : null\n      }));\n    }\n  }\n  _deepEventTarget(event) {\n    return event.composedPath()[0];\n  }\n  _deepActiveElement(document2) {\n    let activeElement = document2.activeElement;\n    while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement)\n      activeElement = activeElement.shadowRoot.activeElement;\n    return activeElement;\n  }\n};\nfunction modifiersForEvent(event) {\n  return (event.altKey ? 1 : 0) | (event.ctrlKey ? 2 : 0) | (event.metaKey ? 4 : 0) | (event.shiftKey ? 8 : 0);\n}\nfunction buttonForEvent(event) {\n  switch (event.which) {\n    case 1:\n      return \"left\";\n    case 2:\n      return \"middle\";\n    case 3:\n      return \"right\";\n  }\n  return \"left\";\n}\nfunction positionForEvent(event) {\n  const targetElement = event.target;\n  if (targetElement.nodeName !== \"CANVAS\")\n    return;\n  return {\n    x: event.offsetX,\n    y: event.offsetY\n  };\n}\nfunction consumeEvent(e) {\n  e.preventDefault();\n  e.stopPropagation();\n  e.stopImmediatePropagation();\n}\nfunction asCheckbox(node) {\n  if (!node || node.nodeName !== \"INPUT\")\n    return null;\n  const inputElement = node;\n  return [\"checkbox\", \"radio\"].includes(inputElement.type) ? inputElement : null;\n}\nfunction addEventListener(target, eventName, listener, useCapture) {\n  target.addEventListener(eventName, listener, useCapture);\n  const remove = () => {\n    target.removeEventListener(eventName, listener, useCapture);\n  };\n  return remove;\n}\nfunction removeEventListeners(listeners) {\n  for (const listener of listeners)\n    listener();\n  listeners.splice(0, listeners.length);\n}\nmodule.exports = Recorder;\n";
exports.source = source;