"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.source = void 0;
const source = "var __create = Object.create;\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __getProtoOf = Object.getPrototypeOf;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __commonJS = (cb, mod) => function __require() {\n  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, \"default\", { value: mod, enumerable: true }) : target, mod));\n\n// packages/playwright-core/src/server/isomorphic/cssTokenizer.js\nvar require_cssTokenizer = __commonJS({\n  \"packages/playwright-core/src/server/isomorphic/cssTokenizer.js\"(exports2) {\n    (function(root, factory) {\n      if (typeof define === \"function\" && define.amd) {\n        define([\"exports\"], factory);\n      } else if (typeof exports2 !== \"undefined\") {\n        factory(exports2);\n      } else {\n        factory(root);\n      }\n    })(exports2, function(exports3) {\n      var between = function(num, first, last) {\n        return num >= first && num <= last;\n      };\n      function digit(code) {\n        return between(code, 48, 57);\n      }\n      function hexdigit(code) {\n        return digit(code) || between(code, 65, 70) || between(code, 97, 102);\n      }\n      function uppercaseletter(code) {\n        return between(code, 65, 90);\n      }\n      function lowercaseletter(code) {\n        return between(code, 97, 122);\n      }\n      function letter(code) {\n        return uppercaseletter(code) || lowercaseletter(code);\n      }\n      function nonascii(code) {\n        return code >= 128;\n      }\n      function namestartchar(code) {\n        return letter(code) || nonascii(code) || code == 95;\n      }\n      function namechar(code) {\n        return namestartchar(code) || digit(code) || code == 45;\n      }\n      function nonprintable(code) {\n        return between(code, 0, 8) || code == 11 || between(code, 14, 31) || code == 127;\n      }\n      function newline(code) {\n        return code == 10;\n      }\n      function whitespace(code) {\n        return newline(code) || code == 9 || code == 32;\n      }\n      function badescape(code) {\n        return newline(code) || isNaN(code);\n      }\n      var maximumallowedcodepoint = 1114111;\n      var InvalidCharacterError = function(message) {\n        this.message = message;\n      };\n      InvalidCharacterError.prototype = new Error();\n      InvalidCharacterError.prototype.name = \"InvalidCharacterError\";\n      function preprocess(str) {\n        var codepoints = [];\n        for (var i = 0; i < str.length; i++) {\n          var code = str.charCodeAt(i);\n          if (code == 13 && str.charCodeAt(i + 1) == 10) {\n            code = 10;\n            i++;\n          }\n          if (code == 13 || code == 12)\n            code = 10;\n          if (code == 0)\n            code = 65533;\n          if (between(code, 55296, 56319) && between(str.charCodeAt(i + 1), 56320, 57343)) {\n            var lead = code - 55296;\n            var trail = str.charCodeAt(i + 1) - 56320;\n            code = Math.pow(2, 16) + lead * Math.pow(2, 10) + trail;\n            i++;\n          }\n          codepoints.push(code);\n        }\n        return codepoints;\n      }\n      function stringFromCode(code) {\n        if (code <= 65535)\n          return String.fromCharCode(code);\n        code -= Math.pow(2, 16);\n        var lead = Math.floor(code / Math.pow(2, 10)) + 55296;\n        var trail = code % Math.pow(2, 10) + 56320;\n        return String.fromCharCode(lead) + String.fromCharCode(trail);\n      }\n      function tokenize2(str) {\n        str = preprocess(str);\n        var i = -1;\n        var tokens = [];\n        var code;\n        var line = 0;\n        var column = 0;\n        var lastLineLength = 0;\n        var incrLineno = function() {\n          line += 1;\n          lastLineLength = column;\n          column = 0;\n        };\n        var locStart = { line, column };\n        var codepoint = function(i2) {\n          if (i2 >= str.length) {\n            return -1;\n          }\n          return str[i2];\n        };\n        var next = function(num) {\n          if (num === void 0)\n            num = 1;\n          if (num > 3)\n            throw \"Spec Error: no more than three codepoints of lookahead.\";\n          return codepoint(i + num);\n        };\n        var consume = function(num) {\n          if (num === void 0)\n            num = 1;\n          i += num;\n          code = codepoint(i);\n          if (newline(code))\n            incrLineno();\n          else\n            column += num;\n          return true;\n        };\n        var reconsume = function() {\n          i -= 1;\n          if (newline(code)) {\n            line -= 1;\n            column = lastLineLength;\n          } else {\n            column -= 1;\n          }\n          locStart.line = line;\n          locStart.column = column;\n          return true;\n        };\n        var eof = function(codepoint2) {\n          if (codepoint2 === void 0)\n            codepoint2 = code;\n          return codepoint2 == -1;\n        };\n        var donothing = function() {\n        };\n        var parseerror = function() {\n          console.log(\"Parse error at index \" + i + \", processing codepoint 0x\" + code.toString(16) + \".\");\n          return true;\n        };\n        var consumeAToken = function() {\n          consumeComments();\n          consume();\n          if (whitespace(code)) {\n            while (whitespace(next()))\n              consume();\n            return new WhitespaceToken2();\n          } else if (code == 34)\n            return consumeAStringToken();\n          else if (code == 35) {\n            if (namechar(next()) || areAValidEscape(next(1), next(2))) {\n              var token = new HashToken2();\n              if (wouldStartAnIdentifier(next(1), next(2), next(3)))\n                token.type = \"id\";\n              token.value = consumeAName();\n              return token;\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 36) {\n            if (next() == 61) {\n              consume();\n              return new SuffixMatchToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 39)\n            return consumeAStringToken();\n          else if (code == 40)\n            return new OpenParenToken();\n          else if (code == 41)\n            return new CloseParenToken2();\n          else if (code == 42) {\n            if (next() == 61) {\n              consume();\n              return new SubstringMatchToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 43) {\n            if (startsWithANumber()) {\n              reconsume();\n              return consumeANumericToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 44)\n            return new CommaToken2();\n          else if (code == 45) {\n            if (startsWithANumber()) {\n              reconsume();\n              return consumeANumericToken();\n            } else if (next(1) == 45 && next(2) == 62) {\n              consume(2);\n              return new CDCToken2();\n            } else if (startsWithAnIdentifier()) {\n              reconsume();\n              return consumeAnIdentlikeToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 46) {\n            if (startsWithANumber()) {\n              reconsume();\n              return consumeANumericToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 58)\n            return new ColonToken2();\n          else if (code == 59)\n            return new SemicolonToken2();\n          else if (code == 60) {\n            if (next(1) == 33 && next(2) == 45 && next(3) == 45) {\n              consume(3);\n              return new CDOToken2();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 64) {\n            if (wouldStartAnIdentifier(next(1), next(2), next(3))) {\n              return new AtKeywordToken2(consumeAName());\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 91)\n            return new OpenSquareToken2();\n          else if (code == 92) {\n            if (startsWithAValidEscape()) {\n              reconsume();\n              return consumeAnIdentlikeToken();\n            } else {\n              parseerror();\n              return new DelimToken2(code);\n            }\n          } else if (code == 93)\n            return new CloseSquareToken2();\n          else if (code == 94) {\n            if (next() == 61) {\n              consume();\n              return new PrefixMatchToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 123)\n            return new OpenCurlyToken2();\n          else if (code == 124) {\n            if (next() == 61) {\n              consume();\n              return new DashMatchToken();\n            } else if (next() == 124) {\n              consume();\n              return new ColumnToken2();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (code == 125)\n            return new CloseCurlyToken2();\n          else if (code == 126) {\n            if (next() == 61) {\n              consume();\n              return new IncludeMatchToken();\n            } else {\n              return new DelimToken2(code);\n            }\n          } else if (digit(code)) {\n            reconsume();\n            return consumeANumericToken();\n          } else if (namestartchar(code)) {\n            reconsume();\n            return consumeAnIdentlikeToken();\n          } else if (eof())\n            return new EOFToken2();\n          else\n            return new DelimToken2(code);\n        };\n        var consumeComments = function() {\n          while (next(1) == 47 && next(2) == 42) {\n            consume(2);\n            while (true) {\n              consume();\n              if (code == 42 && next() == 47) {\n                consume();\n                break;\n              } else if (eof()) {\n                parseerror();\n                return;\n              }\n            }\n          }\n        };\n        var consumeANumericToken = function() {\n          var num = consumeANumber();\n          if (wouldStartAnIdentifier(next(1), next(2), next(3))) {\n            var token = new DimensionToken();\n            token.value = num.value;\n            token.repr = num.repr;\n            token.type = num.type;\n            token.unit = consumeAName();\n            return token;\n          } else if (next() == 37) {\n            consume();\n            var token = new PercentageToken2();\n            token.value = num.value;\n            token.repr = num.repr;\n            return token;\n          } else {\n            var token = new NumberToken2();\n            token.value = num.value;\n            token.repr = num.repr;\n            token.type = num.type;\n            return token;\n          }\n        };\n        var consumeAnIdentlikeToken = function() {\n          var str2 = consumeAName();\n          if (str2.toLowerCase() == \"url\" && next() == 40) {\n            consume();\n            while (whitespace(next(1)) && whitespace(next(2)))\n              consume();\n            if (next() == 34 || next() == 39) {\n              return new FunctionToken2(str2);\n            } else if (whitespace(next()) && (next(2) == 34 || next(2) == 39)) {\n              return new FunctionToken2(str2);\n            } else {\n              return consumeAURLToken();\n            }\n          } else if (next() == 40) {\n            consume();\n            return new FunctionToken2(str2);\n          } else {\n            return new IdentToken2(str2);\n          }\n        };\n        var consumeAStringToken = function(endingCodePoint) {\n          if (endingCodePoint === void 0)\n            endingCodePoint = code;\n          var string = \"\";\n          while (consume()) {\n            if (code == endingCodePoint || eof()) {\n              return new StringToken2(string);\n            } else if (newline(code)) {\n              parseerror();\n              reconsume();\n              return new BadStringToken2();\n            } else if (code == 92) {\n              if (eof(next())) {\n                donothing();\n              } else if (newline(next())) {\n                consume();\n              } else {\n                string += stringFromCode(consumeEscape());\n              }\n            } else {\n              string += stringFromCode(code);\n            }\n          }\n        };\n        var consumeAURLToken = function() {\n          var token = new URLToken2(\"\");\n          while (whitespace(next()))\n            consume();\n          if (eof(next()))\n            return token;\n          while (consume()) {\n            if (code == 41 || eof()) {\n              return token;\n            } else if (whitespace(code)) {\n              while (whitespace(next()))\n                consume();\n              if (next() == 41 || eof(next())) {\n                consume();\n                return token;\n              } else {\n                consumeTheRemnantsOfABadURL();\n                return new BadURLToken2();\n              }\n            } else if (code == 34 || code == 39 || code == 40 || nonprintable(code)) {\n              parseerror();\n              consumeTheRemnantsOfABadURL();\n              return new BadURLToken2();\n            } else if (code == 92) {\n              if (startsWithAValidEscape()) {\n                token.value += stringFromCode(consumeEscape());\n              } else {\n                parseerror();\n                consumeTheRemnantsOfABadURL();\n                return new BadURLToken2();\n              }\n            } else {\n              token.value += stringFromCode(code);\n            }\n          }\n        };\n        var consumeEscape = function() {\n          consume();\n          if (hexdigit(code)) {\n            var digits = [code];\n            for (var total = 0; total < 5; total++) {\n              if (hexdigit(next())) {\n                consume();\n                digits.push(code);\n              } else {\n                break;\n              }\n            }\n            if (whitespace(next()))\n              consume();\n            var value = parseInt(digits.map(function(x) {\n              return String.fromCharCode(x);\n            }).join(\"\"), 16);\n            if (value > maximumallowedcodepoint)\n              value = 65533;\n            return value;\n          } else if (eof()) {\n            return 65533;\n          } else {\n            return code;\n          }\n        };\n        var areAValidEscape = function(c1, c2) {\n          if (c1 != 92)\n            return false;\n          if (newline(c2))\n            return false;\n          return true;\n        };\n        var startsWithAValidEscape = function() {\n          return areAValidEscape(code, next());\n        };\n        var wouldStartAnIdentifier = function(c1, c2, c3) {\n          if (c1 == 45) {\n            return namestartchar(c2) || c2 == 45 || areAValidEscape(c2, c3);\n          } else if (namestartchar(c1)) {\n            return true;\n          } else if (c1 == 92) {\n            return areAValidEscape(c1, c2);\n          } else {\n            return false;\n          }\n        };\n        var startsWithAnIdentifier = function() {\n          return wouldStartAnIdentifier(code, next(1), next(2));\n        };\n        var wouldStartANumber = function(c1, c2, c3) {\n          if (c1 == 43 || c1 == 45) {\n            if (digit(c2))\n              return true;\n            if (c2 == 46 && digit(c3))\n              return true;\n            return false;\n          } else if (c1 == 46) {\n            if (digit(c2))\n              return true;\n            return false;\n          } else if (digit(c1)) {\n            return true;\n          } else {\n            return false;\n          }\n        };\n        var startsWithANumber = function() {\n          return wouldStartANumber(code, next(1), next(2));\n        };\n        var consumeAName = function() {\n          var result = \"\";\n          while (consume()) {\n            if (namechar(code)) {\n              result += stringFromCode(code);\n            } else if (startsWithAValidEscape()) {\n              result += stringFromCode(consumeEscape());\n            } else {\n              reconsume();\n              return result;\n            }\n          }\n        };\n        var consumeANumber = function() {\n          var repr = [];\n          var type = \"integer\";\n          if (next() == 43 || next() == 45) {\n            consume();\n            repr += stringFromCode(code);\n          }\n          while (digit(next())) {\n            consume();\n            repr += stringFromCode(code);\n          }\n          if (next(1) == 46 && digit(next(2))) {\n            consume();\n            repr += stringFromCode(code);\n            consume();\n            repr += stringFromCode(code);\n            type = \"number\";\n            while (digit(next())) {\n              consume();\n              repr += stringFromCode(code);\n            }\n          }\n          var c1 = next(1), c2 = next(2), c3 = next(3);\n          if ((c1 == 69 || c1 == 101) && digit(c2)) {\n            consume();\n            repr += stringFromCode(code);\n            consume();\n            repr += stringFromCode(code);\n            type = \"number\";\n            while (digit(next())) {\n              consume();\n              repr += stringFromCode(code);\n            }\n          } else if ((c1 == 69 || c1 == 101) && (c2 == 43 || c2 == 45) && digit(c3)) {\n            consume();\n            repr += stringFromCode(code);\n            consume();\n            repr += stringFromCode(code);\n            consume();\n            repr += stringFromCode(code);\n            type = \"number\";\n            while (digit(next())) {\n              consume();\n              repr += stringFromCode(code);\n            }\n          }\n          var value = convertAStringToANumber(repr);\n          return { type, value, repr };\n        };\n        var convertAStringToANumber = function(string) {\n          return +string;\n        };\n        var consumeTheRemnantsOfABadURL = function() {\n          while (consume()) {\n            if (code == 41 || eof()) {\n              return;\n            } else if (startsWithAValidEscape()) {\n              consumeEscape();\n              donothing();\n            } else {\n              donothing();\n            }\n          }\n        };\n        var iterationCount = 0;\n        while (!eof(next())) {\n          tokens.push(consumeAToken());\n          iterationCount++;\n          if (iterationCount > str.length * 2)\n            return \"I'm infinite-looping!\";\n        }\n        return tokens;\n      }\n      function CSSParserToken() {\n        throw \"Abstract Base Class\";\n      }\n      CSSParserToken.prototype.toJSON = function() {\n        return { token: this.tokenType };\n      };\n      CSSParserToken.prototype.toString = function() {\n        return this.tokenType;\n      };\n      CSSParserToken.prototype.toSource = function() {\n        return \"\" + this;\n      };\n      function BadStringToken2() {\n        return this;\n      }\n      BadStringToken2.prototype = Object.create(CSSParserToken.prototype);\n      BadStringToken2.prototype.tokenType = \"BADSTRING\";\n      function BadURLToken2() {\n        return this;\n      }\n      BadURLToken2.prototype = Object.create(CSSParserToken.prototype);\n      BadURLToken2.prototype.tokenType = \"BADURL\";\n      function WhitespaceToken2() {\n        return this;\n      }\n      WhitespaceToken2.prototype = Object.create(CSSParserToken.prototype);\n      WhitespaceToken2.prototype.tokenType = \"WHITESPACE\";\n      WhitespaceToken2.prototype.toString = function() {\n        return \"WS\";\n      };\n      WhitespaceToken2.prototype.toSource = function() {\n        return \" \";\n      };\n      function CDOToken2() {\n        return this;\n      }\n      CDOToken2.prototype = Object.create(CSSParserToken.prototype);\n      CDOToken2.prototype.tokenType = \"CDO\";\n      CDOToken2.prototype.toSource = function() {\n        return \"<!--\";\n      };\n      function CDCToken2() {\n        return this;\n      }\n      CDCToken2.prototype = Object.create(CSSParserToken.prototype);\n      CDCToken2.prototype.tokenType = \"CDC\";\n      CDCToken2.prototype.toSource = function() {\n        return \"-->\";\n      };\n      function ColonToken2() {\n        return this;\n      }\n      ColonToken2.prototype = Object.create(CSSParserToken.prototype);\n      ColonToken2.prototype.tokenType = \":\";\n      function SemicolonToken2() {\n        return this;\n      }\n      SemicolonToken2.prototype = Object.create(CSSParserToken.prototype);\n      SemicolonToken2.prototype.tokenType = \";\";\n      function CommaToken2() {\n        return this;\n      }\n      CommaToken2.prototype = Object.create(CSSParserToken.prototype);\n      CommaToken2.prototype.tokenType = \",\";\n      function GroupingToken() {\n        throw \"Abstract Base Class\";\n      }\n      GroupingToken.prototype = Object.create(CSSParserToken.prototype);\n      function OpenCurlyToken2() {\n        this.value = \"{\";\n        this.mirror = \"}\";\n        return this;\n      }\n      OpenCurlyToken2.prototype = Object.create(GroupingToken.prototype);\n      OpenCurlyToken2.prototype.tokenType = \"{\";\n      function CloseCurlyToken2() {\n        this.value = \"}\";\n        this.mirror = \"{\";\n        return this;\n      }\n      CloseCurlyToken2.prototype = Object.create(GroupingToken.prototype);\n      CloseCurlyToken2.prototype.tokenType = \"}\";\n      function OpenSquareToken2() {\n        this.value = \"[\";\n        this.mirror = \"]\";\n        return this;\n      }\n      OpenSquareToken2.prototype = Object.create(GroupingToken.prototype);\n      OpenSquareToken2.prototype.tokenType = \"[\";\n      function CloseSquareToken2() {\n        this.value = \"]\";\n        this.mirror = \"[\";\n        return this;\n      }\n      CloseSquareToken2.prototype = Object.create(GroupingToken.prototype);\n      CloseSquareToken2.prototype.tokenType = \"]\";\n      function OpenParenToken() {\n        this.value = \"(\";\n        this.mirror = \")\";\n        return this;\n      }\n      OpenParenToken.prototype = Object.create(GroupingToken.prototype);\n      OpenParenToken.prototype.tokenType = \"(\";\n      function CloseParenToken2() {\n        this.value = \")\";\n        this.mirror = \"(\";\n        return this;\n      }\n      CloseParenToken2.prototype = Object.create(GroupingToken.prototype);\n      CloseParenToken2.prototype.tokenType = \")\";\n      function IncludeMatchToken() {\n        return this;\n      }\n      IncludeMatchToken.prototype = Object.create(CSSParserToken.prototype);\n      IncludeMatchToken.prototype.tokenType = \"~=\";\n      function DashMatchToken() {\n        return this;\n      }\n      DashMatchToken.prototype = Object.create(CSSParserToken.prototype);\n      DashMatchToken.prototype.tokenType = \"|=\";\n      function PrefixMatchToken() {\n        return this;\n      }\n      PrefixMatchToken.prototype = Object.create(CSSParserToken.prototype);\n      PrefixMatchToken.prototype.tokenType = \"^=\";\n      function SuffixMatchToken() {\n        return this;\n      }\n      SuffixMatchToken.prototype = Object.create(CSSParserToken.prototype);\n      SuffixMatchToken.prototype.tokenType = \"$=\";\n      function SubstringMatchToken() {\n        return this;\n      }\n      SubstringMatchToken.prototype = Object.create(CSSParserToken.prototype);\n      SubstringMatchToken.prototype.tokenType = \"*=\";\n      function ColumnToken2() {\n        return this;\n      }\n      ColumnToken2.prototype = Object.create(CSSParserToken.prototype);\n      ColumnToken2.prototype.tokenType = \"||\";\n      function EOFToken2() {\n        return this;\n      }\n      EOFToken2.prototype = Object.create(CSSParserToken.prototype);\n      EOFToken2.prototype.tokenType = \"EOF\";\n      EOFToken2.prototype.toSource = function() {\n        return \"\";\n      };\n      function DelimToken2(code) {\n        this.value = stringFromCode(code);\n        return this;\n      }\n      DelimToken2.prototype = Object.create(CSSParserToken.prototype);\n      DelimToken2.prototype.tokenType = \"DELIM\";\n      DelimToken2.prototype.toString = function() {\n        return \"DELIM(\" + this.value + \")\";\n      };\n      DelimToken2.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        return json;\n      };\n      DelimToken2.prototype.toSource = function() {\n        if (this.value == \"\\\\\")\n          return \"\\\\\\n\";\n        else\n          return this.value;\n      };\n      function StringValuedToken() {\n        throw \"Abstract Base Class\";\n      }\n      StringValuedToken.prototype = Object.create(CSSParserToken.prototype);\n      StringValuedToken.prototype.ASCIIMatch = function(str) {\n        return this.value.toLowerCase() == str.toLowerCase();\n      };\n      StringValuedToken.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        return json;\n      };\n      function IdentToken2(val) {\n        this.value = val;\n      }\n      IdentToken2.prototype = Object.create(StringValuedToken.prototype);\n      IdentToken2.prototype.tokenType = \"IDENT\";\n      IdentToken2.prototype.toString = function() {\n        return \"IDENT(\" + this.value + \")\";\n      };\n      IdentToken2.prototype.toSource = function() {\n        return escapeIdent(this.value);\n      };\n      function FunctionToken2(val) {\n        this.value = val;\n        this.mirror = \")\";\n      }\n      FunctionToken2.prototype = Object.create(StringValuedToken.prototype);\n      FunctionToken2.prototype.tokenType = \"FUNCTION\";\n      FunctionToken2.prototype.toString = function() {\n        return \"FUNCTION(\" + this.value + \")\";\n      };\n      FunctionToken2.prototype.toSource = function() {\n        return escapeIdent(this.value) + \"(\";\n      };\n      function AtKeywordToken2(val) {\n        this.value = val;\n      }\n      AtKeywordToken2.prototype = Object.create(StringValuedToken.prototype);\n      AtKeywordToken2.prototype.tokenType = \"AT-KEYWORD\";\n      AtKeywordToken2.prototype.toString = function() {\n        return \"AT(\" + this.value + \")\";\n      };\n      AtKeywordToken2.prototype.toSource = function() {\n        return \"@\" + escapeIdent(this.value);\n      };\n      function HashToken2(val) {\n        this.value = val;\n        this.type = \"unrestricted\";\n      }\n      HashToken2.prototype = Object.create(StringValuedToken.prototype);\n      HashToken2.prototype.tokenType = \"HASH\";\n      HashToken2.prototype.toString = function() {\n        return \"HASH(\" + this.value + \")\";\n      };\n      HashToken2.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        json.type = this.type;\n        return json;\n      };\n      HashToken2.prototype.toSource = function() {\n        if (this.type == \"id\") {\n          return \"#\" + escapeIdent(this.value);\n        } else {\n          return \"#\" + escapeHash(this.value);\n        }\n      };\n      function StringToken2(val) {\n        this.value = val;\n      }\n      StringToken2.prototype = Object.create(StringValuedToken.prototype);\n      StringToken2.prototype.tokenType = \"STRING\";\n      StringToken2.prototype.toString = function() {\n        return '\"' + escapeString(this.value) + '\"';\n      };\n      function URLToken2(val) {\n        this.value = val;\n      }\n      URLToken2.prototype = Object.create(StringValuedToken.prototype);\n      URLToken2.prototype.tokenType = \"URL\";\n      URLToken2.prototype.toString = function() {\n        return \"URL(\" + this.value + \")\";\n      };\n      URLToken2.prototype.toSource = function() {\n        return 'url(\"' + escapeString(this.value) + '\")';\n      };\n      function NumberToken2() {\n        this.value = null;\n        this.type = \"integer\";\n        this.repr = \"\";\n      }\n      NumberToken2.prototype = Object.create(CSSParserToken.prototype);\n      NumberToken2.prototype.tokenType = \"NUMBER\";\n      NumberToken2.prototype.toString = function() {\n        if (this.type == \"integer\")\n          return \"INT(\" + this.value + \")\";\n        return \"NUMBER(\" + this.value + \")\";\n      };\n      NumberToken2.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        json.type = this.type;\n        json.repr = this.repr;\n        return json;\n      };\n      NumberToken2.prototype.toSource = function() {\n        return this.repr;\n      };\n      function PercentageToken2() {\n        this.value = null;\n        this.repr = \"\";\n      }\n      PercentageToken2.prototype = Object.create(CSSParserToken.prototype);\n      PercentageToken2.prototype.tokenType = \"PERCENTAGE\";\n      PercentageToken2.prototype.toString = function() {\n        return \"PERCENTAGE(\" + this.value + \")\";\n      };\n      PercentageToken2.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        json.repr = this.repr;\n        return json;\n      };\n      PercentageToken2.prototype.toSource = function() {\n        return this.repr + \"%\";\n      };\n      function DimensionToken() {\n        this.value = null;\n        this.type = \"integer\";\n        this.repr = \"\";\n        this.unit = \"\";\n      }\n      DimensionToken.prototype = Object.create(CSSParserToken.prototype);\n      DimensionToken.prototype.tokenType = \"DIMENSION\";\n      DimensionToken.prototype.toString = function() {\n        return \"DIM(\" + this.value + \",\" + this.unit + \")\";\n      };\n      DimensionToken.prototype.toJSON = function() {\n        var json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n        json.value = this.value;\n        json.type = this.type;\n        json.repr = this.repr;\n        json.unit = this.unit;\n        return json;\n      };\n      DimensionToken.prototype.toSource = function() {\n        var source = this.repr;\n        var unit = escapeIdent(this.unit);\n        if (unit[0].toLowerCase() == \"e\" && (unit[1] == \"-\" || between(unit.charCodeAt(1), 48, 57))) {\n          unit = \"\\\\65 \" + unit.slice(1, unit.length);\n        }\n        return source + unit;\n      };\n      function escapeIdent(string) {\n        string = \"\" + string;\n        var result = \"\";\n        var firstcode = string.charCodeAt(0);\n        for (var i = 0; i < string.length; i++) {\n          var code = string.charCodeAt(i);\n          if (code == 0) {\n            throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n          }\n          if (between(code, 1, 31) || code == 127 || i == 0 && between(code, 48, 57) || i == 1 && between(code, 48, 57) && firstcode == 45) {\n            result += \"\\\\\" + code.toString(16) + \" \";\n          } else if (code >= 128 || code == 45 || code == 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122)) {\n            result += string[i];\n          } else {\n            result += \"\\\\\" + string[i];\n          }\n        }\n        return result;\n      }\n      function escapeHash(string) {\n        string = \"\" + string;\n        var result = \"\";\n        var firstcode = string.charCodeAt(0);\n        for (var i = 0; i < string.length; i++) {\n          var code = string.charCodeAt(i);\n          if (code == 0) {\n            throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n          }\n          if (code >= 128 || code == 45 || code == 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122)) {\n            result += string[i];\n          } else {\n            result += \"\\\\\" + code.toString(16) + \" \";\n          }\n        }\n        return result;\n      }\n      function escapeString(string) {\n        string = \"\" + string;\n        var result = \"\";\n        for (var i = 0; i < string.length; i++) {\n          var code = string.charCodeAt(i);\n          if (code == 0) {\n            throw new InvalidCharacterError(\"Invalid character: the input contains U+0000.\");\n          }\n          if (between(code, 1, 31) || code == 127) {\n            result += \"\\\\\" + code.toString(16) + \" \";\n          } else if (code == 34 || code == 92) {\n            result += \"\\\\\" + string[i];\n          } else {\n            result += string[i];\n          }\n        }\n        return result;\n      }\n      exports3.tokenize = tokenize2;\n      exports3.IdentToken = IdentToken2;\n      exports3.FunctionToken = FunctionToken2;\n      exports3.AtKeywordToken = AtKeywordToken2;\n      exports3.HashToken = HashToken2;\n      exports3.StringToken = StringToken2;\n      exports3.BadStringToken = BadStringToken2;\n      exports3.URLToken = URLToken2;\n      exports3.BadURLToken = BadURLToken2;\n      exports3.DelimToken = DelimToken2;\n      exports3.NumberToken = NumberToken2;\n      exports3.PercentageToken = PercentageToken2;\n      exports3.DimensionToken = DimensionToken;\n      exports3.IncludeMatchToken = IncludeMatchToken;\n      exports3.DashMatchToken = DashMatchToken;\n      exports3.PrefixMatchToken = PrefixMatchToken;\n      exports3.SuffixMatchToken = SuffixMatchToken;\n      exports3.SubstringMatchToken = SubstringMatchToken;\n      exports3.ColumnToken = ColumnToken2;\n      exports3.WhitespaceToken = WhitespaceToken2;\n      exports3.CDOToken = CDOToken2;\n      exports3.CDCToken = CDCToken2;\n      exports3.ColonToken = ColonToken2;\n      exports3.SemicolonToken = SemicolonToken2;\n      exports3.CommaToken = CommaToken2;\n      exports3.OpenParenToken = OpenParenToken;\n      exports3.CloseParenToken = CloseParenToken2;\n      exports3.OpenSquareToken = OpenSquareToken2;\n      exports3.CloseSquareToken = CloseSquareToken2;\n      exports3.OpenCurlyToken = OpenCurlyToken2;\n      exports3.CloseCurlyToken = CloseCurlyToken2;\n      exports3.EOFToken = EOFToken2;\n      exports3.CSSParserToken = CSSParserToken;\n      exports3.GroupingToken = GroupingToken;\n    });\n  }\n});\n\n// packages/playwright-core/src/utils/isomorphic/stringUtils.ts\nfunction escapeWithQuotes(text, char = \"'\") {\n  const stringified = JSON.stringify(text);\n  const escapedText = stringified.substring(1, stringified.length - 1).replace(/\\\\\"/g, '\"');\n  if (char === \"'\")\n    return char + escapedText.replace(/[']/g, \"\\\\'\") + char;\n  if (char === '\"')\n    return char + escapedText.replace(/[\"]/g, '\\\\\"') + char;\n  if (char === \"`\")\n    return char + escapedText.replace(/[`]/g, \"`\") + char;\n  throw new Error(\"Invalid escape char\");\n}\n\n// packages/playwright-core/src/server/isomorphic/cssParser.ts\nvar css = __toESM(require_cssTokenizer());\n\n// packages/playwright-core/src/server/injected/selectorEvaluator.ts\nfunction shouldSkipForTextMatching(element) {\n  return element.nodeName === \"SCRIPT\" || element.nodeName === \"STYLE\" || document.head && document.head.contains(element);\n}\nfunction elementText(evaluator, root) {\n  let value = evaluator._cacheText.get(root);\n  if (value === void 0) {\n    value = { full: \"\", immediate: [] };\n    if (!shouldSkipForTextMatching(root)) {\n      let currentImmediate = \"\";\n      if (root instanceof HTMLInputElement && (root.type === \"submit\" || root.type === \"button\")) {\n        value = { full: root.value, immediate: [root.value] };\n      } else {\n        for (let child = root.firstChild; child; child = child.nextSibling) {\n          if (child.nodeType === Node.TEXT_NODE) {\n            value.full += child.nodeValue || \"\";\n            currentImmediate += child.nodeValue || \"\";\n          } else {\n            if (currentImmediate)\n              value.immediate.push(currentImmediate);\n            currentImmediate = \"\";\n            if (child.nodeType === Node.ELEMENT_NODE)\n              value.full += elementText(evaluator, child).full;\n          }\n        }\n        if (currentImmediate)\n          value.immediate.push(currentImmediate);\n        if (root.shadowRoot)\n          value.full += elementText(evaluator, root.shadowRoot).full;\n      }\n    }\n    evaluator._cacheText.set(root, value);\n  }\n  return value;\n}\n\n// packages/playwright-core/src/server/injected/selectorGenerator.ts\nvar cacheAllowText = /* @__PURE__ */ new Map();\nvar cacheDisallowText = /* @__PURE__ */ new Map();\nvar kNthScore = 1e3;\nfunction generateSelector(injectedScript, targetElement, strict) {\n  injectedScript._evaluator.begin();\n  try {\n    targetElement = targetElement.closest(\"button,select,input,[role=button],[role=checkbox],[role=radio]\") || targetElement;\n    const targetTokens = generateSelectorFor(injectedScript, targetElement, strict);\n    const bestTokens = targetTokens || cssFallback(injectedScript, targetElement, strict);\n    const selector = joinTokens(bestTokens);\n    const parsedSelector = injectedScript.parseSelector(selector);\n    return {\n      selector,\n      elements: injectedScript.querySelectorAll(parsedSelector, targetElement.ownerDocument)\n    };\n  } finally {\n    cacheAllowText.clear();\n    cacheDisallowText.clear();\n    injectedScript._evaluator.end();\n  }\n}\nfunction filterRegexTokens(textCandidates) {\n  return textCandidates.filter((c) => c[0].selector[0] !== \"/\");\n}\nfunction generateSelectorFor(injectedScript, targetElement, strict) {\n  if (targetElement.ownerDocument.documentElement === targetElement)\n    return [{ engine: \"css\", selector: \"html\", score: 1 }];\n  const calculate = (element, allowText) => {\n    const allowNthMatch = element === targetElement;\n    let textCandidates = allowText ? buildTextCandidates(injectedScript, element, element === targetElement).map((token) => [token]) : [];\n    if (element !== targetElement) {\n      textCandidates = filterRegexTokens(textCandidates);\n    }\n    const noTextCandidates = buildCandidates(injectedScript, element).map((token) => [token]);\n    let result = chooseFirstSelector(injectedScript, targetElement.ownerDocument, element, [...textCandidates, ...noTextCandidates], allowNthMatch, strict);\n    textCandidates = filterRegexTokens(textCandidates);\n    const checkWithText = (textCandidatesToUse) => {\n      const allowParentText = allowText && !textCandidatesToUse.length;\n      const candidates = [...textCandidatesToUse, ...noTextCandidates].filter((c) => {\n        if (!result)\n          return true;\n        return combineScores(c) < combineScores(result);\n      });\n      let bestPossibleInParent = candidates[0];\n      if (!bestPossibleInParent)\n        return;\n      for (let parent = parentElementOrShadowHost(element); parent; parent = parentElementOrShadowHost(parent)) {\n        const parentTokens = calculateCached(parent, allowParentText);\n        if (!parentTokens)\n          continue;\n        if (result && combineScores([...parentTokens, ...bestPossibleInParent]) >= combineScores(result))\n          continue;\n        bestPossibleInParent = chooseFirstSelector(injectedScript, parent, element, candidates, allowNthMatch, strict);\n        if (!bestPossibleInParent)\n          return;\n        const combined = [...parentTokens, ...bestPossibleInParent];\n        if (!result || combineScores(combined) < combineScores(result))\n          result = combined;\n      }\n    };\n    checkWithText(textCandidates);\n    if (element === targetElement && textCandidates.length)\n      checkWithText([]);\n    return result;\n  };\n  const calculateCached = (element, allowText) => {\n    const cache = allowText ? cacheAllowText : cacheDisallowText;\n    let value = cache.get(element);\n    if (value === void 0) {\n      value = calculate(element, allowText);\n      cache.set(element, value);\n    }\n    return value;\n  };\n  return calculateCached(targetElement, true);\n}\nfunction buildCandidates(injectedScript, element) {\n  const candidates = [];\n  for (const attribute of [\"data-testid\", \"data-test-id\", \"data-test\"]) {\n    if (element.getAttribute(attribute))\n      candidates.push({ engine: \"css\", selector: `[${attribute}=${quoteAttributeValue(element.getAttribute(attribute))}]`, score: 1 });\n  }\n  if (element.nodeName === \"INPUT\") {\n    const input = element;\n    if (input.placeholder)\n      candidates.push({ engine: \"css\", selector: `[placeholder=${quoteAttributeValue(input.placeholder)}]`, score: 10 });\n  }\n  if (element.getAttribute(\"aria-label\"))\n    candidates.push({ engine: \"css\", selector: `[aria-label=${quoteAttributeValue(element.getAttribute(\"aria-label\"))}]`, score: 10 });\n  if (element.getAttribute(\"alt\") && [\"APPLET\", \"AREA\", \"IMG\", \"INPUT\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[alt=${quoteAttributeValue(element.getAttribute(\"alt\"))}]`, score: 10 });\n  if (element.getAttribute(\"role\"))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[role=${quoteAttributeValue(element.getAttribute(\"role\"))}]`, score: 50 });\n  if (element.getAttribute(\"name\") && [\"BUTTON\", \"FORM\", \"FIELDSET\", \"IFRAME\", \"INPUT\", \"KEYGEN\", \"OBJECT\", \"OUTPUT\", \"SELECT\", \"TEXTAREA\", \"MAP\", \"META\", \"PARAM\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[name=${quoteAttributeValue(element.getAttribute(\"name\"))}]`, score: 50 });\n  if ([\"INPUT\", \"TEXTAREA\"].includes(element.nodeName) && element.getAttribute(\"type\") !== \"hidden\") {\n    if (element.getAttribute(\"type\"))\n      candidates.push({ engine: \"css\", selector: `${cssEscape(element.nodeName.toLowerCase())}[type=${quoteAttributeValue(element.getAttribute(\"type\"))}]`, score: 50 });\n  }\n  if ([\"INPUT\", \"TEXTAREA\", \"SELECT\"].includes(element.nodeName))\n    candidates.push({ engine: \"css\", selector: cssEscape(element.nodeName.toLowerCase()), score: 50 });\n  const idAttr = element.getAttribute(\"id\");\n  if (idAttr && !isGuidLike(idAttr))\n    candidates.push({ engine: \"css\", selector: makeSelectorForId(idAttr), score: 100 });\n  candidates.push({ engine: \"css\", selector: cssEscape(element.nodeName.toLowerCase()), score: 200 });\n  return candidates;\n}\nfunction buildTextCandidates(injectedScript, element, allowHasText) {\n  if (element.nodeName === \"SELECT\")\n    return [];\n  const text = elementText(injectedScript._evaluator, element).full.trim().replace(/\\s+/g, \" \").substring(0, 80);\n  if (!text)\n    return [];\n  const candidates = [];\n  let escaped = text;\n  if (text.includes('\"') || text.includes(\">>\") || text[0] === \"/\")\n    escaped = `/.*${escapeForRegex(text)}.*/`;\n  candidates.push({ engine: \"text\", selector: escaped, score: 10 });\n  if (allowHasText && escaped === text) {\n    let prefix = element.nodeName.toLowerCase();\n    if (element.hasAttribute(\"role\"))\n      prefix += `[role=${quoteAttributeValue(element.getAttribute(\"role\"))}]`;\n    candidates.push({ engine: \"css\", selector: `${prefix}:has-text(\"${text}\")`, score: 30 });\n  }\n  return candidates;\n}\nfunction parentElementOrShadowHost(element) {\n  if (element.parentElement)\n    return element.parentElement;\n  if (!element.parentNode)\n    return null;\n  if (element.parentNode.nodeType === Node.DOCUMENT_FRAGMENT_NODE && element.parentNode.host)\n    return element.parentNode.host;\n  return null;\n}\nfunction makeSelectorForId(id) {\n  return /^[a-zA-Z][a-zA-Z0-9\\-\\_]+$/.test(id) ? \"#\" + id : `[id=\"${cssEscape(id)}\"]`;\n}\nfunction cssFallback(injectedScript, targetElement, strict) {\n  const kFallbackScore = 1e7;\n  const root = targetElement.ownerDocument;\n  const tokens = [];\n  function uniqueCSSSelector(prefix) {\n    const path = tokens.slice();\n    if (prefix)\n      path.unshift(prefix);\n    const selector = path.join(\" \");\n    const parsedSelector = injectedScript.parseSelector(selector);\n    const node = injectedScript.querySelector(parsedSelector, targetElement.ownerDocument, false);\n    return node === targetElement ? selector : void 0;\n  }\n  function makeStrict(selector) {\n    const token = { engine: \"css\", selector, score: kFallbackScore };\n    if (!strict)\n      return [token];\n    const parsedSelector = injectedScript.parseSelector(selector);\n    const elements = injectedScript.querySelectorAll(parsedSelector, targetElement.ownerDocument);\n    if (elements.length === 1)\n      return [token];\n    const nth = { engine: \"nth\", selector: String(elements.indexOf(targetElement)), score: kNthScore };\n    return [token, nth];\n  }\n  for (let element = targetElement; element && element !== root; element = parentElementOrShadowHost(element)) {\n    const nodeName = element.nodeName.toLowerCase();\n    let bestTokenForLevel = \"\";\n    if (element.id) {\n      const token = makeSelectorForId(element.id);\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      bestTokenForLevel = token;\n    }\n    const parent = element.parentNode;\n    const classes = [...element.classList];\n    for (let i = 0; i < classes.length; ++i) {\n      const token = \".\" + classes.slice(0, i + 1).join(\".\");\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      if (!bestTokenForLevel && parent) {\n        const sameClassSiblings = parent.querySelectorAll(token);\n        if (sameClassSiblings.length === 1)\n          bestTokenForLevel = token;\n      }\n    }\n    if (parent) {\n      const siblings = [...parent.children];\n      const sameTagSiblings = siblings.filter((sibling) => sibling.nodeName.toLowerCase() === nodeName);\n      const token = sameTagSiblings.indexOf(element) === 0 ? cssEscape(nodeName) : `${cssEscape(nodeName)}:nth-child(${1 + siblings.indexOf(element)})`;\n      const selector = uniqueCSSSelector(token);\n      if (selector)\n        return makeStrict(selector);\n      if (!bestTokenForLevel)\n        bestTokenForLevel = token;\n    } else if (!bestTokenForLevel) {\n      bestTokenForLevel = nodeName;\n    }\n    tokens.unshift(bestTokenForLevel);\n  }\n  return makeStrict(uniqueCSSSelector());\n}\nfunction escapeForRegex(text) {\n  return text.replace(/[.*+?^>${}()|[\\]\\\\]/g, \"\\\\$&\");\n}\nfunction quoteAttributeValue(text) {\n  return `\"${cssEscape(text).replace(/\\\\ /g, \" \")}\"`;\n}\nfunction joinTokens(tokens) {\n  const parts = [];\n  let lastEngine = \"\";\n  for (const { engine, selector } of tokens) {\n    if (parts.length && (lastEngine !== \"css\" || engine !== \"css\" || selector.startsWith(\":nth-match(\")))\n      parts.push(\">>\");\n    lastEngine = engine;\n    if (engine === \"css\")\n      parts.push(selector);\n    else\n      parts.push(`${engine}=${selector}`);\n  }\n  return parts.join(\" \");\n}\nfunction combineScores(tokens) {\n  let score = 0;\n  for (let i = 0; i < tokens.length; i++)\n    score += tokens[i].score * (tokens.length - i);\n  return score;\n}\nfunction chooseFirstSelector(injectedScript, scope, targetElement, selectors, allowNthMatch, strict) {\n  const joined = selectors.map((tokens) => ({ tokens, score: combineScores(tokens) }));\n  joined.sort((a, b) => a.score - b.score);\n  let bestWithIndex = null;\n  for (const { tokens } of joined) {\n    const parsedSelector = injectedScript.parseSelector(joinTokens(tokens));\n    const result = injectedScript.querySelectorAll(parsedSelector, scope);\n    const isStrictEnough = !strict || result.length === 1;\n    const index = result.indexOf(targetElement);\n    if (index === 0 && isStrictEnough) {\n      return tokens;\n    }\n    if (!allowNthMatch || bestWithIndex || index === -1 || result.length > 5)\n      continue;\n    const nth = { engine: \"nth\", selector: String(index), score: kNthScore };\n    bestWithIndex = [...tokens, nth];\n  }\n  return bestWithIndex;\n}\nfunction isGuidLike(id) {\n  let lastCharacterType;\n  let transitionCount = 0;\n  for (let i = 0; i < id.length; ++i) {\n    const c = id[i];\n    let characterType;\n    if (c === \"-\" || c === \"_\")\n      continue;\n    if (c >= \"a\" && c <= \"z\")\n      characterType = \"lower\";\n    else if (c >= \"A\" && c <= \"Z\")\n      characterType = \"upper\";\n    else if (c >= \"0\" && c <= \"9\")\n      characterType = \"digit\";\n    else\n      characterType = \"other\";\n    if (characterType === \"lower\" && lastCharacterType === \"upper\") {\n      lastCharacterType = characterType;\n      continue;\n    }\n    if (lastCharacterType && lastCharacterType !== characterType)\n      ++transitionCount;\n    lastCharacterType = characterType;\n  }\n  return transitionCount >= id.length / 4;\n}\nfunction cssEscape(s) {\n  let result = \"\";\n  for (let i = 0; i < s.length; i++)\n    result += cssEscapeOne(s, i);\n  return result;\n}\nfunction cssEscapeOne(s, i) {\n  const c = s.charCodeAt(i);\n  if (c === 0)\n    return \"\\uFFFD\";\n  if (c >= 1 && c <= 31 || c >= 48 && c <= 57 && (i === 0 || i === 1 && s.charCodeAt(0) === 45))\n    return \"\\\\\" + c.toString(16) + \" \";\n  if (i === 0 && c === 45 && s.length === 1)\n    return \"\\\\\" + s.charAt(i);\n  if (c >= 128 || c === 45 || c === 95 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122)\n    return s.charAt(i);\n  return \"\\\\\" + s.charAt(i);\n}\n\n// packages/playwright-core/src/server/injected/consoleApi.ts\nfunction createLocator(injectedScript, initial, options) {\n  class Locator {\n    constructor(selector, options2) {\n      this.selector = selector;\n      if (options2 == null ? void 0 : options2.hasText) {\n        const text = options2.hasText;\n        if (text instanceof RegExp)\n          this.selector += ` >> :scope:text-matches(${escapeWithQuotes(text.source, '\"')}, \"${text.flags}\")`;\n        else\n          this.selector += ` >> :scope:has-text(${escapeWithQuotes(text)})`;\n      }\n      if (options2 == null ? void 0 : options2.has)\n        this.selector += ` >> has=` + JSON.stringify(options2.has.selector);\n      const parsed = injectedScript.parseSelector(this.selector);\n      this.element = injectedScript.querySelector(parsed, document, false);\n      this.elements = injectedScript.querySelectorAll(parsed, document);\n    }\n    locator(selector, options2) {\n      return new Locator(this.selector ? this.selector + \" >> \" + selector : selector, options2);\n    }\n  }\n  return new Locator(initial, options);\n}\nvar ConsoleAPI = class {\n  constructor(injectedScript) {\n    this._injectedScript = injectedScript;\n    if (window.playwright)\n      return;\n    window.playwright = {\n      $: (selector, strict) => this._querySelector(selector, !!strict),\n      $$: (selector) => this._querySelectorAll(selector),\n      locator: (selector, options) => createLocator(this._injectedScript, selector, options),\n      inspect: (selector) => this._inspect(selector),\n      selector: (element) => this._selector(element),\n      resume: () => this._resume()\n    };\n  }\n  _querySelector(selector, strict) {\n    if (typeof selector !== \"string\")\n      throw new Error(`Usage: playwright.query('Playwright >> selector').`);\n    const parsed = this._injectedScript.parseSelector(selector);\n    return this._injectedScript.querySelector(parsed, document, strict);\n  }\n  _querySelectorAll(selector) {\n    if (typeof selector !== \"string\")\n      throw new Error(`Usage: playwright.$$('Playwright >> selector').`);\n    const parsed = this._injectedScript.parseSelector(selector);\n    return this._injectedScript.querySelectorAll(parsed, document);\n  }\n  _inspect(selector) {\n    if (typeof selector !== \"string\")\n      throw new Error(`Usage: playwright.inspect('Playwright >> selector').`);\n    window.inspect(this._querySelector(selector, false));\n  }\n  _selector(element) {\n    if (!(element instanceof Element))\n      throw new Error(`Usage: playwright.selector(element).`);\n    return generateSelector(this._injectedScript, element, true).selector;\n  }\n  _resume() {\n    window._playwrightResume().catch(() => {\n    });\n  }\n};\nmodule.exports = ConsoleAPI;\n";
exports.source = source;