"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createScheme = exports.ValidationError = void 0;
// This file is generated by generate_channels.js, do not edit manually.
const validatorPrimitives_1 = require("./validatorPrimitives");
var validatorPrimitives_2 = require("./validatorPrimitives");
Object.defineProperty(exports, "ValidationError", { enumerable: true, get: function () { return validatorPrimitives_2.ValidationError; } });
function createScheme(tChannel) {
    const scheme = {};
    const tType = (name) => {
        return (arg, path) => {
            const v = scheme[name];
            if (!v)
                throw new validatorPrimitives_1.ValidationError(path + ': unknown type "' + name + '"');
            return v(arg, path);
        };
    };
    scheme.Metadata = validatorPrimitives_1.tObject({
        stack: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.Point = validatorPrimitives_1.tObject({
        x: validatorPrimitives_1.tNumber,
        y: validatorPrimitives_1.tNumber,
    });
    scheme.Rect = validatorPrimitives_1.tObject({
        x: validatorPrimitives_1.tNumber,
        y: validatorPrimitives_1.tNumber,
        width: validatorPrimitives_1.tNumber,
        height: validatorPrimitives_1.tNumber,
    });
    scheme.SerializedValue = validatorPrimitives_1.tObject({
        n: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        b: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        s: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        v: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['null', 'undefined', 'NaN', 'Infinity', '-Infinity', '-0'])),
        d: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        r: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            p: validatorPrimitives_1.tString,
            f: validatorPrimitives_1.tString,
        })),
        a: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('SerializedValue'))),
        o: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tObject({
            k: validatorPrimitives_1.tString,
            v: tType('SerializedValue'),
        }))),
        h: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.SerializedArgument = validatorPrimitives_1.tObject({
        value: tType('SerializedValue'),
        handles: validatorPrimitives_1.tArray(tChannel('*')),
    });
    scheme.AXNode = validatorPrimitives_1.tObject({
        role: validatorPrimitives_1.tString,
        name: validatorPrimitives_1.tString,
        valueString: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        valueNumber: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        description: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        keyshortcuts: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        roledescription: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        valuetext: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        disabled: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        expanded: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        focused: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modal: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        multiline: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        multiselectable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        readonly: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        required: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        selected: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        checked: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['checked', 'unchecked', 'mixed'])),
        pressed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['pressed', 'released', 'mixed'])),
        level: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        valuemin: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        valuemax: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        autocomplete: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        haspopup: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        invalid: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        orientation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        children: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('AXNode'))),
    });
    scheme.SetNetworkCookie = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        value: validatorPrimitives_1.tString,
        url: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        domain: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        path: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        expires: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        httpOnly: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        secure: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        sameSite: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['Strict', 'Lax', 'None'])),
    });
    scheme.NetworkCookie = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        value: validatorPrimitives_1.tString,
        domain: validatorPrimitives_1.tString,
        path: validatorPrimitives_1.tString,
        expires: validatorPrimitives_1.tNumber,
        httpOnly: validatorPrimitives_1.tBoolean,
        secure: validatorPrimitives_1.tBoolean,
        sameSite: validatorPrimitives_1.tEnum(['Strict', 'Lax', 'None']),
    });
    scheme.NameValue = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        value: validatorPrimitives_1.tString,
    });
    scheme.OriginStorage = validatorPrimitives_1.tObject({
        origin: validatorPrimitives_1.tString,
        localStorage: validatorPrimitives_1.tArray(tType('NameValue')),
    });
    scheme.SerializedError = validatorPrimitives_1.tObject({
        error: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            message: validatorPrimitives_1.tString,
            name: validatorPrimitives_1.tString,
            stack: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
        value: validatorPrimitives_1.tOptional(tType('SerializedValue')),
    });
    scheme.SelectorsRegisterParams = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        source: validatorPrimitives_1.tString,
        contentScript: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.BrowserTypeLaunchParams = validatorPrimitives_1.tObject({
        executablePath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        args: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        ignoreAllDefaultArgs: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        ignoreDefaultArgs: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        handleSIGINT: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGTERM: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGHUP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        env: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        headless: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        devtools: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        proxy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            server: validatorPrimitives_1.tString,
            bypass: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            username: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            password: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
        downloadsPath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        firefoxUserPrefs: validatorPrimitives_1.tOptional(validatorPrimitives_1.tAny),
        chromiumSandbox: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        slowMo: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.BrowserTypeLaunchPersistentContextParams = validatorPrimitives_1.tObject({
        userDataDir: validatorPrimitives_1.tString,
        executablePath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        args: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        ignoreAllDefaultArgs: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        ignoreDefaultArgs: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        handleSIGINT: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGTERM: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGHUP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        env: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        headless: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        devtools: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        proxy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            server: validatorPrimitives_1.tString,
            bypass: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            username: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            password: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
        downloadsPath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        chromiumSandbox: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        slowMo: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noDefaultViewport: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        viewport: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            width: validatorPrimitives_1.tNumber,
            height: validatorPrimitives_1.tNumber,
        })),
        ignoreHTTPSErrors: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        javaScriptEnabled: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        bypassCSP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        userAgent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        locale: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        timezoneId: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        geolocation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            longitude: validatorPrimitives_1.tNumber,
            latitude: validatorPrimitives_1.tNumber,
            accuracy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        })),
        permissions: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        extraHTTPHeaders: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        offline: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        httpCredentials: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            username: validatorPrimitives_1.tString,
            password: validatorPrimitives_1.tString,
        })),
        deviceScaleFactor: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        isMobile: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        hasTouch: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        colorScheme: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['light', 'dark', 'no-preference'])),
        acceptDownloads: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        _traceResourcesPath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        _tracePath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        recordVideo: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            dir: validatorPrimitives_1.tString,
            size: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
                width: validatorPrimitives_1.tNumber,
                height: validatorPrimitives_1.tNumber,
            })),
        })),
        recordHar: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            omitContent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
            path: validatorPrimitives_1.tString,
        })),
    });
    scheme.BrowserCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserNewContextParams = validatorPrimitives_1.tObject({
        noDefaultViewport: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        viewport: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            width: validatorPrimitives_1.tNumber,
            height: validatorPrimitives_1.tNumber,
        })),
        ignoreHTTPSErrors: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        javaScriptEnabled: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        bypassCSP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        userAgent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        locale: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        timezoneId: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        geolocation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            longitude: validatorPrimitives_1.tNumber,
            latitude: validatorPrimitives_1.tNumber,
            accuracy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        })),
        permissions: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        extraHTTPHeaders: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        offline: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        httpCredentials: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            username: validatorPrimitives_1.tString,
            password: validatorPrimitives_1.tString,
        })),
        deviceScaleFactor: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        isMobile: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        hasTouch: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        colorScheme: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['dark', 'light', 'no-preference'])),
        acceptDownloads: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        _traceResourcesPath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        _tracePath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        recordVideo: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            dir: validatorPrimitives_1.tString,
            size: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
                width: validatorPrimitives_1.tNumber,
                height: validatorPrimitives_1.tNumber,
            })),
        })),
        recordHar: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            omitContent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
            path: validatorPrimitives_1.tString,
        })),
        proxy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            server: validatorPrimitives_1.tString,
            bypass: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            username: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            password: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
        storageState: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            cookies: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('SetNetworkCookie'))),
            origins: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('OriginStorage'))),
        })),
    });
    scheme.BrowserCrNewBrowserCDPSessionParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserCrStartTracingParams = validatorPrimitives_1.tObject({
        page: validatorPrimitives_1.tOptional(tChannel('Page')),
        path: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        screenshots: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        categories: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
    });
    scheme.BrowserCrStopTracingParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextAddCookiesParams = validatorPrimitives_1.tObject({
        cookies: validatorPrimitives_1.tArray(tType('SetNetworkCookie')),
    });
    scheme.BrowserContextAddInitScriptParams = validatorPrimitives_1.tObject({
        source: validatorPrimitives_1.tString,
    });
    scheme.BrowserContextClearCookiesParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextClearPermissionsParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextCookiesParams = validatorPrimitives_1.tObject({
        urls: validatorPrimitives_1.tArray(validatorPrimitives_1.tString),
    });
    scheme.BrowserContextExposeBindingParams = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        needsHandle: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.BrowserContextGrantPermissionsParams = validatorPrimitives_1.tObject({
        permissions: validatorPrimitives_1.tArray(validatorPrimitives_1.tString),
        origin: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.BrowserContextNewPageParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextSetDefaultNavigationTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.BrowserContextSetDefaultTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.BrowserContextSetExtraHTTPHeadersParams = validatorPrimitives_1.tObject({
        headers: validatorPrimitives_1.tArray(tType('NameValue')),
    });
    scheme.BrowserContextSetGeolocationParams = validatorPrimitives_1.tObject({
        geolocation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            longitude: validatorPrimitives_1.tNumber,
            latitude: validatorPrimitives_1.tNumber,
            accuracy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        })),
    });
    scheme.BrowserContextSetHTTPCredentialsParams = validatorPrimitives_1.tObject({
        httpCredentials: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            username: validatorPrimitives_1.tString,
            password: validatorPrimitives_1.tString,
        })),
    });
    scheme.BrowserContextSetNetworkInterceptionEnabledParams = validatorPrimitives_1.tObject({
        enabled: validatorPrimitives_1.tBoolean,
    });
    scheme.BrowserContextSetOfflineParams = validatorPrimitives_1.tObject({
        offline: validatorPrimitives_1.tBoolean,
    });
    scheme.BrowserContextStorageStateParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BrowserContextExtendInjectedScriptParams = validatorPrimitives_1.tObject({
        source: validatorPrimitives_1.tString,
        arg: tType('SerializedArgument'),
    });
    scheme.BrowserContextCrNewCDPSessionParams = validatorPrimitives_1.tObject({
        page: tChannel('Page'),
    });
    scheme.PageSetDefaultNavigationTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.PageSetDefaultTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.PageSetFileChooserInterceptedNoReplyParams = validatorPrimitives_1.tObject({
        intercepted: validatorPrimitives_1.tBoolean,
    });
    scheme.PageAddInitScriptParams = validatorPrimitives_1.tObject({
        source: validatorPrimitives_1.tString,
    });
    scheme.PageCloseParams = validatorPrimitives_1.tObject({
        runBeforeUnload: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.PageEmulateMediaParams = validatorPrimitives_1.tObject({
        media: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['screen', 'print', 'null'])),
        colorScheme: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['dark', 'light', 'no-preference', 'null'])),
    });
    scheme.PageExposeBindingParams = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
        needsHandle: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.PageGoBackParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        waitUntil: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['load', 'domcontentloaded', 'networkidle'])),
    });
    scheme.PageGoForwardParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        waitUntil: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['load', 'domcontentloaded', 'networkidle'])),
    });
    scheme.PageOpenerParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.PageReloadParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        waitUntil: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['load', 'domcontentloaded', 'networkidle'])),
    });
    scheme.PageScreenshotParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        type: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['png', 'jpeg'])),
        quality: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        omitBackground: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        fullPage: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        clip: validatorPrimitives_1.tOptional(tType('Rect')),
    });
    scheme.PageSetExtraHTTPHeadersParams = validatorPrimitives_1.tObject({
        headers: validatorPrimitives_1.tArray(tType('NameValue')),
    });
    scheme.PageSetNetworkInterceptionEnabledParams = validatorPrimitives_1.tObject({
        enabled: validatorPrimitives_1.tBoolean,
    });
    scheme.PageSetViewportSizeParams = validatorPrimitives_1.tObject({
        viewportSize: validatorPrimitives_1.tObject({
            width: validatorPrimitives_1.tNumber,
            height: validatorPrimitives_1.tNumber,
        }),
    });
    scheme.PageKeyboardDownParams = validatorPrimitives_1.tObject({
        key: validatorPrimitives_1.tString,
    });
    scheme.PageKeyboardUpParams = validatorPrimitives_1.tObject({
        key: validatorPrimitives_1.tString,
    });
    scheme.PageKeyboardInsertTextParams = validatorPrimitives_1.tObject({
        text: validatorPrimitives_1.tString,
    });
    scheme.PageKeyboardTypeParams = validatorPrimitives_1.tObject({
        text: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageKeyboardPressParams = validatorPrimitives_1.tObject({
        key: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageMouseMoveParams = validatorPrimitives_1.tObject({
        x: validatorPrimitives_1.tNumber,
        y: validatorPrimitives_1.tNumber,
        steps: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageMouseDownParams = validatorPrimitives_1.tObject({
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        clickCount: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageMouseUpParams = validatorPrimitives_1.tObject({
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        clickCount: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageMouseClickParams = validatorPrimitives_1.tObject({
        x: validatorPrimitives_1.tNumber,
        y: validatorPrimitives_1.tNumber,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        clickCount: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.PageTouchscreenTapParams = validatorPrimitives_1.tObject({
        x: validatorPrimitives_1.tNumber,
        y: validatorPrimitives_1.tNumber,
    });
    scheme.PageAccessibilitySnapshotParams = validatorPrimitives_1.tObject({
        interestingOnly: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        root: validatorPrimitives_1.tOptional(tChannel('ElementHandle')),
    });
    scheme.PagePdfParams = validatorPrimitives_1.tObject({
        scale: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        displayHeaderFooter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        headerTemplate: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        footerTemplate: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        printBackground: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        landscape: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        pageRanges: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        format: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        width: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        height: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        preferCSSPageSize: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        margin: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            top: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            bottom: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            left: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            right: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
    });
    scheme.PageCrStartJSCoverageParams = validatorPrimitives_1.tObject({
        resetOnNavigation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        reportAnonymousScripts: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.PageCrStopJSCoverageParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.PageCrStartCSSCoverageParams = validatorPrimitives_1.tObject({
        resetOnNavigation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.PageCrStopCSSCoverageParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.PageBringToFrontParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.FrameEvalOnSelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.FrameEvalOnSelectorAllParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.FrameAddScriptTagParams = validatorPrimitives_1.tObject({
        url: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        content: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        type: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.FrameAddStyleTagParams = validatorPrimitives_1.tObject({
        url: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        content: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.FrameCheckParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameClickParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        clickCount: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameContentParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.FrameDblclickParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameDispatchEventParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        type: validatorPrimitives_1.tString,
        eventInit: tType('SerializedArgument'),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameEvaluateExpressionParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
        world: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['main', 'utility'])),
    });
    scheme.FrameEvaluateExpressionHandleParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
        world: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['main', 'utility'])),
    });
    scheme.FrameFillParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        value: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.FrameFocusParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameFrameElementParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.FrameGetAttributeParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        name: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameGotoParams = validatorPrimitives_1.tObject({
        url: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        waitUntil: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['load', 'domcontentloaded', 'networkidle'])),
        referer: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.FrameHoverParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameInnerHTMLParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameInnerTextParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsCheckedParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsDisabledParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsEnabledParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsHiddenParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsVisibleParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameIsEditableParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FramePressParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        key: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameQuerySelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
    });
    scheme.FrameQuerySelectorAllParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
    });
    scheme.FrameSelectOptionParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        elements: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tChannel('ElementHandle'))),
        options: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tObject({
            value: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            label: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            index: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        }))),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.FrameSetContentParams = validatorPrimitives_1.tObject({
        html: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        waitUntil: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['load', 'domcontentloaded', 'networkidle'])),
    });
    scheme.FrameSetInputFilesParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        files: validatorPrimitives_1.tArray(validatorPrimitives_1.tObject({
            name: validatorPrimitives_1.tString,
            mimeType: validatorPrimitives_1.tString,
            buffer: validatorPrimitives_1.tBinary,
        })),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.FrameTapParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameTextContentParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameTitleParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.FrameTypeParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        text: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameUncheckParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameWaitForFunctionParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        pollingInterval: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.FrameWaitForSelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        state: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['attached', 'detached', 'visible', 'hidden'])),
    });
    scheme.WorkerEvaluateExpressionParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.WorkerEvaluateExpressionHandleParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.JSHandleDisposeParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleDisposeParams = tType('JSHandleDisposeParams');
    scheme.JSHandleEvaluateExpressionParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElementHandleEvaluateExpressionParams = tType('JSHandleEvaluateExpressionParams');
    scheme.JSHandleEvaluateExpressionHandleParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElementHandleEvaluateExpressionHandleParams = tType('JSHandleEvaluateExpressionHandleParams');
    scheme.JSHandleGetPropertyListParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleGetPropertyListParams = tType('JSHandleGetPropertyListParams');
    scheme.JSHandleGetPropertyParams = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
    });
    scheme.ElementHandleGetPropertyParams = tType('JSHandleGetPropertyParams');
    scheme.JSHandleJsonValueParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleJsonValueParams = tType('JSHandleJsonValueParams');
    scheme.ElementHandleEvalOnSelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElementHandleEvalOnSelectorAllParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElementHandleBoundingBoxParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleCheckParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleClickParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        clickCount: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleContentFrameParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleDblclickParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        button: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['left', 'right', 'middle'])),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleDispatchEventParams = validatorPrimitives_1.tObject({
        type: validatorPrimitives_1.tString,
        eventInit: tType('SerializedArgument'),
    });
    scheme.ElementHandleFillParams = validatorPrimitives_1.tObject({
        value: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ElementHandleFocusParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleGetAttributeParams = validatorPrimitives_1.tObject({
        name: validatorPrimitives_1.tString,
    });
    scheme.ElementHandleHoverParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleInnerHTMLParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleInnerTextParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsCheckedParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsDisabledParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsEditableParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsEnabledParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsHiddenParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleIsVisibleParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleOwnerFrameParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandlePressParams = validatorPrimitives_1.tObject({
        key: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ElementHandleQuerySelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
    });
    scheme.ElementHandleQuerySelectorAllParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
    });
    scheme.ElementHandleScreenshotParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        type: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['png', 'jpeg'])),
        quality: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        omitBackground: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ElementHandleScrollIntoViewIfNeededParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleSelectOptionParams = validatorPrimitives_1.tObject({
        elements: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tChannel('ElementHandle'))),
        options: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tObject({
            value: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            label: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            index: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        }))),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ElementHandleSelectTextParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleSetInputFilesParams = validatorPrimitives_1.tObject({
        files: validatorPrimitives_1.tArray(validatorPrimitives_1.tObject({
            name: validatorPrimitives_1.tString,
            mimeType: validatorPrimitives_1.tString,
            buffer: validatorPrimitives_1.tBinary,
        })),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ElementHandleTapParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        modifiers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tEnum(['Alt', 'Control', 'Meta', 'Shift']))),
        position: validatorPrimitives_1.tOptional(tType('Point')),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleTextContentParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElementHandleTypeParams = validatorPrimitives_1.tObject({
        text: validatorPrimitives_1.tString,
        delay: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleUncheckParams = validatorPrimitives_1.tObject({
        force: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        noWaitAfter: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleWaitForElementStateParams = validatorPrimitives_1.tObject({
        state: validatorPrimitives_1.tEnum(['visible', 'hidden', 'stable', 'enabled', 'disabled', 'editable']),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElementHandleWaitForSelectorParams = validatorPrimitives_1.tObject({
        selector: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        state: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['attached', 'detached', 'visible', 'hidden'])),
    });
    scheme.RequestResponseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.RouteAbortParams = validatorPrimitives_1.tObject({
        errorCode: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.RouteContinueParams = validatorPrimitives_1.tObject({
        url: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        method: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        headers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        postData: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBinary),
    });
    scheme.RouteFulfillParams = validatorPrimitives_1.tObject({
        status: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        headers: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        body: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        isBase64: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
    });
    scheme.ResourceTiming = validatorPrimitives_1.tObject({
        startTime: validatorPrimitives_1.tNumber,
        domainLookupStart: validatorPrimitives_1.tNumber,
        domainLookupEnd: validatorPrimitives_1.tNumber,
        connectStart: validatorPrimitives_1.tNumber,
        secureConnectionStart: validatorPrimitives_1.tNumber,
        connectEnd: validatorPrimitives_1.tNumber,
        requestStart: validatorPrimitives_1.tNumber,
        responseStart: validatorPrimitives_1.tNumber,
    });
    scheme.ResponseBodyParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ResponseFinishedParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.BindingCallRejectParams = validatorPrimitives_1.tObject({
        error: tType('SerializedError'),
    });
    scheme.BindingCallResolveParams = validatorPrimitives_1.tObject({
        result: tType('SerializedArgument'),
    });
    scheme.DialogAcceptParams = validatorPrimitives_1.tObject({
        promptText: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.DialogDismissParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.DownloadPathParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.DownloadSaveAsParams = validatorPrimitives_1.tObject({
        path: validatorPrimitives_1.tString,
    });
    scheme.DownloadSaveAsStreamParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.DownloadFailureParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.DownloadStreamParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.DownloadDeleteParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.StreamReadParams = validatorPrimitives_1.tObject({
        size: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.StreamCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.CDPSessionSendParams = validatorPrimitives_1.tObject({
        method: validatorPrimitives_1.tString,
        params: validatorPrimitives_1.tOptional(validatorPrimitives_1.tAny),
    });
    scheme.CDPSessionDetachParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.ElectronLaunchParams = validatorPrimitives_1.tObject({
        executablePath: validatorPrimitives_1.tString,
        args: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        cwd: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        env: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        handleSIGINT: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGTERM: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        handleSIGHUP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.ElectronApplicationNewBrowserWindowParams = validatorPrimitives_1.tObject({
        arg: tType('SerializedArgument'),
    });
    scheme.ElectronApplicationEvaluateExpressionParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElectronApplicationEvaluateExpressionHandleParams = validatorPrimitives_1.tObject({
        expression: validatorPrimitives_1.tString,
        isFunction: validatorPrimitives_1.tBoolean,
        arg: tType('SerializedArgument'),
    });
    scheme.ElectronApplicationCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidDevicesParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidSetDefaultTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.AndroidSocketWriteParams = validatorPrimitives_1.tObject({
        data: validatorPrimitives_1.tBinary,
    });
    scheme.AndroidSocketCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidDeviceWaitParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        state: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['gone'])),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceFillParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        text: validatorPrimitives_1.tString,
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceTapParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        duration: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceDragParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        dest: tType('Point'),
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceFlingParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        direction: validatorPrimitives_1.tEnum(['up', 'down', 'left', 'right']),
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceLongTapParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDevicePinchCloseParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        percent: validatorPrimitives_1.tNumber,
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDevicePinchOpenParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        percent: validatorPrimitives_1.tNumber,
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceScrollParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        direction: validatorPrimitives_1.tEnum(['up', 'down', 'left', 'right']),
        percent: validatorPrimitives_1.tNumber,
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceSwipeParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
        direction: validatorPrimitives_1.tEnum(['up', 'down', 'left', 'right']),
        percent: validatorPrimitives_1.tNumber,
        speed: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        timeout: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceInfoParams = validatorPrimitives_1.tObject({
        selector: tType('AndroidSelector'),
    });
    scheme.AndroidDeviceTreeParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidDeviceScreenshotParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidDeviceInputTypeParams = validatorPrimitives_1.tObject({
        text: validatorPrimitives_1.tString,
    });
    scheme.AndroidDeviceInputPressParams = validatorPrimitives_1.tObject({
        key: validatorPrimitives_1.tString,
    });
    scheme.AndroidDeviceInputTapParams = validatorPrimitives_1.tObject({
        point: tType('Point'),
    });
    scheme.AndroidDeviceInputSwipeParams = validatorPrimitives_1.tObject({
        segments: validatorPrimitives_1.tArray(tType('Point')),
        steps: validatorPrimitives_1.tNumber,
    });
    scheme.AndroidDeviceInputDragParams = validatorPrimitives_1.tObject({
        from: tType('Point'),
        to: tType('Point'),
        steps: validatorPrimitives_1.tNumber,
    });
    scheme.AndroidDeviceLaunchBrowserParams = validatorPrimitives_1.tObject({
        pkg: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        ignoreHTTPSErrors: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        javaScriptEnabled: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        bypassCSP: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        userAgent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        locale: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        timezoneId: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        geolocation: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            longitude: validatorPrimitives_1.tNumber,
            latitude: validatorPrimitives_1.tNumber,
            accuracy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        })),
        permissions: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
        extraHTTPHeaders: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('NameValue'))),
        offline: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        httpCredentials: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            username: validatorPrimitives_1.tString,
            password: validatorPrimitives_1.tString,
        })),
        deviceScaleFactor: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        isMobile: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        hasTouch: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        colorScheme: validatorPrimitives_1.tOptional(validatorPrimitives_1.tEnum(['dark', 'light', 'no-preference'])),
        acceptDownloads: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        _traceResourcesPath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        _tracePath: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        recordVideo: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            dir: validatorPrimitives_1.tString,
            size: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
                width: validatorPrimitives_1.tNumber,
                height: validatorPrimitives_1.tNumber,
            })),
        })),
        recordHar: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            omitContent: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
            path: validatorPrimitives_1.tString,
        })),
        proxy: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            server: validatorPrimitives_1.tString,
            bypass: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            username: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
            password: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        })),
    });
    scheme.AndroidDeviceOpenParams = validatorPrimitives_1.tObject({
        command: validatorPrimitives_1.tString,
    });
    scheme.AndroidDeviceShellParams = validatorPrimitives_1.tObject({
        command: validatorPrimitives_1.tString,
    });
    scheme.AndroidDeviceInstallApkParams = validatorPrimitives_1.tObject({
        file: validatorPrimitives_1.tBinary,
        args: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(validatorPrimitives_1.tString)),
    });
    scheme.AndroidDevicePushParams = validatorPrimitives_1.tObject({
        file: validatorPrimitives_1.tBinary,
        path: validatorPrimitives_1.tString,
        mode: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
    });
    scheme.AndroidDeviceSetDefaultTimeoutNoReplyParams = validatorPrimitives_1.tObject({
        timeout: validatorPrimitives_1.tNumber,
    });
    scheme.AndroidDeviceConnectToWebViewParams = validatorPrimitives_1.tObject({
        pid: validatorPrimitives_1.tNumber,
    });
    scheme.AndroidDeviceCloseParams = validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({}));
    scheme.AndroidWebView = validatorPrimitives_1.tObject({
        pid: validatorPrimitives_1.tNumber,
        pkg: validatorPrimitives_1.tString,
    });
    scheme.AndroidSelector = validatorPrimitives_1.tObject({
        checkable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        checked: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        clazz: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        clickable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        depth: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        desc: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        enabled: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        focusable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        focused: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        hasChild: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            selector: tType('AndroidSelector'),
        })),
        hasDescendant: validatorPrimitives_1.tOptional(validatorPrimitives_1.tObject({
            selector: tType('AndroidSelector'),
            maxDepth: validatorPrimitives_1.tOptional(validatorPrimitives_1.tNumber),
        })),
        longClickable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        pkg: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        res: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
        scrollable: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        selected: validatorPrimitives_1.tOptional(validatorPrimitives_1.tBoolean),
        text: validatorPrimitives_1.tOptional(validatorPrimitives_1.tString),
    });
    scheme.AndroidElementInfo = validatorPrimitives_1.tObject({
        children: validatorPrimitives_1.tOptional(validatorPrimitives_1.tArray(tType('AndroidElementInfo'))),
        clazz: validatorPrimitives_1.tString,
        desc: validatorPrimitives_1.tString,
        res: validatorPrimitives_1.tString,
        pkg: validatorPrimitives_1.tString,
        text: validatorPrimitives_1.tString,
        bounds: tType('Rect'),
        checkable: validatorPrimitives_1.tBoolean,
        checked: validatorPrimitives_1.tBoolean,
        clickable: validatorPrimitives_1.tBoolean,
        enabled: validatorPrimitives_1.tBoolean,
        focusable: validatorPrimitives_1.tBoolean,
        focused: validatorPrimitives_1.tBoolean,
        longClickable: validatorPrimitives_1.tBoolean,
        scrollable: validatorPrimitives_1.tBoolean,
        selected: validatorPrimitives_1.tBoolean,
    });
    return scheme;
}
exports.createScheme = createScheme;
//# sourceMappingURL=validator.js.map