/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.Param;
import com.microsoft.playwright.tools.TypeDefinition;
import com.microsoft.playwright.tools.TypeRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Method
extends Element {
    final TypeRef returnType;
    final List<Param> params = new ArrayList<Param>();
    private final String name;
    private static Map<String, String> tsToJavaMethodName = new HashMap<String, String>();
    private static Map<String, String[]> customSignature;
    private static Set<String> skipJavadoc;

    Method(TypeDefinition parent, JsonObject jsonElement) {
        super(parent, (JsonElement)jsonElement);
        if (customSignature.containsKey(this.jsonPath) && customSignature.get(this.jsonPath).length == 0) {
            this.returnType = null;
        } else {
            this.returnType = new TypeRef(this, jsonElement.get("type"));
            if (jsonElement.get("args") != null) {
                for (Map.Entry arg : jsonElement.get("args").getAsJsonObject().entrySet()) {
                    this.params.add(new Param(this, ((JsonElement)arg.getValue()).getAsJsonObject()));
                }
            }
        }
        this.name = tsToJavaMethodName.containsKey(this.jsonName) ? tsToJavaMethodName.get(this.jsonName) : this.jsonName;
    }

    private String toJava() {
        StringBuilder paramList = new StringBuilder();
        for (Param p : this.params) {
            if (paramList.length() > 0) {
                paramList.append(", ");
            }
            paramList.append(p.toJava());
        }
        return this.returnType.toJava() + " " + this.name + "(" + paramList + ");";
    }

    void writeTo(List<String> output, String offset) {
        Param p;
        if (customSignature.containsKey(this.jsonPath)) {
            String[] signatures = customSignature.get(this.jsonPath);
            for (int i = 0; i < signatures.length; ++i) {
                if (i == signatures.length - 1) {
                    this.writeJavadoc(output, offset);
                }
                output.add(offset + signatures[i]);
            }
            return;
        }
        for (int i = this.params.size() - 1; i >= 0 && (p = this.params.get(i)).isOptional(); --i) {
            this.writeDefaultOverloadedMethod(i, output, offset);
        }
        this.writeJavadoc(output, offset);
        output.add(offset + this.toJava());
    }

    private void writeDefaultOverloadedMethod(int paramCount, List<String> output, String offset) {
        StringBuilder paramList = new StringBuilder();
        StringBuilder argList = new StringBuilder();
        for (int i = 0; i < paramCount; ++i) {
            Param p = this.params.get(i);
            if (paramList.length() > 0) {
                paramList.append(", ");
                argList.append(", ");
            }
            paramList.append(p.toJava());
            argList.append(p.jsonName);
        }
        if (argList.length() > 0) {
            argList.append(", ");
        }
        argList.append("int".equals(this.params.get((int)paramCount).type.toJava()) ? "0" : "null");
        String returns = this.returnType.toJava().equals("void") ? "" : "return ";
        output.add(offset + "default " + this.returnType.toJava() + " " + this.name + "(" + paramList + ") {");
        output.add(offset + "  " + returns + this.name + "(" + argList + ");");
        output.add(offset + "}");
    }

    private void writeJavadoc(List<String> output, String offset) {
        if (skipJavadoc.contains(this.jsonPath)) {
            return;
        }
        ArrayList<String> sections = new ArrayList<String>();
        sections.add(this.formattedComment());
        if (!this.params.isEmpty()) {
            for (Param p : this.params) {
                String comment = p.comment();
                if (comment.isEmpty() || skipJavadoc.contains(p.jsonPath)) continue;
                sections.add("@param " + p.name() + " " + comment);
            }
        }
        if (this.jsonElement.getAsJsonObject().has("returnComment")) {
            String returnComment = this.jsonElement.getAsJsonObject().get("returnComment").getAsString();
            sections.add("@return " + returnComment);
        }
        this.writeJavadoc(output, offset, String.join((CharSequence)"\n", sections));
    }

    static {
        tsToJavaMethodName.put("continue", "continue_");
        tsToJavaMethodName.put("$eval", "evalOnSelector");
        tsToJavaMethodName.put("$$eval", "evalOnSelectorAll");
        tsToJavaMethodName.put("$", "querySelector");
        tsToJavaMethodName.put("$$", "querySelectorAll");
        tsToJavaMethodName.put("goto", "navigate");
        customSignature = new HashMap<String, String[]>();
        customSignature.put("Page.setViewportSize", new String[]{"void setViewportSize(int width, int height);"});
        customSignature.put("BrowserContext.setHTTPCredentials", new String[0]);
        customSignature.put("BrowserType.connect", new String[0]);
        customSignature.put("BrowserType.launchServer", new String[0]);
        customSignature.put("Page.coverage", new String[0]);
        customSignature.put("BrowserContext.route", new String[]{"void route(String url, Consumer<Route> handler);", "void route(Pattern url, Consumer<Route> handler);", "void route(Predicate<String> url, Consumer<Route> handler);"});
        customSignature.put("Response.json", new String[0]);
        customSignature.put("Request.postDataJSON", new String[0]);
        customSignature.put("Page.frame", new String[]{"Frame frameByName(String name);", "Frame frameByUrl(String glob);", "Frame frameByUrl(Pattern pattern);", "Frame frameByUrl(Predicate<String> predicate);"});
        customSignature.put("Page.route", new String[]{"void route(String url, Consumer<Route> handler);", "void route(Pattern url, Consumer<Route> handler);", "void route(Predicate<String> url, Consumer<Route> handler);"});
        customSignature.put("BrowserContext.unroute", new String[]{"default void unroute(String url) { unroute(url, null); }", "default void unroute(Pattern url) { unroute(url, null); }", "default void unroute(Predicate<String> url) { unroute(url, null); }", "void unroute(String url, Consumer<Route> handler);", "void unroute(Pattern url, Consumer<Route> handler);", "void unroute(Predicate<String> url, Consumer<Route> handler);"});
        customSignature.put("Page.unroute", new String[]{"default void unroute(String url) { unroute(url, null); }", "default void unroute(Pattern url) { unroute(url, null); }", "default void unroute(Predicate<String> url) { unroute(url, null); }", "void unroute(String url, Consumer<Route> handler);", "void unroute(Pattern url, Consumer<Route> handler);", "void unroute(Predicate<String> url, Consumer<Route> handler);"});
        customSignature.put("BrowserContext.cookies", new String[]{"default List<Cookie> cookies() { return cookies((List<String>) null); }", "default List<Cookie> cookies(String url) { return cookies(Arrays.asList(url)); }", "List<Cookie> cookies(List<String> urls);"});
        customSignature.put("BrowserContext.addCookies", new String[]{"void addCookies(List<AddCookie> cookies);"});
        customSignature.put("FileChooser.setFiles", new String[]{"default void setFiles(Path file) { setFiles(file, null); }", "default void setFiles(Path file, SetFilesOptions options) { setFiles(new Path[]{ file }, options); }", "default void setFiles(Path[] files) { setFiles(files, null); }", "void setFiles(Path[] files, SetFilesOptions options);", "default void setFiles(FileChooser.FilePayload file) { setFiles(file, null); }", "default void setFiles(FileChooser.FilePayload file, SetFilesOptions options)  { setFiles(new FileChooser.FilePayload[]{ file }, options); }", "default void setFiles(FileChooser.FilePayload[] files) { setFiles(files, null); }", "void setFiles(FileChooser.FilePayload[] files, SetFilesOptions options);"});
        customSignature.put("ElementHandle.setInputFiles", new String[]{"default void setInputFiles(Path file) { setInputFiles(file, null); }", "default void setInputFiles(Path file, SetInputFilesOptions options) { setInputFiles(new Path[]{ file }, options); }", "default void setInputFiles(Path[] files) { setInputFiles(files, null); }", "void setInputFiles(Path[] files, SetInputFilesOptions options);", "default void setInputFiles(FileChooser.FilePayload file) { setInputFiles(file, null); }", "default void setInputFiles(FileChooser.FilePayload file, SetInputFilesOptions options)  { setInputFiles(new FileChooser.FilePayload[]{ file }, options); }", "default void setInputFiles(FileChooser.FilePayload[] files) { setInputFiles(files, null); }", "void setInputFiles(FileChooser.FilePayload[] files, SetInputFilesOptions options);"});
        String[] setInputFilesWithSelector = new String[]{"default void setInputFiles(String selector, Path file) { setInputFiles(selector, file, null); }", "default void setInputFiles(String selector, Path file, SetInputFilesOptions options) { setInputFiles(selector, new Path[]{ file }, options); }", "default void setInputFiles(String selector, Path[] files) { setInputFiles(selector, files, null); }", "void setInputFiles(String selector, Path[] files, SetInputFilesOptions options);", "default void setInputFiles(String selector, FileChooser.FilePayload file) { setInputFiles(selector, file, null); }", "default void setInputFiles(String selector, FileChooser.FilePayload file, SetInputFilesOptions options)  { setInputFiles(selector, new FileChooser.FilePayload[]{ file }, options); }", "default void setInputFiles(String selector, FileChooser.FilePayload[] files) { setInputFiles(selector, files, null); }", "void setInputFiles(String selector, FileChooser.FilePayload[] files, SetInputFilesOptions options);"};
        customSignature.put("Page.setInputFiles", setInputFilesWithSelector);
        customSignature.put("Frame.setInputFiles", setInputFilesWithSelector);
        String[] waitForEvent = new String[]{"default Deferred<Event<EventType>> waitForEvent(EventType event) {", "  return waitForEvent(event, (WaitForEventOptions) null);", "}", "default Deferred<Event<EventType>> waitForEvent(EventType event, Predicate<Event<EventType>> predicate) {", "  WaitForEventOptions options = new WaitForEventOptions();", "  options.predicate = predicate;", "  return waitForEvent(event, options);", "}", "Deferred<Event<EventType>> waitForEvent(EventType event, WaitForEventOptions options);"};
        customSignature.put("Page.waitForEvent", waitForEvent);
        customSignature.put("BrowserContext.waitForEvent", waitForEvent);
        customSignature.put("WebSocket.waitForEvent", waitForEvent);
        customSignature.put("Page.waitForRequest", new String[]{"default Deferred<Request> waitForRequest(String urlGlob) { return waitForRequest(urlGlob, null); }", "default Deferred<Request> waitForRequest(Pattern urlPattern) { return waitForRequest(urlPattern, null); }", "default Deferred<Request> waitForRequest(Predicate<String> urlPredicate) { return waitForRequest(urlPredicate, null); }", "Deferred<Request> waitForRequest(String urlGlob, WaitForRequestOptions options);", "Deferred<Request> waitForRequest(Pattern urlPattern, WaitForRequestOptions options);", "Deferred<Request> waitForRequest(Predicate<String> urlPredicate, WaitForRequestOptions options);"});
        customSignature.put("Page.waitForResponse", new String[]{"default Deferred<Response> waitForResponse(String urlGlob) { return waitForResponse(urlGlob, null); }", "default Deferred<Response> waitForResponse(Pattern urlPattern) { return waitForResponse(urlPattern, null); }", "default Deferred<Response> waitForResponse(Predicate<String> urlPredicate) { return waitForResponse(urlPredicate, null); }", "Deferred<Response> waitForResponse(String urlGlob, WaitForResponseOptions options);", "Deferred<Response> waitForResponse(Pattern urlPattern, WaitForResponseOptions options);", "Deferred<Response> waitForResponse(Predicate<String> urlPredicate, WaitForResponseOptions options);"});
        String[] selectOption = new String[]{"default List<String> selectOption(String selector, String value) {", "  return selectOption(selector, value, null);", "}", "default List<String> selectOption(String selector, String value, SelectOptionOptions options) {", "  String[] values = value == null ? null : new String[]{ value };", "  return selectOption(selector, values, options);", "}", "default List<String> selectOption(String selector, String[] values) {", "  return selectOption(selector, values, null);", "}", "default List<String> selectOption(String selector, String[] values, SelectOptionOptions options) {", "  if (values == null) {", "    return selectOption(selector, new ElementHandle.SelectOption[0], options);", "  }", "  return selectOption(selector, Arrays.asList(values).stream().map(", "    v -> new ElementHandle.SelectOption().withValue(v)).toArray(ElementHandle.SelectOption[]::new), options);", "}", "default List<String> selectOption(String selector, ElementHandle.SelectOption value) {", "  return selectOption(selector, value, null);", "}", "default List<String> selectOption(String selector, ElementHandle.SelectOption value, SelectOptionOptions options) {", "  ElementHandle.SelectOption[] values = value == null ? null : new ElementHandle.SelectOption[]{value};", "  return selectOption(selector, values, options);", "}", "default List<String> selectOption(String selector, ElementHandle.SelectOption[] values) {", "  return selectOption(selector, values, null);", "}", "List<String> selectOption(String selector, ElementHandle.SelectOption[] values, SelectOptionOptions options);", "default List<String> selectOption(String selector, ElementHandle value) {", "  return selectOption(selector, value, null);", "}", "default List<String> selectOption(String selector, ElementHandle value, SelectOptionOptions options) {", "  ElementHandle[] values = value == null ? null : new ElementHandle[]{value};", "  return selectOption(selector, values, options);", "}", "default List<String> selectOption(String selector, ElementHandle[] values) {", "  return selectOption(selector, values, null);", "}", "List<String> selectOption(String selector, ElementHandle[] values, SelectOptionOptions options);"};
        customSignature.put("Page.selectOption", selectOption);
        customSignature.put("Frame.selectOption", selectOption);
        customSignature.put("ElementHandle.selectOption", (String[])Arrays.stream(selectOption).map(s -> s.replace("String selector, ", "").replace("(selector, ", "(").replace("ElementHandle.", "")).toArray(String[]::new));
        customSignature.put("Selectors.register", new String[]{"default void register(String name, String script) { register(name, script, null); }", "void register(String name, String script, RegisterOptions options);", "default void register(String name, Path path) { register(name, path, null); }", "void register(String name, Path path, RegisterOptions options);"});
        skipJavadoc = new HashSet<String>(Arrays.asList("BrowserContext.waitForEvent.optionsOrPredicate", "Page.waitForEvent.optionsOrPredicate", "WebSocket.waitForEvent.optionsOrPredicate", "Page.frame.options", "Page.waitForRequest", "Page.waitForResponse"));
    }
}

