/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.Field;
import com.microsoft.playwright.tools.TypeDefinition;
import com.microsoft.playwright.tools.Types;

class TypeRef
extends Element {
    String customType;
    boolean isNestedClass;

    TypeRef(Element parent, JsonElement jsonElement) {
        super(parent, true, jsonElement);
        this.createCustomType();
    }

    void createCustomType() {
        Types.Mapping mapping;
        boolean isEnum = this.jsonName.contains("|\"");
        boolean isClass = this.jsonName.replace("null|", "").equals("Object") || this.jsonName.equals("Promise<Array<Object>>");
        String parentPath = this.parent.jsonPath;
        if (this.jsonName.equals("Array<Object>") && "BrowserContext.addCookies.cookies".equals(this.jsonPath)) {
            isClass = true;
        }
        if (this.jsonName.equals("Promise<Object>") && "BrowserContext.storageState".equals(this.jsonPath)) {
            isClass = true;
        }
        if ((mapping = TypeDefinition.types.findForPath(parentPath)) == null) {
            if (isEnum) {
                throw new RuntimeException("Cannot create enum, type mapping is missing for: " + parentPath);
            }
            if (!isClass) {
                return;
            }
            this.customType = this.parent instanceof Field ? TypeRef.toTitle(this.parent.jsonName) : TypeRef.toTitle(this.parent.parent.jsonName) + TypeRef.toTitle(this.parent.jsonName);
        } else {
            if (!mapping.from.equals(this.jsonName)) {
                throw new RuntimeException("Unexpected source type for: " + parentPath + ". Expected: " + mapping.from + "; found: " + this.jsonName);
            }
            this.customType = mapping.to;
            if (mapping.customMapping != null) {
                mapping.customMapping.defineTypesIn(this.typeScope());
                return;
            }
        }
        if (isEnum) {
            this.typeScope().createEnum(this.customType, this.jsonName);
        } else if (isClass) {
            this.typeScope().createNestedClass(this.customType, this, this.jsonElement.getAsJsonObject());
            this.isNestedClass = true;
        }
    }

    String toJava() {
        if (this.customType != null) {
            return this.customType;
        }
        if (this.jsonElement.isJsonNull()) {
            return "void";
        }
        if (!this.parent.jsonElement.getAsJsonObject().get("required").getAsBoolean()) {
            if (this.jsonName.equals("number")) {
                return "Integer";
            }
            if (this.jsonName.equals("boolean")) {
                return "Boolean";
            }
        }
        if (this.jsonName.replace("null|", "").contains("|")) {
            throw new RuntimeException("Missing mapping for type union: " + this.jsonPath + ": " + this.jsonName);
        }
        return TypeRef.convertBuiltinType(TypeRef.stripPromise(this.jsonName));
    }

    private static String stripPromise(String type) {
        if ("Promise".equals(type)) {
            return "void";
        }
        if (type.startsWith("Promise<")) {
            return type.substring("Promise<".length(), type.length() - 1);
        }
        return type;
    }

    private static String convertBuiltinType(String type) {
        return type.replace("Array<", "List<").replace("Object<", "Map<").replace("string", "String").replace("number", "int").replace("null|", "");
    }
}

