/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.TokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import java.util.List;

public class SilentTokenCommand
extends TokenCommand {
    private static final String TAG = SilentTokenCommand.class.getSimpleName();

    public SilentTokenCommand(@NonNull SilentTokenCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, callback, publicApiId);
    }

    public SilentTokenCommand(@NonNull SilentTokenCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controllers, callback, publicApiId);
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        AcquireTokenResult result = null;
        String methodName = ":execute";
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = this.getControllers().get(ii);
            try {
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
                result = controller.acquireTokenSilent((SilentTokenCommandParameters)this.getParameters());
                if (!result.getSucceeded().booleanValue()) continue;
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName() + ": Succeeded");
                return result;
            }
            catch (ClientException | UiRequiredException e) {
                if (e.getErrorCode().equals("invalid_grant") && this.getControllers().size() > ii + 1 || (e.getErrorCode().equals("no_tokens_found") || e.getErrorCode().equals("no_account_found")) && this.getControllers().size() > ii + 1) continue;
                throw e;
            }
        }
        return result;
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SilentTokenCommand)) {
            return false;
        }
        SilentTokenCommand other = (SilentTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SilentTokenCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

