/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import java.io.Serializable;
import java.util.List;

public class BrokerResult
implements Serializable {
    private static final long serialVersionUID = 8606631820514878489L;
    @SerializedName(value="access_token")
    @Nullable
    private String mAccessToken;
    @SerializedName(value="id_token")
    @Nullable
    private String mIdToken;
    @SerializedName(value="refresh_token")
    @Nullable
    private String mRefreshToken;
    @SerializedName(value="home_account_id")
    @Nullable
    private String mHomeAccountId;
    @SerializedName(value="local_account_id")
    @Nullable
    private String mLocalAccountId;
    @SerializedName(value="username")
    @Nullable
    private String mUserName;
    @SerializedName(value="client_id")
    @Nullable
    private String mClientId;
    @SerializedName(value="family_id")
    @Nullable
    private String mFamilyId;
    @SerializedName(value="scopes")
    @Nullable
    private String mScope;
    @SerializedName(value="token_type")
    @Nullable
    private String mTokenType;
    @SerializedName(value="client_info")
    @Nullable
    private String mClientInfo;
    @SerializedName(value="authority")
    @Nullable
    private String mAuthority;
    @SerializedName(value="environment")
    @Nullable
    private String mEnvironment;
    @SerializedName(value="tenant_id")
    @Nullable
    private String mTenantId;
    @SerializedName(value="expires_on")
    @Nullable
    private long mExpiresOn;
    @SerializedName(value="ext_expires_on")
    @Nullable
    private long mExtendedExpiresOn;
    @SerializedName(value="cached_at")
    @Nullable
    private long mCachedAt;
    @SerializedName(value="spe_ring")
    @Nullable
    private String mSpeRing;
    @SerializedName(value="refresh_token_age")
    @Nullable
    private String mRefreshTokenAge;
    @SerializedName(value="success")
    @NonNull
    private boolean mSuccess;
    @SerializedName(value="serviced_from_cache")
    private boolean mServicedFromCache;
    @SerializedName(value="broker_error_code")
    @Nullable
    private String mErrorCode;
    @SerializedName(value="broker_error_message")
    @Nullable
    private String mErrorMessage;
    @SerializedName(value="correlation_id")
    @Nullable
    private String mCorrelationId;
    @SerializedName(value="oauth_sub_error")
    @Nullable
    private String mSubErrorCode;
    @SerializedName(value="http_response_code")
    @Nullable
    private int mHttpStatusCode;
    @SerializedName(value="http_response_headers")
    @Nullable
    private String mHttpResponseHeaders;
    @SerializedName(value="http_response_body")
    @Nullable
    private String mHttpResponseBody;
    @SerializedName(value="cli_telem_error_code")
    @Nullable
    private String mCliTelemErrorCode;
    @SerializedName(value="cli_telem_suberror_code")
    @Nullable
    private String mCliTelemSubErrorCode;
    @SerializedName(value="tenant_profile_cache_records")
    @Nullable
    private final List<ICacheRecord> mTenantProfileData;
    @SerializedName(value="broker_exception_type")
    @Nullable
    private final String mExceptionType;

    private BrokerResult(@NonNull Builder builder) {
        this.mAccessToken = builder.mAccessToken;
        this.mIdToken = builder.mIdToken;
        this.mRefreshToken = builder.mRefreshToken;
        this.mHomeAccountId = builder.mHomeAccountId;
        this.mLocalAccountId = builder.mLocalAccountId;
        this.mUserName = builder.mUserName;
        this.mTokenType = builder.mTokenType;
        this.mClientId = builder.mClientId;
        this.mFamilyId = builder.mFamilyId;
        this.mScope = builder.mScope;
        this.mClientInfo = builder.mClientInfo;
        this.mAuthority = builder.mAuthority;
        this.mEnvironment = builder.mEnvironment;
        this.mTenantId = builder.mTenantId;
        this.mExpiresOn = builder.mExpiresOn;
        this.mExtendedExpiresOn = builder.mExtendedExpiresOn;
        this.mCachedAt = builder.mCachedAt;
        this.mSpeRing = builder.mSpeRing;
        this.mRefreshTokenAge = builder.mRefreshTokenAge;
        this.mSuccess = builder.mSuccess;
        this.mTenantProfileData = builder.mTenantProfileData;
        this.mServicedFromCache = builder.mServicedFromCache;
        this.mErrorCode = builder.mErrorCode;
        this.mErrorMessage = builder.mErrorMessage;
        this.mCorrelationId = builder.mCorrelationId;
        this.mSubErrorCode = builder.mSubErrorCode;
        this.mHttpStatusCode = builder.mHttpStatusCode;
        this.mHttpResponseBody = builder.mHttpResponseBody;
        this.mHttpResponseHeaders = builder.mHttpResponseHeaders;
        this.mCliTelemErrorCode = builder.mCliTelemErrorCode;
        this.mCliTelemSubErrorCode = builder.mCliTelemSubErrorCode;
        this.mExceptionType = builder.mExceptionType;
    }

    public String getExceptionType() {
        return this.mExceptionType;
    }

    public List<ICacheRecord> getTenantProfileData() {
        return this.mTenantProfileData;
    }

    public String getCliTelemSubErrorCode() {
        return this.mCliTelemSubErrorCode;
    }

    public String getCliTelemErrorCode() {
        return this.mCliTelemErrorCode;
    }

    public String getHttpResponseBody() {
        return this.mHttpResponseBody;
    }

    public String getHttpResponseHeaders() {
        return this.mHttpResponseHeaders;
    }

    public int getHttpStatusCode() {
        return this.mHttpStatusCode;
    }

    public String getSubErrorCode() {
        return this.mSubErrorCode;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public boolean isSuccess() {
        return this.mSuccess;
    }

    public boolean isServicedFromCache() {
        return this.mServicedFromCache;
    }

    public String getRefreshTokenAge() {
        return this.mRefreshTokenAge;
    }

    public String getSpeRing() {
        return this.mSpeRing;
    }

    public long getCachedAt() {
        return this.mCachedAt;
    }

    public long getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    public long getExpiresOn() {
        return this.mExpiresOn;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getClientInfo() {
        return this.mClientInfo;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getFamilyId() {
        return this.mFamilyId;
    }

    public String getScope() {
        return this.mScope;
    }

    public String getTokenType() {
        return this.mTokenType;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getLocalAccountId() {
        return this.mLocalAccountId;
    }

    public String getHomeAccountId() {
        return this.mHomeAccountId;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public String getIdToken() {
        return this.mIdToken;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public static class Builder {
        private String mAccessToken;
        private String mIdToken;
        private String mRefreshToken;
        private String mHomeAccountId;
        private String mLocalAccountId;
        private String mUserName;
        private String mTokenType;
        private String mClientId;
        private String mFamilyId;
        private String mScope;
        private String mClientInfo;
        private String mAuthority;
        private String mEnvironment;
        private String mTenantId;
        private long mExpiresOn;
        private long mExtendedExpiresOn;
        private long mCachedAt;
        private String mSpeRing;
        private String mRefreshTokenAge;
        private boolean mSuccess;
        private String mNegotiatedBrokerProtocolVersion;
        private List<ICacheRecord> mTenantProfileData;
        private boolean mServicedFromCache;
        private String mErrorCode;
        private String mErrorMessage;
        private String mCorrelationId;
        private String mSubErrorCode;
        private int mHttpStatusCode;
        private String mHttpResponseHeaders;
        private String mHttpResponseBody;
        private String mCliTelemErrorCode;
        private String mCliTelemSubErrorCode;
        private String mExceptionType;

        public Builder accessToken(@Nullable String accessToken) {
            this.mAccessToken = accessToken;
            return this;
        }

        public Builder idToken(@Nullable String idToken) {
            this.mIdToken = idToken;
            return this;
        }

        public Builder refreshToken(@Nullable String refreshToken) {
            this.mRefreshToken = refreshToken;
            return this;
        }

        public Builder homeAccountId(@Nullable String homeAccountId) {
            this.mHomeAccountId = homeAccountId;
            return this;
        }

        public Builder localAccountId(@Nullable String localAccountId) {
            this.mLocalAccountId = localAccountId;
            return this;
        }

        public Builder userName(@Nullable String userName) {
            this.mUserName = userName;
            return this;
        }

        public Builder tokenType(@Nullable String tokenType) {
            this.mTokenType = tokenType;
            return this;
        }

        public Builder clientId(@Nullable String clientId) {
            this.mClientId = clientId;
            return this;
        }

        public Builder familyId(@Nullable String familyId) {
            this.mFamilyId = familyId;
            return this;
        }

        public Builder scope(@Nullable String scope) {
            this.mScope = scope;
            return this;
        }

        public Builder clientInfo(@Nullable String clientInfo) {
            this.mClientInfo = clientInfo;
            return this;
        }

        public Builder authority(@Nullable String authority) {
            this.mAuthority = authority;
            return this;
        }

        public Builder environment(@Nullable String environment) {
            this.mEnvironment = environment;
            return this;
        }

        public Builder tenantId(@Nullable String tenantId) {
            this.mTenantId = tenantId;
            return this;
        }

        public Builder expiresOn(long mExpiresOn) {
            this.mExpiresOn = mExpiresOn;
            return this;
        }

        public Builder extendedExpiresOn(long extendedExpiresOn) {
            this.mExtendedExpiresOn = extendedExpiresOn;
            return this;
        }

        public Builder cachedAt(long cachedAt) {
            this.mCachedAt = cachedAt;
            return this;
        }

        public Builder speRing(String speRing) {
            this.mSpeRing = speRing;
            return this;
        }

        public Builder refreshTokenAge(String refreshTokenAge) {
            this.mRefreshTokenAge = refreshTokenAge;
            return this;
        }

        public Builder success(boolean success) {
            this.mSuccess = success;
            return this;
        }

        public Builder servicedFromCache(boolean servicedFromCache) {
            this.mServicedFromCache = servicedFromCache;
            return this;
        }

        public Builder negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.mNegotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.mErrorCode = errorCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.mCorrelationId = correlationId;
            return this;
        }

        public Builder oauthSubErrorCode(String subErrorCode) {
            this.mSubErrorCode = subErrorCode;
            return this;
        }

        public Builder httpStatusCode(int httpStatusCode) {
            this.mHttpStatusCode = httpStatusCode;
            return this;
        }

        public Builder httpResponseHeaders(String httpResponseHeaders) {
            this.mHttpResponseHeaders = httpResponseHeaders;
            return this;
        }

        public Builder httpResponseBody(String httpResponseBody) {
            this.mHttpResponseBody = httpResponseBody;
            return this;
        }

        public Builder cliTelemErrorCode(String cliTelemErrorCode) {
            this.mCliTelemErrorCode = cliTelemErrorCode;
            return this;
        }

        public Builder cliTelemSubErrorCode(String cliTelemSubErrorCode) {
            this.mCliTelemSubErrorCode = cliTelemSubErrorCode;
            return this;
        }

        public BrokerResult build() {
            return new BrokerResult(this);
        }

        public Builder tenantProfileRecords(List<ICacheRecord> cacheRecordWithTenantProfileData) {
            this.mTenantProfileData = cacheRecordWithTenantProfileData;
            return this;
        }

        public Builder exceptionType(String exceptionType) {
            this.mExceptionType = exceptionType;
            return this;
        }
    }

    private class SerializedNames {
        static final String TENANT_PROFILE_CACHE_RECORDS = "tenant_profile_cache_records";
        static final String ACCESS_TOKEN = "access_token";
        static final String ID_TOKEN = "id_token";
        static final String REFRESH_TOKEN = "refresh_token";
        static final String HOME_ACCOUNT_ID = "home_account_id";
        static final String LOCAL_ACCOUNT_ID = "local_account_id";
        static final String USERNAME = "username";
        static final String CLIENT_ID = "client_id";
        static final String FAMILY_ID = "family_id";
        static final String SCOPES = "scopes";
        static final String TOKEN_TYPE = "token_type";
        static final String CLIENT_INFO = "client_info";
        static final String AUTHORITY = "authority";
        static final String ENVIRONMENT = "environment";
        static final String TENANT_ID = "tenant_id";
        static final String EXPIRES_ON = "expires_on";
        static final String EXTENDED_EXPIRES_ON = "ext_expires_on";
        static final String CACHED_AT = "cached_at";
        static final String REFRESH_TOKEN_AGE = "refresh_token_age";
        static final String SUCCESS = "success";
        static final String SERVICED_FROM_CACHE = "serviced_from_cache";
        static final String BROKER_ERROR_CODE = "broker_error_code";
        static final String BROKER_ERROR_MESSAGE = "broker_error_message";
        static final String BROKER_EXCEPTION_TYPE = "broker_exception_type";
        static final String OAUTH_SUB_ERROR = "oauth_sub_error";
        static final String HTTP_RESPONSE_CODE = "http_response_code";
        static final String HTTP_HEADERS = "http_response_headers";
        static final String HTTP_RESPONSE_BODY = "http_response_body";
        static final String CORRELATION_ID = "correlation_id";
        static final String SPE_RING = "spe_ring";
        static final String CLI_TELEM_ERRORCODE = "cli_telem_error_code";
        static final String CLI_TELEM_SUB_ERROR_CODE = "cli_telem_suberror_code";

        private SerializedNames() {
        }
    }
}

