/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.AccountsInOneOrganization;
import com.microsoft.identity.common.internal.authorities.AllAccounts;
import com.microsoft.identity.common.internal.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.common.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdProviderConfigurationClient;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import java.util.Locale;

public abstract class AzureActiveDirectoryAudience {
    private static final String TAG = AzureActiveDirectoryAudience.class.getSimpleName();
    private String mCloudUrl;
    @SerializedName(value="tenant_id")
    private String mTenantId;
    public static final String ORGANIZATIONS = "organizations";
    public static final String CONSUMERS = "consumers";
    public static final String ALL = "common";
    public static final String MSA_MEGA_TENANT_ID = "9188040d-6c67-4c5b-b112-36a304b66dad";

    public String getCloudUrl() {
        if (this.mCloudUrl == null) {
            return AzureActiveDirectory.getDefaultCloudUrl();
        }
        return this.mCloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.mCloudUrl = cloudUrl;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    @WorkerThread
    public String getTenantUuidForAlias(@NonNull String authority) throws ServiceException, ClientException {
        if (StringUtil.isUuid(this.mTenantId)) {
            return this.mTenantId;
        }
        OpenIdProviderConfiguration providerConfiguration = AzureActiveDirectoryAudience.loadOpenIdProviderConfigurationMetadata(authority);
        String issuer = providerConfiguration.getIssuer();
        Uri issuerUri = Uri.parse((String)issuer);
        List paths = issuerUri.getPathSegments();
        if (paths.isEmpty()) {
            String errMsg = "OpenId Metadata did not contain a path to the tenant";
            com.microsoft.identity.common.internal.logging.Logger.error(TAG, "OpenId Metadata did not contain a path to the tenant", null);
            throw new ClientException("OpenId Metadata did not contain a path to the tenant");
        }
        String tenantUUID = (String)paths.get(0);
        if (!StringUtil.isUuid(tenantUUID)) {
            String errMsg = "OpenId Metadata did not contain UUID in the path ";
            Logger.error(TAG, "OpenId Metadata did not contain UUID in the path ", null);
            throw new ClientException("OpenId Metadata did not contain UUID in the path ");
        }
        return tenantUUID;
    }

    public static boolean isHomeTenantAlias(@NonNull String tenantId) {
        return tenantId.equalsIgnoreCase(ALL) || tenantId.equalsIgnoreCase(CONSUMERS) || tenantId.equalsIgnoreCase(ORGANIZATIONS);
    }

    private static OpenIdProviderConfiguration loadOpenIdProviderConfigurationMetadata(@NonNull String requestAuthority) throws ServiceException {
        String methodName = ":loadOpenIdProviderConfigurationMetadata";
        com.microsoft.identity.common.internal.logging.Logger.info(TAG + ":loadOpenIdProviderConfigurationMetadata", "Loading OpenId Provider Metadata...");
        OpenIdProviderConfigurationClient client = new OpenIdProviderConfigurationClient(requestAuthority);
        return client.loadOpenIdProviderConfiguration();
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public static AzureActiveDirectoryAudience getAzureActiveDirectoryAudience(String cloudUrl, String tenantId) {
        String methodName = ":getAzureActiveDirectoryAudience";
        AzureActiveDirectoryAudience audience = null;
        switch (tenantId.toLowerCase(Locale.ROOT)) {
            case "organizations": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyOrganizationalAccount");
                audience = new AnyOrganizationalAccount(cloudUrl);
                break;
            }
            case "consumers": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyPersonalAccount");
                audience = new AnyPersonalAccount(cloudUrl);
                break;
            }
            case "common": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AllAccounts");
                audience = new AllAccounts(cloudUrl);
                break;
            }
            default: {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AccountsInOneOrganization");
                audience = new AccountsInOneOrganization(cloudUrl, tenantId);
            }
        }
        return audience;
    }
}

