/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authscheme;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.internal.authscheme.TokenAuthenticationScheme;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.util.IClockSkewManager;
import java.net.URL;

public class PopAuthenticationSchemeInternal
extends TokenAuthenticationScheme
implements IPoPAuthenticationSchemeParams {
    private static final long serialVersionUID = 788393037295696358L;
    public static final String SCHEME_POP = "PoP";
    private transient IClockSkewManager mClockSkewManager;
    @SerializedName(value="http_method")
    private String mHttpMethod;
    @SerializedName(value="url")
    private URL mUrl;
    @SerializedName(value="nonce")
    private String mNonce;
    @SerializedName(value="client_claims")
    private String mClientClaims;

    PopAuthenticationSchemeInternal() {
        super(SCHEME_POP);
    }

    @Deprecated
    public PopAuthenticationSchemeInternal(@NonNull IClockSkewManager clockSkewManager, @Nullable String httpMethod, @NonNull URL url, @Nullable String nonce) {
        super(SCHEME_POP);
        this.mClockSkewManager = clockSkewManager;
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
    }

    public PopAuthenticationSchemeInternal(@NonNull IClockSkewManager clockSkewManager, @Nullable String httpMethod, @NonNull URL url, @Nullable String nonce, @Nullable String clientClaims) {
        super(SCHEME_POP);
        this.mClockSkewManager = clockSkewManager;
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
        this.mClientClaims = clientClaims;
    }

    public PopAuthenticationSchemeInternal(@Nullable String httpMethod, @NonNull URL url, @Nullable String nonce, @Nullable String clientClaims) {
        super(SCHEME_POP);
        this.mClockSkewManager = null;
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
        this.mClientClaims = clientClaims;
    }

    @Override
    public String getAccessTokenForScheme(@NonNull String accessToken) throws ClientException {
        if (null == this.mClockSkewManager) {
            throw new RuntimeException("IClockSkewManager not initialized.");
        }
        long ONE_SECOND_MILLIS = 1000L;
        long timestampMillis = this.mClockSkewManager.getAdjustedReferenceTime().getTime();
        return Device.getDevicePoPManagerInstance().mintSignedAccessToken(this.getHttpMethod(), timestampMillis / 1000L, this.getUrl(), accessToken, this.getNonce(), this.getClientClaims());
    }

    public void setClockSkewManager(@NonNull IClockSkewManager clockSkewManager) {
        this.mClockSkewManager = clockSkewManager;
    }

    @Override
    @Nullable
    public String getHttpMethod() {
        return this.mHttpMethod;
    }

    @Override
    public URL getUrl() {
        return this.mUrl;
    }

    @Override
    public String getClientClaims() {
        return this.mClientClaims;
    }

    @Override
    @Nullable
    public String getNonce() {
        return this.mNonce;
    }

    public static final class SerializedNames {
        public static final String HTTP_METHOD = "http_method";
        public static final String URL = "url";
        public static final String NONCE = "nonce";
        public static final String CLIENT_CLAIMS = "client_claims";
    }
}

